/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.minidnsrepl;

import java.io.IOException;
import java.util.Arrays;
import org.minidns.AbstractDnsClient;
import org.minidns.DnsCache;
import org.minidns.dnsqueryresult.DnsQueryResult;
import org.minidns.dnssec.DnssecClient;
import org.minidns.integrationtest.IntegrationTestTools;
import org.minidns.record.Record;
import org.minidns.source.NetworkDataSourceWithAccounting;

public class MiniDnsStats {
    public static void main(String[] args) throws IOException {
        MiniDnsStats.showDnssecStats();
    }

    public static void showDnssecStats() throws IOException {
        MiniDnsStats.showDnssecStats("siccegge.de", Record.TYPE.A);
    }

    public static void showDnssecStats(String name, Record.TYPE type) throws IOException {
        DnssecClient client = MiniDnsStats.getClient(IntegrationTestTools.CacheConfig.without);
        System.out.println(MiniDnsStats.gatherStatsFor(client, "Without Cache", name, type));
        client = MiniDnsStats.getClient(IntegrationTestTools.CacheConfig.normal);
        System.out.println(MiniDnsStats.gatherStatsFor(client, "With Cache", name, type));
        client = MiniDnsStats.getClient(IntegrationTestTools.CacheConfig.extended);
        System.out.println(MiniDnsStats.gatherStatsFor(client, "With Extended Cache", name, type));
        client = MiniDnsStats.getClient(IntegrationTestTools.CacheConfig.full);
        System.out.println(MiniDnsStats.gatherStatsFor(client, "With Full Cache", name, type));
    }

    public static StringBuilder gatherStatsFor(DnssecClient client, String testName, String name, Record.TYPE type) throws IOException {
        long start = System.currentTimeMillis();
        DnsQueryResult result = client.query((CharSequence)name, type);
        long stop = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        sb.append(testName).append('\n');
        char[] headline = new char[testName.length()];
        Arrays.fill(headline, '#');
        sb.append(headline).append('\n');
        sb.append(result).append('\n');
        sb.append("Took ").append(stop - start).append("ms").append('\n');
        sb.append((CharSequence)MiniDnsStats.getStats((AbstractDnsClient)client)).append('\n');
        sb.append('\n');
        return sb;
    }

    public static DnssecClient getClient(IntegrationTestTools.CacheConfig cacheConfig) {
        return IntegrationTestTools.getClient((IntegrationTestTools.CacheConfig)cacheConfig);
    }

    public static StringBuilder getStats(AbstractDnsClient client) {
        StringBuilder sb = new StringBuilder();
        NetworkDataSourceWithAccounting ndswa = NetworkDataSourceWithAccounting.from((AbstractDnsClient)client);
        if (ndswa != null) {
            sb.append(ndswa.getStats().toString());
        } else {
            sb.append("Client is not using " + NetworkDataSourceWithAccounting.class.getSimpleName());
        }
        DnsCache dnsCache = client.getCache();
        if (dnsCache != null) {
            sb.append(dnsCache);
        } else {
            sb.append("Client is not using a Cache");
        }
        return sb;
    }
}

