/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ping.android;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.SystemClock;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smackx.ping.PingManager;

public class ServerPingWithAlarmManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(ServerPingWithAlarmManager.class.getName());
    private static final String PING_ALARM_ACTION = "org.igniterealtime.smackx.ping.ACTION";
    private static final Map<XMPPConnection, ServerPingWithAlarmManager> INSTANCES = new WeakHashMap<XMPPConnection, ServerPingWithAlarmManager>();
    private boolean mEnabled = true;
    private static final BroadcastReceiver ALARM_BROADCAST_RECEIVER;
    private static Context sContext;
    private static PendingIntent sPendingIntent;
    private static AlarmManager sAlarmManager;

    public static synchronized ServerPingWithAlarmManager getInstanceFor(XMPPConnection connection) {
        ServerPingWithAlarmManager serverPingWithAlarmManager = INSTANCES.get(connection);
        if (serverPingWithAlarmManager == null) {
            serverPingWithAlarmManager = new ServerPingWithAlarmManager(connection);
            INSTANCES.put(connection, serverPingWithAlarmManager);
        }
        return serverPingWithAlarmManager;
    }

    private ServerPingWithAlarmManager(XMPPConnection connection) {
        super(connection);
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public static void onCreate(Context context) {
        sContext = context;
        context.registerReceiver(ALARM_BROADCAST_RECEIVER, new IntentFilter(PING_ALARM_ACTION));
        sAlarmManager = (AlarmManager)context.getSystemService("alarm");
        sPendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(PING_ALARM_ACTION), (int)0);
        sAlarmManager.setInexactRepeating(2, SystemClock.elapsedRealtime() + 1800000L, 1800000L, sPendingIntent);
    }

    public static void onDestroy() {
        sContext.unregisterReceiver(ALARM_BROADCAST_RECEIVER);
        sAlarmManager.cancel(sPendingIntent);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                ServerPingWithAlarmManager.getInstanceFor(connection);
            }
        });
        ALARM_BROADCAST_RECEIVER = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                LOGGER.fine("Ping Alarm broadcast received");
                Class<ServerPingWithAlarmManager> clazz = ServerPingWithAlarmManager.class;
                synchronized (ServerPingWithAlarmManager.class) {
                    HashSet managers = new HashSet(INSTANCES.entrySet());
                    // ** MonitorExit[clazz] (shouldn't be in output)
                    for (Map.Entry entry : managers) {
                        XMPPConnection connection = (XMPPConnection)entry.getKey();
                        if (((ServerPingWithAlarmManager)((Object)entry.getValue())).isEnabled()) {
                            LOGGER.fine("Calling pingServerIfNecessary for connection " + connection.getConnectionCounter());
                            final PingManager pingManager = PingManager.getInstanceFor((XMPPConnection)connection);
                            Async.go((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    pingManager.pingServerIfNecessary();
                                }
                            }, (String)("PingServerIfNecessary (" + connection.getConnectionCounter() + ')'));
                            continue;
                        }
                        LOGGER.fine("NOT calling pingServerIfNecessary (disabled) on connection " + connection.getConnectionCounter());
                    }
                    return;
                }
            }
        };
    }
}

