/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.debugger.android;

import android.util.Log;
import java.io.Reader;
import java.io.Writer;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.ObservableReader;
import org.jivesoftware.smack.util.ObservableWriter;
import org.jivesoftware.smack.util.ReaderListener;
import org.jivesoftware.smack.util.WriterListener;

public class AndroidDebugger
implements SmackDebugger {
    public static boolean printInterpreted = false;
    private XMPPConnection connection = null;
    private PacketListener listener = null;
    private ConnectionListener connListener = null;
    private Writer writer;
    private Reader reader;
    private ReaderListener readerListener;
    private WriterListener writerListener;

    public AndroidDebugger(XMPPConnection connection, Writer writer, Reader reader) {
        this.connection = connection;
        this.writer = writer;
        this.reader = reader;
        this.createDebug();
    }

    private void createDebug() {
        ObservableReader debugReader = new ObservableReader(this.reader);
        this.readerListener = new ReaderListener(){

            public void read(String str) {
                Log.d((String)"SMACK", (String)("RCV (" + AndroidDebugger.this.connection.getConnectionCounter() + "): " + str));
            }
        };
        debugReader.addReaderListener(this.readerListener);
        ObservableWriter debugWriter = new ObservableWriter(this.writer);
        this.writerListener = new WriterListener(){

            public void write(String str) {
                Log.d((String)"SMACK", (String)("SENT (" + AndroidDebugger.this.connection.getConnectionCounter() + "): " + str));
            }
        };
        debugWriter.addWriterListener(this.writerListener);
        this.reader = debugReader;
        this.writer = debugWriter;
        this.listener = new PacketListener(){

            public void processPacket(Packet packet) {
                if (printInterpreted) {
                    Log.d((String)"SMACK", (String)("RCV PKT (" + AndroidDebugger.this.connection.getConnectionCounter() + "): " + packet.toXML()));
                }
            }
        };
        this.connListener = new AbstractConnectionListener(){

            public void connectionClosed() {
                Log.d((String)"SMACK", (String)("Connection closed (" + AndroidDebugger.this.connection.getConnectionCounter() + ")"));
            }

            public void connectionClosedOnError(Exception e) {
                Log.d((String)"SMACK", (String)("Connection closed due to an exception (" + AndroidDebugger.this.connection.getConnectionCounter() + ")"));
            }

            public void reconnectionFailed(Exception e) {
                Log.d((String)"SMACK", (String)("Reconnection failed due to an exception (" + AndroidDebugger.this.connection.getConnectionCounter() + ")"));
            }

            public void reconnectionSuccessful() {
                Log.d((String)"SMACK", (String)("Connection reconnected (" + AndroidDebugger.this.connection.getConnectionCounter() + ")"));
            }

            public void reconnectingIn(int seconds) {
                Log.d((String)"SMACK", (String)("Connection (" + AndroidDebugger.this.connection.getConnectionCounter() + ") will reconnect in " + seconds));
            }
        };
    }

    public Reader newConnectionReader(Reader newReader) {
        ((ObservableReader)this.reader).removeReaderListener(this.readerListener);
        ObservableReader debugReader = new ObservableReader(newReader);
        debugReader.addReaderListener(this.readerListener);
        this.reader = debugReader;
        return this.reader;
    }

    public Writer newConnectionWriter(Writer newWriter) {
        ((ObservableWriter)this.writer).removeWriterListener(this.writerListener);
        ObservableWriter debugWriter = new ObservableWriter(newWriter);
        debugWriter.addWriterListener(this.writerListener);
        this.writer = debugWriter;
        return this.writer;
    }

    public void userHasLogged(String user) {
        String title = "User logged (" + this.connection.getConnectionCounter() + "): " + user + "@" + this.connection.getServiceName() + ":" + this.connection.getPort();
        Log.d((String)"SMACK", (String)title);
        this.connection.addConnectionListener(this.connListener);
    }

    public Reader getReader() {
        return this.reader;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public PacketListener getReaderListener() {
        return this.listener;
    }

    public PacketListener getWriterListener() {
        return null;
    }
}

