/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.stringencoder.android;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import org.jivesoftware.smack.util.stringencoder.StringEncoder;

public class AndroidBase64UrlSafeEncoder
implements StringEncoder {
    private static AndroidBase64UrlSafeEncoder instance = new AndroidBase64UrlSafeEncoder();
    private static final int BASE64_ENCODER_FLAGS = 10;

    private AndroidBase64UrlSafeEncoder() {
    }

    public static AndroidBase64UrlSafeEncoder getInstance() {
        return instance;
    }

    public String encode(String string) {
        try {
            return Base64.encodeToString((byte[])string.getBytes("UTF-8"), (int)10);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 not supported", e);
        }
    }

    public String decode(String string) {
        byte[] bytes = Base64.decode((String)string, (int)10);
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 not supported", e);
        }
    }
}

