/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.bosh;

import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.sasl.SaslException;
import org.igniterealtime.jbosh.BOSHClient;
import org.igniterealtime.jbosh.BOSHClientConfig;
import org.igniterealtime.jbosh.BOSHClientConnEvent;
import org.igniterealtime.jbosh.BOSHClientConnListener;
import org.igniterealtime.jbosh.BOSHClientRequestListener;
import org.igniterealtime.jbosh.BOSHClientResponseListener;
import org.igniterealtime.jbosh.BOSHException;
import org.igniterealtime.jbosh.BOSHMessageEvent;
import org.igniterealtime.jbosh.BodyQName;
import org.igniterealtime.jbosh.ComposableBody;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.bosh.BOSHConfiguration;
import org.jivesoftware.smack.bosh.BOSHPacketReader;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.StringUtils;

public class XMPPBOSHConnection
extends XMPPConnection {
    private static final Logger LOGGER = Logger.getLogger(XMPPBOSHConnection.class.getName());
    public static final String XMPP_BOSH_NS = "urn:xmpp:xbosh";
    public static final String BOSH_URI = "http://jabber.org/protocol/httpbind";
    private BOSHClient client;
    private final BOSHConfiguration config;
    private boolean connected = false;
    private boolean authenticated = false;
    private boolean anonymous = false;
    private boolean isFirstInitialization = true;
    private boolean wasAuthenticated = false;
    private boolean done = false;
    private PipedWriter readerPipe;
    private Thread readerConsumer;
    protected String authID = null;
    protected String sessionID = null;
    private String user = null;

    public XMPPBOSHConnection(boolean https, String host, int port, String filePath, String xmppDomain) {
        super((ConnectionConfiguration)new BOSHConfiguration(https, host, port, filePath, xmppDomain));
        this.config = (BOSHConfiguration)this.getConfiguration();
    }

    public XMPPBOSHConnection(BOSHConfiguration config) {
        super((ConnectionConfiguration)config);
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectInternal() throws SmackException {
        if (this.connected) {
            throw new IllegalStateException("Already connected to a server.");
        }
        this.done = false;
        try {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
            this.sessionID = null;
            this.authID = null;
            BOSHClientConfig.Builder cfgBuilder = BOSHClientConfig.Builder.create((URI)this.config.getURI(), (String)this.config.getServiceName());
            if (this.config.isProxyEnabled()) {
                cfgBuilder.setProxy(this.config.getProxyAddress(), this.config.getProxyPort());
            }
            this.client = BOSHClient.create((BOSHClientConfig)cfgBuilder.build());
            this.client.addBOSHClientConnListener((BOSHClientConnListener)new BOSHConnectionListener(this));
            this.client.addBOSHClientResponseListener((BOSHClientResponseListener)new BOSHPacketReader(this));
            if (this.config.isDebuggerEnabled()) {
                this.initDebugger();
                if (this.isFirstInitialization) {
                    if (this.debugger.getReaderListener() != null) {
                        this.addPacketListener(this.debugger.getReaderListener(), null);
                    }
                    if (this.debugger.getWriterListener() != null) {
                        this.addPacketSendingListener(this.debugger.getWriterListener(), null);
                    }
                }
            }
            this.client.send(ComposableBody.builder().setNamespaceDefinition("xmpp", XMPP_BOSH_NS).setAttribute(BodyQName.createWithPrefix((String)XMPP_BOSH_NS, (String)"version", (String)"xmpp"), "1.0").build());
        }
        catch (Exception e) {
            throw new SmackException.ConnectionException((Throwable)e);
        }
        XMPPBOSHConnection e = this;
        synchronized (e) {
            if (!this.connected) {
                try {
                    ((Object)((Object)this)).wait(this.getPacketReplyTimeout());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (!this.connected && !this.done) {
            this.done = true;
            String errorMessage = "Timeout reached for the connection to " + this.getHost() + ":" + this.getPort() + ".";
            throw new SmackException(errorMessage);
        }
        this.callConnectionConnectedListener();
    }

    public String getConnectionID() {
        if (!this.connected) {
            return null;
        }
        if (this.authID != null) {
            return this.authID;
        }
        return this.sessionID;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isSecureConnection() {
        return false;
    }

    public boolean isUsingCompression() {
        return false;
    }

    public void login(String username, String password, String resource) throws XMPPException, SmackException, IOException {
        if (!this.isConnected()) {
            throw new SmackException.NotConnectedException();
        }
        if (this.authenticated) {
            throw new SmackException.AlreadyLoggedInException();
        }
        username = username.toLowerCase(Locale.US).trim();
        if (this.saslAuthentication.hasNonAnonymousAuthentication()) {
            if (password != null) {
                this.saslAuthentication.authenticate(username, password, resource);
            } else {
                this.saslAuthentication.authenticate(resource, this.config.getCallbackHandler());
            }
        } else {
            throw new SaslException("No non-anonymous SASL authentication mechanism available");
        }
        String response = this.bindResourceAndEstablishSession(resource);
        if (response != null) {
            this.user = response;
            this.setServiceName(StringUtils.parseServer((String)response));
        } else {
            this.user = username + "@" + this.getServiceName();
            if (resource != null) {
                this.user = this.user + "/" + resource;
            }
        }
        if (this.config.isSendPresence()) {
            this.sendPacket((Packet)new Presence(Presence.Type.available));
        }
        this.authenticated = true;
        this.anonymous = false;
        this.setLoginInfo(username, password, resource);
        if (this.config.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
        this.callConnectionAuthenticatedListener();
    }

    public void loginAnonymously() throws XMPPException, SmackException, IOException {
        String response;
        if (!this.isConnected()) {
            throw new SmackException.NotConnectedException();
        }
        if (this.authenticated) {
            throw new SmackException.AlreadyLoggedInException();
        }
        if (!this.saslAuthentication.hasAnonymousAuthentication()) {
            throw new SaslException("No anonymous SASL authentication mechanism available");
        }
        this.saslAuthentication.authenticateAnonymously();
        this.user = response = this.bindResourceAndEstablishSession(null);
        this.setServiceName(StringUtils.parseServer((String)response));
        if (this.config.isSendPresence()) {
            this.sendPacket((Packet)new Presence(Presence.Type.available));
        }
        this.authenticated = true;
        this.anonymous = true;
        if (this.config.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
        this.callConnectionAuthenticatedListener();
    }

    protected void sendPacketInternal(Packet packet) throws SmackException.NotConnectedException {
        if (this.done) {
            throw new SmackException.NotConnectedException();
        }
        try {
            this.send(ComposableBody.builder().setPayloadXML(packet.toXML().toString()).build());
        }
        catch (BOSHException e) {
            LOGGER.log(Level.SEVERE, "BOSHException in sendPacketInternal", e);
        }
    }

    protected void shutdown() {
        this.setWasAuthenticated(this.authenticated);
        this.authID = null;
        this.sessionID = null;
        this.done = true;
        this.authenticated = false;
        this.connected = false;
        this.isFirstInitialization = false;
        Presence unavailablePresence = new Presence(Presence.Type.unavailable);
        try {
            this.client.disconnect(ComposableBody.builder().setNamespaceDefinition("xmpp", XMPP_BOSH_NS).setPayloadXML(unavailablePresence.toXML().toString()).build());
            Thread.sleep(150L);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.readerPipe != null) {
            try {
                this.readerPipe.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.writer = null;
        }
        this.readerConsumer = null;
    }

    protected void send(ComposableBody body) throws BOSHException {
        if (!this.connected) {
            throw new IllegalStateException("Not connected to a server!");
        }
        if (body == null) {
            throw new NullPointerException("Body mustn't be null!");
        }
        if (this.sessionID != null) {
            body = body.rebuild().setAttribute(BodyQName.create((String)BOSH_URI, (String)"sid"), this.sessionID).build();
        }
        this.client.send(body);
    }

    protected void initDebugger() {
        this.writer = new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
            }

            @Override
            public void close() {
            }

            @Override
            public void flush() {
            }
        };
        try {
            this.readerPipe = new PipedWriter();
            this.reader = new PipedReader(this.readerPipe);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.initDebugger();
        this.client.addBOSHClientResponseListener(new BOSHClientResponseListener(){

            public void responseReceived(BOSHMessageEvent event) {
                if (event.getBody() != null) {
                    try {
                        XMPPBOSHConnection.this.readerPipe.write(event.getBody().toXML());
                        XMPPBOSHConnection.this.readerPipe.flush();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.client.addBOSHClientRequestListener(new BOSHClientRequestListener(){

            public void requestSent(BOSHMessageEvent event) {
                if (event.getBody() != null) {
                    try {
                        XMPPBOSHConnection.this.writer.write(event.getBody().toXML());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.readerConsumer = new Thread(){
            private Thread thread = this;
            private int bufferLength = 1024;

            @Override
            public void run() {
                try {
                    char[] cbuf = new char[this.bufferLength];
                    while (XMPPBOSHConnection.this.readerConsumer == this.thread && !XMPPBOSHConnection.this.done) {
                        XMPPBOSHConnection.this.reader.read(cbuf, 0, this.bufferLength);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this.readerConsumer.setDaemon(true);
        this.readerConsumer.start();
    }

    protected void notifyConnectionError(Exception e) {
        this.shutdown();
        this.callConnectionClosedOnErrorListener(e);
    }

    protected void processPacket(Packet packet) {
        super.processPacket(packet);
    }

    protected SASLAuthentication getSASLAuthentication() {
        return super.getSASLAuthentication();
    }

    protected void serverRequiresBinding() {
        super.serverRequiresBinding();
    }

    protected void serverSupportsSession() {
        super.serverSupportsSession();
    }

    protected void serverSupportsAccountCreation() {
        super.serverSupportsAccountCreation();
    }

    private class BOSHConnectionListener
    implements BOSHClientConnListener {
        private final XMPPBOSHConnection connection;

        public BOSHConnectionListener(XMPPBOSHConnection connection) {
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionEvent(BOSHClientConnEvent connEvent) {
            block18: {
                try {
                    if (connEvent.isConnected()) {
                        XMPPBOSHConnection.this.connected = true;
                        if (XMPPBOSHConnection.this.isFirstInitialization) {
                            XMPPBOSHConnection.this.isFirstInitialization = false;
                            for (ConnectionCreationListener listener : XMPPBOSHConnection.getConnectionCreationListeners()) {
                                listener.connectionCreated((XMPPConnection)this.connection);
                            }
                            break block18;
                        }
                        try {
                            if (XMPPBOSHConnection.this.wasAuthenticated) {
                                this.connection.login(XMPPBOSHConnection.this.config.getUsername(), XMPPBOSHConnection.this.config.getPassword(), XMPPBOSHConnection.this.config.getResource());
                            }
                            for (ConnectionListener listener : XMPPBOSHConnection.this.getConnectionListeners()) {
                                listener.reconnectionSuccessful();
                            }
                            break block18;
                        }
                        catch (Exception e) {
                            for (ConnectionListener listener : XMPPBOSHConnection.this.getConnectionListeners()) {
                                listener.reconnectionFailed(e);
                            }
                            break block18;
                        }
                    }
                    if (connEvent.isError()) {
                        Throwable cause = connEvent.getCause();
                        Exception e = cause instanceof Exception ? (Exception)cause : new Exception(cause);
                        XMPPBOSHConnection.this.notifyConnectionError(e);
                    }
                    XMPPBOSHConnection.this.connected = false;
                }
                finally {
                    XMPPBOSHConnection xMPPBOSHConnection = this.connection;
                    synchronized (xMPPBOSHConnection) {
                        ((Object)((Object)this.connection)).notifyAll();
                    }
                }
            }
        }
    }
}

