/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.bosh;

import java.net.URI;
import java.net.URISyntaxException;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.util.dns.HostAddress;

public class BOSHConfiguration
extends ConnectionConfiguration {
    private boolean ssl;
    private String file;

    public BOSHConfiguration(String xmppDomain) {
        super(xmppDomain, 7070);
        this.ssl = false;
        this.file = "/http-bind/";
    }

    public BOSHConfiguration(String xmppDomain, int port) {
        super(xmppDomain, port);
        this.ssl = false;
        this.file = "/http-bind/";
    }

    public BOSHConfiguration(boolean https, String host, int port, String filePath, String xmppDomain) {
        super(host, port, xmppDomain);
        this.ssl = https;
        this.file = filePath != null ? filePath : "/";
    }

    public BOSHConfiguration(boolean https, String host, int port, String filePath, ProxyInfo proxy, String xmppDomain) {
        super(host, port, xmppDomain, proxy);
        this.ssl = https;
        this.file = filePath != null ? filePath : "/";
    }

    public boolean isProxyEnabled() {
        return this.proxy != null && this.proxy.getProxyType() != ProxyInfo.ProxyType.NONE;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxy;
    }

    public String getProxyAddress() {
        return this.proxy != null ? this.proxy.getProxyAddress() : null;
    }

    public int getProxyPort() {
        return this.proxy != null ? this.proxy.getProxyPort() : 8080;
    }

    public boolean isUsingSSL() {
        return this.ssl;
    }

    public URI getURI() throws URISyntaxException {
        int port;
        String host;
        if (this.file.charAt(0) != '/') {
            this.file = '/' + this.file;
        }
        if (this.hostAddresses != null) {
            HostAddress hostAddress = (HostAddress)this.hostAddresses.get(0);
            host = hostAddress.getFQDN();
            port = hostAddress.getPort();
        } else {
            host = this.getServiceName();
            port = 80;
        }
        return new URI((this.ssl ? "https://" : "http://") + host + ":" + port + this.file);
    }
}

