/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.bosh;

import java.io.Reader;
import java.io.StringReader;
import org.igniterealtime.jbosh.AbstractBody;
import org.igniterealtime.jbosh.BOSHClientResponseListener;
import org.igniterealtime.jbosh.BOSHMessageEvent;
import org.igniterealtime.jbosh.BodyQName;
import org.igniterealtime.jbosh.ComposableBody;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.bosh.XMPPBOSHConnection;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.sasl.packet.SaslStreamElements;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class BOSHPacketReader
implements BOSHClientResponseListener {
    private XMPPBOSHConnection connection;

    public BOSHPacketReader(XMPPBOSHConnection connection) {
        this.connection = connection;
    }

    public void responseReceived(BOSHMessageEvent event) {
        block11: {
            AbstractBody body = event.getBody();
            if (body != null) {
                try {
                    if (this.connection.sessionID == null) {
                        this.connection.sessionID = body.getAttribute(BodyQName.create((String)"http://jabber.org/protocol/httpbind", (String)"sid"));
                    }
                    if (this.connection.authID == null) {
                        this.connection.authID = body.getAttribute(BodyQName.create((String)"http://jabber.org/protocol/httpbind", (String)"authid"));
                    }
                    XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
                    parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                    parser.setInput((Reader)new StringReader(body.toXML()));
                    int eventType = parser.getEventType();
                    do {
                        if ((eventType = parser.next()) != 2) continue;
                        Packet packet = PacketParserUtils.parseStanza((XmlPullParser)parser, (XMPPConnection)this.connection);
                        if (packet != null) {
                            this.connection.processPacket(packet);
                            continue;
                        }
                        if (parser.getName().equals("challenge")) {
                            String challengeData = parser.nextText();
                            this.connection.getSASLAuthentication().challengeReceived(challengeData);
                            continue;
                        }
                        if (parser.getName().equals("success")) {
                            this.connection.send(ComposableBody.builder().setNamespaceDefinition("xmpp", "urn:xmpp:xbosh").setAttribute(BodyQName.createWithPrefix((String)"urn:xmpp:xbosh", (String)"restart", (String)"xmpp"), "true").setAttribute(BodyQName.create((String)"http://jabber.org/protocol/httpbind", (String)"to"), this.connection.getServiceName()).build());
                            SaslStreamElements.Success success = new SaslStreamElements.Success(parser.nextText());
                            this.connection.getSASLAuthentication().authenticated(success);
                            continue;
                        }
                        if (parser.getName().equals("features")) {
                            this.parseFeatures(parser);
                            continue;
                        }
                        if (parser.getName().equals("failure")) {
                            if (!"urn:ietf:params:xml:ns:xmpp-sasl".equals(parser.getNamespace(null))) continue;
                            SaslStreamElements.SASLFailure failure = PacketParserUtils.parseSASLFailure((XmlPullParser)parser);
                            this.connection.getSASLAuthentication().authenticationFailed(failure);
                            continue;
                        }
                        if (!parser.getName().equals("error")) continue;
                        throw new XMPPException.StreamErrorException(PacketParserUtils.parseStreamError((XmlPullParser)parser));
                    } while (eventType != 1);
                }
                catch (Exception e) {
                    if (!this.connection.isConnected()) break block11;
                    this.connection.notifyConnectionError(e);
                }
            }
        }
    }

    private void parseFeatures(XmlPullParser parser) throws Exception {
        this.connection.parseFeatures0(parser);
    }
}

