/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.sasl.SaslException;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.filter.IQReplyFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Bind;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Session;

public abstract class XMPPConnection {
    private static final Logger LOGGER = Logger.getLogger(XMPPConnection.class.getName());
    private static final AtomicInteger connectionCounter = new AtomicInteger(0);
    private static final Set<ConnectionCreationListener> connectionEstablishedListeners = new CopyOnWriteArraySet<ConnectionCreationListener>();
    protected final Collection<ConnectionListener> connectionListeners = new CopyOnWriteArrayList<ConnectionListener>();
    protected final Collection<PacketCollector> collectors = new ConcurrentLinkedQueue<PacketCollector>();
    protected final Map<PacketListener, ListenerWrapper> recvListeners = new ConcurrentHashMap<PacketListener, ListenerWrapper>();
    protected final Map<PacketListener, ListenerWrapper> sendListeners = new ConcurrentHashMap<PacketListener, ListenerWrapper>();
    protected final Map<PacketInterceptor, InterceptorWrapper> interceptors = new ConcurrentHashMap<PacketInterceptor, InterceptorWrapper>();
    private long packetReplyTimeout = SmackConfiguration.getDefaultPacketReplyTimeout();
    protected SmackDebugger debugger = null;
    protected Reader reader;
    protected Writer writer;
    protected SASLAuthentication saslAuthentication = new SASLAuthentication(this);
    protected final int connectionCounterValue = connectionCounter.getAndIncrement();
    protected final ConnectionConfiguration config;
    private String serviceCapsNode;
    private FromMode fromMode = FromMode.OMITTED;
    private boolean rosterVersioningSupported = false;
    protected XMPPInputOutputStream compressionHandler;
    private final ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(2, new SmackExecutorThreadFactory(this.connectionCounterValue));
    private Roster roster;
    private String host;
    private int port;
    private AtomicBoolean bindingRequired = new AtomicBoolean(false);
    private boolean sessionSupported;
    private IOException connectionException;
    protected boolean authenticated = false;
    protected boolean wasAuthenticated = false;

    protected XMPPConnection(ConnectionConfiguration configuration) {
        this.config = configuration;
    }

    protected ConnectionConfiguration getConfiguration() {
        return this.config;
    }

    public String getServiceName() {
        return this.config.getServiceName();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public abstract String getUser();

    public abstract String getConnectionID();

    public abstract boolean isConnected();

    public abstract boolean isAuthenticated();

    public abstract boolean isAnonymous();

    public abstract boolean isSecureConnection();

    protected abstract void sendPacketInternal(Packet var1) throws SmackException.NotConnectedException;

    public abstract boolean isUsingCompression();

    public void connect() throws SmackException, IOException, XMPPException {
        this.saslAuthentication.init();
        this.bindingRequired.set(false);
        this.sessionSupported = false;
        this.connectionException = null;
        this.connectInternal();
    }

    protected abstract void connectInternal() throws SmackException, IOException, XMPPException;

    public void login(String username, String password) throws XMPPException, SmackException, SaslException, IOException {
        this.login(username, password, "Smack");
    }

    public abstract void login(String var1, String var2, String var3) throws XMPPException, SmackException, SaslException, IOException;

    public abstract void loginAnonymously() throws XMPPException, SmackException, SaslException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serverRequiresBinding() {
        AtomicBoolean atomicBoolean = this.bindingRequired;
        synchronized (atomicBoolean) {
            this.bindingRequired.set(true);
            this.bindingRequired.notify();
        }
    }

    protected void serverSupportsSession() {
        this.sessionSupported = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String bindResourceAndEstablishSession(String resource) throws XMPPException.XMPPErrorException, SmackException.ResourceBindingNotOfferedException, SmackException.NoResponseException, SmackException.NotConnectedException {
        AtomicBoolean atomicBoolean = this.bindingRequired;
        synchronized (atomicBoolean) {
            if (!this.bindingRequired.get()) {
                try {
                    this.bindingRequired.wait(this.getPacketReplyTimeout());
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.bindingRequired.get()) {
                    throw new SmackException.ResourceBindingNotOfferedException();
                }
            }
        }
        Bind bindResource = new Bind();
        bindResource.setResource(resource);
        Bind response = (Bind)this.createPacketCollectorAndSend(bindResource).nextResultOrThrow();
        String userJID = response.getJid();
        if (this.sessionSupported && !this.getConfiguration().isLegacySessionDisabled()) {
            Session session = new Session();
            this.createPacketCollectorAndSend(session).nextResultOrThrow();
        }
        return userJID;
    }

    protected void setConnectionException(IOException exception) {
        this.connectionException = exception;
    }

    protected void throwConnectionExceptionOrNoResponse() throws IOException, SmackException.NoResponseException {
        if (this.connectionException != null) {
            throw this.connectionException;
        }
        throw new SmackException.NoResponseException();
    }

    protected Reader getReader() {
        return this.reader;
    }

    protected Writer getWriter() {
        return this.writer;
    }

    protected void setServiceName(String serviceName) {
        this.config.setServiceName(serviceName);
    }

    protected void setLoginInfo(String username, String password, String resource) {
        this.config.setLoginInfo(username, password, resource);
    }

    protected void serverSupportsAccountCreation() {
        AccountManager.getInstance(this).setSupportsAccountCreation(true);
    }

    protected void maybeResolveDns() throws Exception {
        this.config.maybeResolveDns();
    }

    public void sendPacket(Packet packet) throws SmackException.NotConnectedException {
        if (!this.isConnected()) {
            throw new SmackException.NotConnectedException();
        }
        if (packet == null) {
            throw new NullPointerException("Packet is null.");
        }
        switch (this.fromMode) {
            case OMITTED: {
                packet.setFrom(null);
                break;
            }
            case USER: {
                packet.setFrom(this.getUser());
                break;
            }
        }
        this.firePacketInterceptors(packet);
        this.sendPacketInternal(packet);
        this.firePacketSendingListeners(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Roster getRoster() {
        if (this.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster");
        }
        Object object = this;
        synchronized (object) {
            if (this.roster == null) {
                this.roster = new Roster(this);
            }
            if (!this.isAuthenticated()) {
                return this.roster;
            }
        }
        if (!this.roster.rosterInitialized && this.config.isRosterLoadedAtLogin()) {
            try {
                object = this.roster;
                synchronized (object) {
                    long now;
                    long start = System.currentTimeMillis();
                    for (long waitTime = this.getPacketReplyTimeout(); !this.roster.rosterInitialized && waitTime > 0L; waitTime -= now - start) {
                        this.roster.wait(waitTime);
                        now = System.currentTimeMillis();
                        start = now;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.roster;
    }

    protected SASLAuthentication getSASLAuthentication() {
        return this.saslAuthentication;
    }

    public void disconnect() throws SmackException.NotConnectedException {
        this.disconnect(new Presence(Presence.Type.unavailable));
    }

    public synchronized void disconnect(Presence unavailablePresence) throws SmackException.NotConnectedException {
        if (!this.isConnected()) {
            return;
        }
        this.sendPacket(unavailablePresence);
        this.shutdown();
        this.callConnectionClosedListener();
    }

    protected abstract void shutdown();

    public static void addConnectionCreationListener(ConnectionCreationListener connectionCreationListener) {
        connectionEstablishedListeners.add(connectionCreationListener);
    }

    public static void removeConnectionCreationListener(ConnectionCreationListener connectionCreationListener) {
        connectionEstablishedListeners.remove(connectionCreationListener);
    }

    protected static Collection<ConnectionCreationListener> getConnectionCreationListeners() {
        return Collections.unmodifiableCollection(connectionEstablishedListeners);
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        if (connectionListener == null) {
            return;
        }
        if (!this.connectionListeners.contains(connectionListener)) {
            this.connectionListeners.add(connectionListener);
        }
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.remove(connectionListener);
    }

    protected Collection<ConnectionListener> getConnectionListeners() {
        return this.connectionListeners;
    }

    public PacketCollector createPacketCollectorAndSend(IQ packet) throws SmackException.NotConnectedException {
        IQReplyFilter packetFilter = new IQReplyFilter(packet, this);
        PacketCollector packetCollector = this.createPacketCollector(packetFilter);
        this.sendPacket(packet);
        return packetCollector;
    }

    public PacketCollector createPacketCollector(PacketFilter packetFilter) {
        PacketCollector collector = new PacketCollector(this, packetFilter);
        this.collectors.add(collector);
        return collector;
    }

    protected void removePacketCollector(PacketCollector collector) {
        this.collectors.remove(collector);
    }

    protected Collection<PacketCollector> getPacketCollectors() {
        return this.collectors;
    }

    public void addPacketListener(PacketListener packetListener, PacketFilter packetFilter) {
        if (packetListener == null) {
            throw new NullPointerException("Packet listener is null.");
        }
        ListenerWrapper wrapper = new ListenerWrapper(packetListener, packetFilter);
        this.recvListeners.put(packetListener, wrapper);
    }

    public void removePacketListener(PacketListener packetListener) {
        this.recvListeners.remove(packetListener);
    }

    protected Map<PacketListener, ListenerWrapper> getPacketListeners() {
        return this.recvListeners;
    }

    public void addPacketSendingListener(PacketListener packetListener, PacketFilter packetFilter) {
        if (packetListener == null) {
            throw new NullPointerException("Packet listener is null.");
        }
        ListenerWrapper wrapper = new ListenerWrapper(packetListener, packetFilter);
        this.sendListeners.put(packetListener, wrapper);
    }

    public void removePacketSendingListener(PacketListener packetListener) {
        this.sendListeners.remove(packetListener);
    }

    protected Map<PacketListener, ListenerWrapper> getPacketSendingListeners() {
        return this.sendListeners;
    }

    private void firePacketSendingListeners(Packet packet) {
        for (ListenerWrapper listenerWrapper : this.sendListeners.values()) {
            try {
                listenerWrapper.notifyListener(packet);
            }
            catch (SmackException.NotConnectedException e) {
                LOGGER.log(Level.WARNING, "Got not connected exception, aborting");
                break;
            }
        }
    }

    public void addPacketInterceptor(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
        if (packetInterceptor == null) {
            throw new NullPointerException("Packet interceptor is null.");
        }
        this.interceptors.put(packetInterceptor, new InterceptorWrapper(packetInterceptor, packetFilter));
    }

    public void removePacketInterceptor(PacketInterceptor packetInterceptor) {
        this.interceptors.remove(packetInterceptor);
    }

    protected Map<PacketInterceptor, InterceptorWrapper> getPacketInterceptors() {
        return this.interceptors;
    }

    private void firePacketInterceptors(Packet packet) {
        if (packet != null) {
            for (InterceptorWrapper interceptorWrapper : this.interceptors.values()) {
                interceptorWrapper.notifyListener(packet);
            }
        }
    }

    protected void initDebugger() {
        if (this.reader == null || this.writer == null) {
            throw new NullPointerException("Reader or writer isn't initialized.");
        }
        if (this.config.isDebuggerEnabled()) {
            if (this.debugger == null) {
                String className = null;
                try {
                    className = System.getProperty("smack.debuggerClass");
                }
                catch (Throwable t) {
                    // empty catch block
                }
                Class<?> debuggerClass = null;
                if (className != null) {
                    try {
                        debuggerClass = Class.forName(className);
                    }
                    catch (Exception e) {
                        LOGGER.warning("Unabled to instantiate debugger class " + className);
                    }
                }
                if (debuggerClass == null) {
                    try {
                        debuggerClass = Class.forName("org.jivesoftware.smackx.debugger.EnhancedDebugger");
                    }
                    catch (Exception ex) {
                        try {
                            debuggerClass = Class.forName("org.jivesoftware.smack.debugger.LiteDebugger");
                        }
                        catch (Exception ex2) {
                            LOGGER.warning("Unabled to instantiate either Smack debugger class");
                        }
                    }
                }
                try {
                    Constructor<?> constructor = debuggerClass.getConstructor(XMPPConnection.class, Writer.class, Reader.class);
                    this.debugger = (SmackDebugger)constructor.newInstance(this, this.writer, this.reader);
                    this.reader = this.debugger.getReader();
                    this.writer = this.debugger.getWriter();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Can't initialize the configured debugger!", e);
                }
            }
            this.reader = this.debugger.newConnectionReader(this.reader);
            this.writer = this.debugger.newConnectionWriter(this.writer);
        }
    }

    protected void setServiceCapsNode(String node) {
        this.serviceCapsNode = node;
    }

    public String getServiceCapsNode() {
        return this.serviceCapsNode;
    }

    public boolean isRosterVersioningSupported() {
        return this.rosterVersioningSupported;
    }

    protected void setRosterVersioningSupported() {
        this.rosterVersioningSupported = true;
    }

    public long getPacketReplyTimeout() {
        return this.packetReplyTimeout;
    }

    public void setPacketReplyTimeout(long timeout) {
        this.packetReplyTimeout = timeout;
    }

    protected void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        for (PacketCollector collector : this.getPacketCollectors()) {
            collector.processPacket(packet);
        }
        this.executorService.submit(new ListenerNotification(packet));
    }

    protected void setWasAuthenticated(boolean authenticated) {
        if (!this.wasAuthenticated) {
            this.wasAuthenticated = authenticated;
        }
    }

    protected void callConnectionConnectedListener() {
        for (ConnectionListener listener : this.getConnectionListeners()) {
            listener.connected(this);
        }
    }

    protected void callConnectionAuthenticatedListener() {
        for (ConnectionListener listener : this.getConnectionListeners()) {
            listener.authenticated(this);
        }
    }

    void callConnectionClosedListener() {
        for (ConnectionListener listener : this.getConnectionListeners()) {
            try {
                listener.connectionClosed();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error in listener while closing connection", e);
            }
        }
    }

    protected void callConnectionClosedOnErrorListener(Exception e) {
        LOGGER.log(Level.WARNING, "Connection closed with error", e);
        for (ConnectionListener listener : this.getConnectionListeners()) {
            try {
                listener.connectionClosedOnError(e);
            }
            catch (Exception e2) {
                LOGGER.log(Level.SEVERE, "Error in listener while closing connection", e2);
            }
        }
    }

    protected ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.executorService.schedule(command, delay, unit);
    }

    public int getConnectionCounter() {
        return this.connectionCounterValue;
    }

    public void setFromMode(FromMode fromMode) {
        this.fromMode = fromMode;
    }

    public FromMode getFromMode() {
        return this.fromMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.executorService.shutdownNow();
        }
        finally {
            super.finalize();
        }
    }

    static {
        SmackConfiguration.getVersion();
    }

    public static enum FromMode {
        UNCHANGED,
        OMITTED,
        USER;

    }

    protected static class InterceptorWrapper {
        private PacketInterceptor packetInterceptor;
        private PacketFilter packetFilter;

        public InterceptorWrapper(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
            this.packetInterceptor = packetInterceptor;
            this.packetFilter = packetFilter;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof InterceptorWrapper) {
                return ((InterceptorWrapper)object).packetInterceptor.equals(this.packetInterceptor);
            }
            if (object instanceof PacketInterceptor) {
                return object.equals(this.packetInterceptor);
            }
            return false;
        }

        public void notifyListener(Packet packet) {
            if (this.packetFilter == null || this.packetFilter.accept(packet)) {
                this.packetInterceptor.interceptPacket(packet);
            }
        }
    }

    protected static class ListenerWrapper {
        private PacketListener packetListener;
        private PacketFilter packetFilter;

        public ListenerWrapper(PacketListener packetListener, PacketFilter packetFilter) {
            this.packetListener = packetListener;
            this.packetFilter = packetFilter;
        }

        public void notifyListener(Packet packet) throws SmackException.NotConnectedException {
            if (this.packetFilter == null || this.packetFilter.accept(packet)) {
                this.packetListener.processPacket(packet);
            }
        }
    }

    private class ListenerNotification
    implements Runnable {
        private Packet packet;

        public ListenerNotification(Packet packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            for (ListenerWrapper listenerWrapper : XMPPConnection.this.recvListeners.values()) {
                try {
                    listenerWrapper.notifyListener(this.packet);
                }
                catch (SmackException.NotConnectedException e) {
                    LOGGER.log(Level.WARNING, "Got not connected exception, aborting", e);
                    break;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Exception in packet listener", e);
                }
            }
        }
    }

    private static final class SmackExecutorThreadFactory
    implements ThreadFactory {
        private final int connectionCounterValue;
        private int count = 0;

        private SmackExecutorThreadFactory(int connectionCounterValue) {
            this.connectionCounterValue = connectionCounterValue;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "Smack Executor Service " + this.count++ + " (" + this.connectionCounterValue + ")");
            thread.setDaemon(true);
            return thread;
        }
    }
}

