/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jivesoftware.smack.packet.PacketExtension;

public class XMPPError {
    private final Type type;
    private final String condition;
    private String message;
    private List<PacketExtension> applicationExtensions = null;

    public XMPPError(Condition condition) {
        ErrorSpecification defaultErrorSpecification = ErrorSpecification.specFor(condition);
        this.condition = condition.value;
        this.type = defaultErrorSpecification != null ? defaultErrorSpecification.getType() : null;
    }

    public XMPPError(Condition condition, String messageText) {
        this(condition);
        this.message = messageText;
    }

    public XMPPError(Type type, String condition, String message, List<PacketExtension> extension) {
        this.type = type;
        this.condition = condition;
        this.message = message;
        this.applicationExtensions = extension;
    }

    public String getCondition() {
        return this.condition;
    }

    public Type getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public CharSequence toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<error");
        if (this.type != null) {
            buf.append(" type=\"");
            buf.append(this.type.name().toLowerCase(Locale.US));
            buf.append("\"");
        }
        buf.append(">");
        if (this.condition != null) {
            buf.append("<").append(this.condition);
            buf.append(" xmlns=\"urn:ietf:params:xml:ns:xmpp-stanzas\"/>");
        }
        if (this.message != null) {
            buf.append("<text xml:lang=\"en\" xmlns=\"urn:ietf:params:xml:ns:xmpp-stanzas\">");
            buf.append(this.message);
            buf.append("</text>");
        }
        for (PacketExtension element : this.getExtensions()) {
            buf.append(element.toXML());
        }
        buf.append("</error>");
        return buf.toString();
    }

    public String toString() {
        StringBuilder txt = new StringBuilder();
        if (this.condition != null) {
            txt.append(this.condition);
        }
        if (this.message != null) {
            txt.append(" ").append(this.message);
        }
        return txt.toString();
    }

    public synchronized List<PacketExtension> getExtensions() {
        if (this.applicationExtensions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.applicationExtensions);
    }

    public synchronized PacketExtension getExtension(String elementName, String namespace) {
        if (this.applicationExtensions == null || elementName == null || namespace == null) {
            return null;
        }
        for (PacketExtension ext : this.applicationExtensions) {
            if (!elementName.equals(ext.getElementName()) || !namespace.equals(ext.getNamespace())) continue;
            return ext;
        }
        return null;
    }

    public synchronized void addExtension(PacketExtension extension) {
        if (this.applicationExtensions == null) {
            this.applicationExtensions = new ArrayList<PacketExtension>();
        }
        this.applicationExtensions.add(extension);
    }

    public synchronized void setExtension(List<PacketExtension> extension) {
        this.applicationExtensions = extension;
    }

    private static class ErrorSpecification {
        private static Map<Condition, ErrorSpecification> instances = new HashMap<Condition, ErrorSpecification>();
        private final Type type;
        private final Condition condition;

        private ErrorSpecification(Condition condition, Type type) {
            this.type = type;
            this.condition = condition;
        }

        protected static ErrorSpecification specFor(Condition condition) {
            return instances.get(condition);
        }

        protected Type getType() {
            return this.type;
        }

        static {
            instances.put(Condition.internal_server_error, new ErrorSpecification(Condition.internal_server_error, Type.WAIT));
            instances.put(Condition.forbidden, new ErrorSpecification(Condition.forbidden, Type.AUTH));
            instances.put(Condition.bad_request, new ErrorSpecification(Condition.bad_request, Type.MODIFY));
            instances.put(Condition.item_not_found, new ErrorSpecification(Condition.item_not_found, Type.CANCEL));
            instances.put(Condition.conflict, new ErrorSpecification(Condition.conflict, Type.CANCEL));
            instances.put(Condition.feature_not_implemented, new ErrorSpecification(Condition.feature_not_implemented, Type.CANCEL));
            instances.put(Condition.gone, new ErrorSpecification(Condition.gone, Type.MODIFY));
            instances.put(Condition.jid_malformed, new ErrorSpecification(Condition.jid_malformed, Type.MODIFY));
            instances.put(Condition.no_acceptable, new ErrorSpecification(Condition.no_acceptable, Type.MODIFY));
            instances.put(Condition.not_allowed, new ErrorSpecification(Condition.not_allowed, Type.CANCEL));
            instances.put(Condition.not_authorized, new ErrorSpecification(Condition.not_authorized, Type.AUTH));
            instances.put(Condition.payment_required, new ErrorSpecification(Condition.payment_required, Type.AUTH));
            instances.put(Condition.recipient_unavailable, new ErrorSpecification(Condition.recipient_unavailable, Type.WAIT));
            instances.put(Condition.redirect, new ErrorSpecification(Condition.redirect, Type.MODIFY));
            instances.put(Condition.registration_required, new ErrorSpecification(Condition.registration_required, Type.AUTH));
            instances.put(Condition.remote_server_not_found, new ErrorSpecification(Condition.remote_server_not_found, Type.CANCEL));
            instances.put(Condition.remote_server_timeout, new ErrorSpecification(Condition.remote_server_timeout, Type.WAIT));
            instances.put(Condition.remote_server_error, new ErrorSpecification(Condition.remote_server_error, Type.CANCEL));
            instances.put(Condition.resource_constraint, new ErrorSpecification(Condition.resource_constraint, Type.WAIT));
            instances.put(Condition.service_unavailable, new ErrorSpecification(Condition.service_unavailable, Type.CANCEL));
            instances.put(Condition.subscription_required, new ErrorSpecification(Condition.subscription_required, Type.AUTH));
            instances.put(Condition.undefined_condition, new ErrorSpecification(Condition.undefined_condition, Type.WAIT));
            instances.put(Condition.unexpected_request, new ErrorSpecification(Condition.unexpected_request, Type.WAIT));
            instances.put(Condition.request_timeout, new ErrorSpecification(Condition.request_timeout, Type.CANCEL));
        }
    }

    public static class Condition {
        public static final Condition internal_server_error = new Condition("internal-server-error");
        public static final Condition forbidden = new Condition("forbidden");
        public static final Condition bad_request = new Condition("bad-request");
        public static final Condition conflict = new Condition("conflict");
        public static final Condition feature_not_implemented = new Condition("feature-not-implemented");
        public static final Condition gone = new Condition("gone");
        public static final Condition item_not_found = new Condition("item-not-found");
        public static final Condition jid_malformed = new Condition("jid-malformed");
        public static final Condition no_acceptable = new Condition("not-acceptable");
        public static final Condition not_allowed = new Condition("not-allowed");
        public static final Condition not_authorized = new Condition("not-authorized");
        public static final Condition payment_required = new Condition("payment-required");
        public static final Condition recipient_unavailable = new Condition("recipient-unavailable");
        public static final Condition redirect = new Condition("redirect");
        public static final Condition registration_required = new Condition("registration-required");
        public static final Condition remote_server_error = new Condition("remote-server-error");
        public static final Condition remote_server_not_found = new Condition("remote-server-not-found");
        public static final Condition remote_server_timeout = new Condition("remote-server-timeout");
        public static final Condition resource_constraint = new Condition("resource-constraint");
        public static final Condition service_unavailable = new Condition("service-unavailable");
        public static final Condition subscription_required = new Condition("subscription-required");
        public static final Condition undefined_condition = new Condition("undefined-condition");
        public static final Condition unexpected_request = new Condition("unexpected-request");
        public static final Condition request_timeout = new Condition("request-timeout");
        private final String value;

        public Condition(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public boolean equals(Object other) {
            return this.toString().equals(other.toString());
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static enum Type {
        WAIT,
        CANCEL,
        MODIFY,
        AUTH,
        CONTINUE;

    }
}

