/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;

public class OrFilter
implements PacketFilter {
    private final List<PacketFilter> filters;

    public OrFilter() {
        this.filters = new ArrayList<PacketFilter>();
    }

    public OrFilter(PacketFilter ... filters) {
        if (filters == null) {
            throw new IllegalArgumentException("Parameter must not be null.");
        }
        for (PacketFilter filter : filters) {
            if (filter != null) continue;
            throw new IllegalArgumentException("Parameter must not be null.");
        }
        this.filters = new ArrayList<PacketFilter>(Arrays.asList(filters));
    }

    public void addFilter(PacketFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Parameter must not be null.");
        }
        this.filters.add(filter);
    }

    @Override
    public boolean accept(Packet packet) {
        for (PacketFilter filter : this.filters) {
            if (!filter.accept(packet)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.filters.toString();
    }
}

