/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;

public class PacketCollector {
    private PacketFilter packetFilter;
    private ArrayBlockingQueue<Packet> resultQueue;
    private XMPPConnection connection;
    private boolean cancelled = false;

    protected PacketCollector(XMPPConnection connection, PacketFilter packetFilter) {
        this(connection, packetFilter, SmackConfiguration.getPacketCollectorSize());
    }

    protected PacketCollector(XMPPConnection connection, PacketFilter packetFilter, int maxSize) {
        this.connection = connection;
        this.packetFilter = packetFilter;
        this.resultQueue = new ArrayBlockingQueue(maxSize);
    }

    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.connection.removePacketCollector(this);
        }
    }

    public PacketFilter getPacketFilter() {
        return this.packetFilter;
    }

    public Packet pollResult() {
        return this.resultQueue.poll();
    }

    public Packet nextResultBlockForever() {
        try {
            return this.resultQueue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Packet nextResult() {
        return this.nextResult(this.connection.getPacketReplyTimeout());
    }

    public Packet nextResult(long timeout) {
        try {
            return this.resultQueue.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Packet nextResultOrThrow() throws SmackException.NoResponseException, XMPPException.XMPPErrorException {
        return this.nextResultOrThrow(this.connection.getPacketReplyTimeout());
    }

    public Packet nextResultOrThrow(long timeout) throws SmackException.NoResponseException, XMPPException.XMPPErrorException {
        Packet result = this.nextResult(timeout);
        this.cancel();
        if (result == null) {
            throw new SmackException.NoResponseException();
        }
        XMPPError xmppError = result.getError();
        if (xmppError != null) {
            throw new XMPPException.XMPPErrorException(xmppError);
        }
        return result;
    }

    protected void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        if (this.packetFilter == null || this.packetFilter.accept(packet)) {
            while (!this.resultQueue.offer(packet)) {
                this.resultQueue.poll();
            }
        }
    }
}

