/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChatConnectionTest {
    private DummyConnection connection;

    @Before
    public void setUp() throws Exception {
        this.connection = this.getConnection();
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    @Test
    public void validateDefaultSetNormalIncluded() {
        ChatManager.setDefaultIsNormalIncluded((boolean)false);
        Assert.assertFalse((boolean)ChatManager.getInstanceFor((XMPPConnection)this.getConnection()).isNormalIncluded());
        ChatManager.setDefaultIsNormalIncluded((boolean)true);
        Assert.assertTrue((boolean)ChatManager.getInstanceFor((XMPPConnection)this.getConnection()).isNormalIncluded());
    }

    @Test
    public void validateDefaultSetMatchMode() {
        ChatManager.setDefaultMatchMode((ChatManager.MatchMode)ChatManager.MatchMode.NONE);
        Assert.assertEquals((Object)ChatManager.MatchMode.NONE, (Object)ChatManager.getInstanceFor((XMPPConnection)this.getConnection()).getMatchMode());
        ChatManager.setDefaultMatchMode((ChatManager.MatchMode)ChatManager.MatchMode.BARE_JID);
        Assert.assertEquals((Object)ChatManager.MatchMode.BARE_JID, (Object)ChatManager.getInstanceFor((XMPPConnection)this.getConnection()).getMatchMode());
    }

    @Test
    public void validateMessageTypeWithDefaults() {
        DummyConnection dc = this.getConnection();
        ChatManager cm = ChatManager.getInstanceFor((XMPPConnection)dc);
        TestChatManagerListener listener = new TestChatManagerListener();
        cm.addChatListener((ChatManagerListener)listener);
        Message incomingChat = this.createChatPacket("134", true);
        incomingChat.setType(Message.Type.chat);
        this.processServerMessage((Packet)incomingChat, dc);
        Assert.assertNotNull((Object)listener.getNewChat());
        dc = this.getConnection();
        cm = ChatManager.getInstanceFor((XMPPConnection)dc);
        listener = new TestChatManagerListener();
        cm.addChatListener((ChatManagerListener)listener);
        incomingChat = this.createChatPacket("134", true);
        incomingChat.setType(Message.Type.normal);
        this.processServerMessage((Packet)incomingChat, dc);
        Assert.assertNotNull((Object)listener.getNewChat());
        dc = this.getConnection();
        cm = ChatManager.getInstanceFor((XMPPConnection)dc);
        listener = new TestChatManagerListener();
        cm.addChatListener((ChatManagerListener)listener);
        incomingChat = this.createChatPacket("134", true);
        incomingChat.setType(Message.Type.groupchat);
        this.processServerMessage((Packet)incomingChat, dc);
        Assert.assertNull((Object)listener.getNewChat());
        dc = this.getConnection();
        cm = ChatManager.getInstanceFor((XMPPConnection)dc);
        listener = new TestChatManagerListener();
        cm.addChatListener((ChatManagerListener)listener);
        incomingChat = this.createChatPacket("134", true);
        incomingChat.setType(Message.Type.headline);
        this.processServerMessage((Packet)incomingChat, dc);
        Assert.assertNull((Object)listener.getNewChat());
    }

    @Test
    public void validateMessageTypeWithNoNormal() {
        DummyConnection dc = this.getConnection();
        ChatManager cm = ChatManager.getInstanceFor((XMPPConnection)dc);
        cm.setNormalIncluded(false);
        TestChatManagerListener listener = new TestChatManagerListener();
        cm.addChatListener((ChatManagerListener)listener);
        Message incomingChat = this.createChatPacket("134", true);
        incomingChat.setType(Message.Type.chat);
        this.processServerMessage((Packet)incomingChat, dc);
        Assert.assertNotNull((Object)listener.getNewChat());
        dc = this.getConnection();
        cm = ChatManager.getInstanceFor((XMPPConnection)dc);
        cm.setNormalIncluded(false);
        listener = new TestChatManagerListener();
        cm.addChatListener((ChatManagerListener)listener);
        incomingChat = this.createChatPacket("134", true);
        incomingChat.setType(Message.Type.normal);
        this.processServerMessage((Packet)incomingChat, dc);
        Assert.assertNull((Object)listener.getNewChat());
    }

    @Test
    public void chatMatchedOnJIDWhenNoThreadBareMode() {
        DummyConnection con = this.getConnection();
        TestMessageListener msgListener = new TestMessageListener();
        TestChatManagerListener listener = new TestChatManagerListener(msgListener);
        ChatManager cm = ChatManager.getInstanceFor((XMPPConnection)con);
        cm.addChatListener((ChatManagerListener)listener);
        Message incomingChat = this.createChatPacket(null, true);
        this.processServerMessage((Packet)incomingChat, con);
        Chat newChat = listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        incomingChat = this.createChatPacket(null, true);
        this.processServerMessage((Packet)incomingChat, con);
        Assert.assertEquals((long)2L, (long)msgListener.getNumMessages());
        incomingChat = this.createChatPacket(null, false);
        this.processServerMessage((Packet)incomingChat, con);
        Assert.assertEquals((long)3L, (long)msgListener.getNumMessages());
    }

    @Test
    public void chatMatchedOnJIDWhenNoThreadJidMode() {
        DummyConnection con = this.getConnection();
        TestMessageListener msgListener = new TestMessageListener();
        TestChatManagerListener listener = new TestChatManagerListener(msgListener);
        ChatManager cm = ChatManager.getInstanceFor((XMPPConnection)con);
        cm.setMatchMode(ChatManager.MatchMode.SUPPLIED_JID);
        cm.addChatListener((ChatManagerListener)listener);
        Message incomingChat = this.createChatPacket(null, true);
        this.processServerMessage((Packet)incomingChat, con);
        Chat newChat = listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        cm.removeChatListener((ChatManagerListener)listener);
        incomingChat = this.createChatPacket(null, true);
        this.processServerMessage((Packet)incomingChat, con);
        Assert.assertEquals((long)2L, (long)msgListener.getNumMessages());
        TestChatManagerListener listener2 = new TestChatManagerListener();
        cm.addChatListener((ChatManagerListener)listener2);
        incomingChat = this.createChatPacket(null, false);
        this.processServerMessage((Packet)incomingChat, con);
        Assert.assertEquals((long)2L, (long)msgListener.getNumMessages());
        Assert.assertNotNull((Object)listener2.getNewChat());
    }

    @Test
    public void chatMatchedOnJIDWhenNoThreadNoneMode() {
        DummyConnection con = this.getConnection();
        TestMessageListener msgListener = new TestMessageListener();
        TestChatManagerListener listener = new TestChatManagerListener(msgListener);
        ChatManager cm = ChatManager.getInstanceFor((XMPPConnection)con);
        cm.setMatchMode(ChatManager.MatchMode.NONE);
        cm.addChatListener((ChatManagerListener)listener);
        Message incomingChat = this.createChatPacket(null, true);
        this.processServerMessage((Packet)incomingChat, con);
        Chat newChat = listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertEquals((long)1L, (long)msgListener.getNumMessages());
        cm.removeChatListener((ChatManagerListener)listener);
        TestChatManagerListener listener2 = new TestChatManagerListener();
        cm.addChatListener((ChatManagerListener)listener2);
        incomingChat = this.createChatPacket(null, true);
        this.processServerMessage((Packet)incomingChat, con);
        Assert.assertEquals((long)1L, (long)msgListener.getNumMessages());
        Assert.assertNotNull((Object)newChat);
        cm.removeChatListener((ChatManagerListener)listener2);
        TestChatManagerListener listener3 = new TestChatManagerListener();
        cm.addChatListener((ChatManagerListener)listener3);
        incomingChat = this.createChatPacket(null, false);
        this.processServerMessage((Packet)incomingChat, con);
        Assert.assertEquals((long)1L, (long)msgListener.getNumMessages());
        Assert.assertNotNull((Object)listener3.getNewChat());
    }

    @Test
    public void chatFoundWhenNoThreadFullJid() {
        TestChatManagerListener listener = new TestChatManagerListener();
        ChatManager cm = ChatManager.getInstanceFor((XMPPConnection)this.connection);
        cm.addChatListener((ChatManagerListener)listener);
        Chat outgoing = cm.createChat("you@testserver", null);
        Message incomingChat = this.createChatPacket(null, true);
        this.processServerMessage((Packet)incomingChat);
        Chat newChat = listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertTrue((newChat == outgoing ? 1 : 0) != 0);
    }

    @Test
    public void chatFoundWhenNoThreadBaseJid() {
        TestChatManagerListener listener = new TestChatManagerListener();
        ChatManager cm = ChatManager.getInstanceFor((XMPPConnection)this.connection);
        cm.addChatListener((ChatManagerListener)listener);
        Chat outgoing = cm.createChat("you@testserver", null);
        Message incomingChat = this.createChatPacket(null, false);
        this.processServerMessage((Packet)incomingChat);
        Chat newChat = listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertTrue((newChat == outgoing ? 1 : 0) != 0);
    }

    @Test
    public void chatFoundWithSameThreadFullJid() {
        TestChatManagerListener listener = new TestChatManagerListener();
        ChatManager cm = ChatManager.getInstanceFor((XMPPConnection)this.connection);
        cm.addChatListener((ChatManagerListener)listener);
        Chat outgoing = cm.createChat("you@testserver", null);
        Message incomingChat = this.createChatPacket(outgoing.getThreadID(), true);
        this.processServerMessage((Packet)incomingChat);
        Chat newChat = listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertTrue((newChat == outgoing ? 1 : 0) != 0);
    }

    @Test
    public void chatFoundWithSameThreadBaseJid() {
        TestChatManagerListener listener = new TestChatManagerListener();
        ChatManager cm = ChatManager.getInstanceFor((XMPPConnection)this.connection);
        cm.addChatListener((ChatManagerListener)listener);
        Chat outgoing = cm.createChat("you@testserver", null);
        Message incomingChat = this.createChatPacket(outgoing.getThreadID(), false);
        this.processServerMessage((Packet)incomingChat);
        Chat newChat = listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertTrue((newChat == outgoing ? 1 : 0) != 0);
    }

    @Test
    public void chatNotFoundWithDiffThreadBaseJid() {
        TestChatManagerListener listener = new TestChatManagerListener();
        ChatManager cm = ChatManager.getInstanceFor((XMPPConnection)this.connection);
        cm.addChatListener((ChatManagerListener)listener);
        Chat outgoing = cm.createChat("you@testserver", null);
        Message incomingChat = this.createChatPacket(outgoing.getThreadID() + "ff", false);
        this.processServerMessage((Packet)incomingChat);
        Chat newChat = listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertFalse((newChat == outgoing ? 1 : 0) != 0);
    }

    @Test
    public void chatNotFoundWithDiffThreadFullJid() {
        TestChatManagerListener listener = new TestChatManagerListener();
        ChatManager cm = ChatManager.getInstanceFor((XMPPConnection)this.connection);
        cm.addChatListener((ChatManagerListener)listener);
        Chat outgoing = cm.createChat("you@testserver", null);
        Message incomingChat = this.createChatPacket(outgoing.getThreadID() + "ff", true);
        this.processServerMessage((Packet)incomingChat);
        Chat newChat = listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertFalse((newChat == outgoing ? 1 : 0) != 0);
    }

    @Test
    public void chatNotMatchedWithTypeNormal() {
        TestChatManagerListener listener = new TestChatManagerListener();
        DummyConnection con = this.getConnection();
        ChatManager cm = ChatManager.getInstanceFor((XMPPConnection)con);
        cm.setNormalIncluded(false);
        cm.addChatListener((ChatManagerListener)listener);
        Message incomingChat = this.createChatPacket(null, false);
        incomingChat.setType(Message.Type.normal);
        this.processServerMessage((Packet)incomingChat);
        Assert.assertNull((Object)listener.getNewChat());
    }

    private ChatManager getChatManager(boolean includeNormal, ChatManager.MatchMode mode) {
        ChatManager cm = ChatManager.getInstanceFor((XMPPConnection)this.getConnection());
        cm.setMatchMode(mode);
        cm.setNormalIncluded(includeNormal);
        return cm;
    }

    private DummyConnection getConnection() {
        DummyConnection con = new DummyConnection();
        try {
            con.connect();
            con.login("me", "secret");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return con;
    }

    private Message createChatPacket(String threadId, boolean isFullJid) {
        Message chatMsg = new Message("me@testserver", Message.Type.chat);
        chatMsg.setBody("the body message - " + System.currentTimeMillis());
        chatMsg.setFrom("you@testserver" + (isFullJid ? "/resource" : ""));
        if (threadId != null) {
            chatMsg.setThread(threadId);
        }
        return chatMsg;
    }

    private void processServerMessage(Packet incomingChat) {
        this.processServerMessage(incomingChat, this.connection);
    }

    private void processServerMessage(Packet incomingChat, DummyConnection con) {
        TestChatServer chatServer = new TestChatServer(incomingChat, con);
        chatServer.start();
        try {
            chatServer.join();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
    }

    private class TestMessageListener
    implements MessageListener {
        private Chat msgChat;
        private int counter = 0;

        private TestMessageListener() {
        }

        public void processMessage(Chat chat, Message message) {
            this.msgChat = chat;
            ++this.counter;
        }

        public Chat getChat() {
            return this.msgChat;
        }

        public int getNumMessages() {
            return this.counter;
        }
    }

    private class TestChatServer
    extends Thread {
        private Packet chatPacket;
        private DummyConnection con;

        TestChatServer(Packet chatMsg, DummyConnection conect) {
            this.chatPacket = chatMsg;
            this.con = conect;
        }

        @Override
        public void run() {
            this.con.processPacket(this.chatPacket);
        }
    }

    class TestChatManagerListener
    implements ChatManagerListener {
        private Chat newChat;
        private MessageListener listener;

        public TestChatManagerListener(TestMessageListener msgListener) {
            this.listener = msgListener;
        }

        public TestChatManagerListener() {
        }

        public void chatCreated(Chat chat, boolean createdLocally) {
            this.newChat = chat;
            if (this.listener != null) {
                this.newChat.addMessageListener(this.listener);
            }
        }

        public Chat getNewChat() {
            return this.newChat;
        }
    }
}

