/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;

public class ThreadedDummyConnection
extends DummyConnection {
    private BlockingQueue<IQ> replyQ = new ArrayBlockingQueue<IQ>(1);
    private BlockingQueue<Packet> messageQ = new LinkedBlockingQueue<Packet>(5);
    private volatile boolean timeout = false;

    public void sendPacket(Packet packet) {
        try {
            super.sendPacket(packet);
        }
        catch (SmackException.NotConnectedException e) {
            e.printStackTrace();
        }
        if (packet instanceof IQ && !this.timeout) {
            this.timeout = false;
            IQ replyPacket = (IQ)this.replyQ.peek();
            if (replyPacket == null) {
                replyPacket = IQ.createResultIQ((IQ)((IQ)packet));
                this.replyQ.add(replyPacket);
            }
            replyPacket.setPacketID(packet.getPacketID());
            replyPacket.setFrom(packet.getTo());
            replyPacket.setTo(packet.getFrom());
            replyPacket.setType(IQ.Type.result);
            new ProcessQueue(this.replyQ).start();
        }
    }

    public void setTimeout() {
        this.timeout = true;
    }

    public void addMessage(Message msgToProcess) {
        this.messageQ.add((Packet)msgToProcess);
    }

    public void addIQReply(IQ reply) {
        this.replyQ.add(reply);
    }

    public void processMessages() {
        if (!this.messageQ.isEmpty()) {
            new ProcessQueue(this.messageQ).start();
        } else {
            System.out.println("No messages to process");
        }
    }

    class ProcessQueue
    extends Thread {
        private BlockingQueue<? extends Packet> processQ;

        ProcessQueue(BlockingQueue<? extends Packet> queue) {
            this.processQ = queue;
        }

        @Override
        public void run() {
            try {
                ThreadedDummyConnection.this.processPacket(this.processQ.take());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

