/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.custommonkey.xmlunit.XMLAssert;
import org.jivesoftware.smack.packet.Presence;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class PresenceTest {
    @Test
    public void setPresenceTypeTest() throws IOException, SAXException, ParserConfigurationException {
        Presence.Type type = Presence.Type.unavailable;
        Presence.Type type2 = Presence.Type.subscribe;
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<presence").append(" type=\"").append(type).append("\">").append("</presence>");
        String control = controlBuilder.toString();
        Presence presenceTypeInConstructor = new Presence(type);
        presenceTypeInConstructor.setPacketID(null);
        Assert.assertEquals((Object)type, (Object)presenceTypeInConstructor.getType());
        XMLAssert.assertXMLEqual((String)control, (String)presenceTypeInConstructor.toXML().toString());
        controlBuilder = new StringBuilder();
        controlBuilder.append("<presence").append(" type=\"").append(type2).append("\">").append("</presence>");
        control = controlBuilder.toString();
        Presence presenceTypeSet = PresenceTest.getNewPresence();
        presenceTypeSet.setType(type2);
        Assert.assertEquals((Object)type2, (Object)presenceTypeSet.getType());
        XMLAssert.assertXMLEqual((String)control, (String)presenceTypeSet.toXML().toString());
    }

    @Test(expected=NullPointerException.class)
    public void setNullPresenceTypeTest() {
        PresenceTest.getNewPresence().setType(null);
    }

    @Test
    public void isPresenceAvailableTest() {
        Presence presence = PresenceTest.getNewPresence();
        presence.setType(Presence.Type.available);
        Assert.assertTrue((boolean)presence.isAvailable());
        presence.setType(Presence.Type.unavailable);
        Assert.assertFalse((boolean)presence.isAvailable());
    }

    @Test
    public void setPresenceStatusTest() throws IOException, SAXException, ParserConfigurationException {
        String status = "This is a test of the emergency broadcast system.";
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<presence>").append("<status>").append("This is a test of the emergency broadcast system.").append("</status>").append("</presence>");
        String control = controlBuilder.toString();
        Presence presence = PresenceTest.getNewPresence();
        presence.setStatus("This is a test of the emergency broadcast system.");
        Assert.assertEquals((Object)"This is a test of the emergency broadcast system.", (Object)presence.getStatus());
        XMLAssert.assertXMLEqual((String)control, (String)presence.toXML().toString());
    }

    @Test
    public void setPresencePriorityTest() throws IOException, SAXException, ParserConfigurationException {
        int priority = 10;
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<presence>").append("<priority>").append(10).append("</priority>").append("</presence>");
        String control = controlBuilder.toString();
        Presence presence = PresenceTest.getNewPresence();
        presence.setPriority(10);
        Assert.assertEquals((long)10L, (long)presence.getPriority());
        XMLAssert.assertXMLEqual((String)control, (String)presence.toXML().toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void setIllegalPriorityTest() {
        PresenceTest.getNewPresence().setPriority(Integer.MIN_VALUE);
    }

    @Test
    public void setPresenceModeTest() throws IOException, SAXException, ParserConfigurationException {
        Presence.Mode mode1 = Presence.Mode.dnd;
        int priority = 10;
        String status = "This is a test of the emergency broadcast system.";
        Presence.Mode mode2 = Presence.Mode.chat;
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<presence>").append("<status>").append("This is a test of the emergency broadcast system.").append("</status>").append("<priority>").append(10).append("</priority>").append("<show>").append(mode1).append("</show>").append("</presence>");
        String control = controlBuilder.toString();
        Presence presenceModeInConstructor = new Presence(Presence.Type.available, "This is a test of the emergency broadcast system.", 10, mode1);
        presenceModeInConstructor.setPacketID(null);
        Assert.assertEquals((Object)mode1, (Object)presenceModeInConstructor.getMode());
        XMLAssert.assertXMLEqual((String)control, (String)presenceModeInConstructor.toXML().toString());
        controlBuilder = new StringBuilder();
        controlBuilder.append("<presence>").append("<show>").append(mode2).append("</show>").append("</presence>");
        control = controlBuilder.toString();
        Presence presenceModeSet = PresenceTest.getNewPresence();
        presenceModeSet.setMode(mode2);
        Assert.assertEquals((Object)mode2, (Object)presenceModeSet.getMode());
        XMLAssert.assertXMLEqual((String)control, (String)presenceModeSet.toXML().toString());
    }

    @Test
    public void isModeAwayTest() {
        Presence presence = PresenceTest.getNewPresence();
        presence.setMode(Presence.Mode.away);
        Assert.assertTrue((boolean)presence.isAway());
        presence.setMode(Presence.Mode.chat);
        Assert.assertFalse((boolean)presence.isAway());
    }

    @Test
    public void presenceXmlLangTest() throws IOException, SAXException, ParserConfigurationException {
        String lang = "sp";
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<presence").append(" xml:lang=\"").append("sp").append("\">").append("</presence>");
        String control = controlBuilder.toString();
        Presence presence = PresenceTest.getNewPresence();
        presence.setLanguage("sp");
        XMLAssert.assertXMLEqual((String)control, (String)presence.toXML().toString());
    }

    private static Presence getNewPresence() {
        Presence presence = new Presence(Presence.Type.available);
        presence.setPacketID(null);
        return presence;
    }
}

