/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import org.jivesoftware.smack.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsTest {
    private final String HASH_CHARS = "0123456789abcdef";

    @Test
    public void testEscapeForXML() {
        String input = null;
        Assert.assertNull((Object)StringUtils.escapeForXML(null));
        input = "<b>";
        StringUtilsTest.assertCharSequenceEquals("&lt;b&gt;", StringUtils.escapeForXML((String)input));
        input = "\"";
        StringUtilsTest.assertCharSequenceEquals("&quot;", StringUtils.escapeForXML((String)input));
        input = "&";
        StringUtilsTest.assertCharSequenceEquals("&amp;", StringUtils.escapeForXML((String)input));
        input = "<b>\n\t\r</b>";
        StringUtilsTest.assertCharSequenceEquals("&lt;b&gt;\n\t\r&lt;/b&gt;", StringUtils.escapeForXML((String)input));
        input = "   &   ";
        StringUtilsTest.assertCharSequenceEquals("   &amp;   ", StringUtils.escapeForXML((String)input));
        input = "   \"   ";
        StringUtilsTest.assertCharSequenceEquals("   &quot;   ", StringUtils.escapeForXML((String)input));
        input = "> of me <";
        StringUtilsTest.assertCharSequenceEquals("&gt; of me &lt;", StringUtils.escapeForXML((String)input));
        input = "> of me & you<";
        StringUtilsTest.assertCharSequenceEquals("&gt; of me &amp; you&lt;", StringUtils.escapeForXML((String)input));
        input = "& <";
        StringUtilsTest.assertCharSequenceEquals("&amp; &lt;", StringUtils.escapeForXML((String)input));
        input = "&";
        StringUtilsTest.assertCharSequenceEquals("&amp;", StringUtils.escapeForXML((String)input));
        input = "It's a good day today";
        StringUtilsTest.assertCharSequenceEquals("It&apos;s a good day today", StringUtils.escapeForXML((String)input));
    }

    public static void assertCharSequenceEquals(CharSequence expected, CharSequence actual) {
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
    }

    @Test
    public void testHash() {
        try {
            StringUtils.hash(null);
            Assert.fail();
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)true);
        }
        String result = StringUtils.hash((String)"");
        Assert.assertEquals((Object)"da39a3ee5e6b4b0d3255bfef95601890afd80709", (Object)result);
        String adminInHash = "d033e22ae348aeb5660fc2140aec35850c4da997";
        result = StringUtils.hash((String)"admin");
        Assert.assertEquals((Object)adminInHash, (Object)result);
        String random = "jive software blah and stuff this is pretty cool";
        result = StringUtils.hash((String)random);
        Assert.assertTrue((boolean)this.isValidHash(result));
        String junk = "\n\n\t\b\r!@(!)^(#)@+_-\u2031\u09291\u00a9\u00bd\u0394\u00f8";
        result = StringUtils.hash((String)junk);
        Assert.assertTrue((boolean)this.isValidHash(result));
    }

    private boolean isValidHash(String result) {
        boolean valid = true;
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            if ("0123456789abcdef".indexOf(c) >= 0) continue;
            valid = false;
        }
        return valid;
    }

    @Test
    public void testEncodeHex() {
        String input = "";
        String output = "";
        Assert.assertEquals((Object)new String(StringUtils.encodeHex((byte[])input.getBytes())), (Object)new String(output.getBytes()));
        input = "foo bar 123";
        output = "666f6f2062617220313233";
        Assert.assertEquals((Object)new String(StringUtils.encodeHex((byte[])input.getBytes())), (Object)new String(output.getBytes()));
    }

    @Test
    public void testRandomString() {
        String result = StringUtils.randomString((int)-1);
        Assert.assertNull((Object)result);
        result = StringUtils.randomString((int)0);
        Assert.assertNull((Object)result);
        result = StringUtils.randomString((int)4);
        Assert.assertTrue((result.length() == 4 ? 1 : 0) != 0);
        result = StringUtils.randomString((int)16);
        Assert.assertTrue((result.length() == 16 ? 1 : 0) != 0);
        result = StringUtils.randomString((int)128);
        Assert.assertTrue((result.length() == 128 ? 1 : 0) != 0);
    }
}

