/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public abstract class Packet
extends TopLevelStreamElement {
    public static final String TEXT = "text";
    public static final String ITEM = "item";
    protected static final String DEFAULT_LANGUAGE = Locale.getDefault().getLanguage().toLowerCase(Locale.US);
    private static String prefix = StringUtils.randomString(5) + "-";
    private static AtomicLong id = new AtomicLong();
    private String packetID = null;
    private String to = null;
    private String from = null;
    private final List<PacketExtension> packetExtensions = new CopyOnWriteArrayList<PacketExtension>();
    private XMPPError error = null;

    public Packet() {
        this(prefix + Long.toString(id.incrementAndGet()));
    }

    public Packet(String packetID) {
        this.setPacketID(packetID);
    }

    public Packet(Packet p) {
        this.packetID = p.getPacketID();
        this.to = p.getTo();
        this.from = p.getFrom();
        this.error = p.error;
        for (PacketExtension pe : p.getExtensions()) {
            this.addExtension(pe);
        }
    }

    public String getPacketID() {
        return this.packetID;
    }

    public void setPacketID(String packetID) {
        this.packetID = packetID;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public XMPPError getError() {
        return this.error;
    }

    public void setError(XMPPError error) {
        this.error = error;
    }

    public synchronized Collection<PacketExtension> getExtensions() {
        if (this.packetExtensions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<PacketExtension>(this.packetExtensions));
    }

    public PacketExtension getExtension(String namespace) {
        return this.getExtension(null, namespace);
    }

    public <PE extends PacketExtension> PE getExtension(String elementName, String namespace) {
        if (namespace == null) {
            return null;
        }
        for (PacketExtension ext : this.packetExtensions) {
            if (elementName != null && !elementName.equals(ext.getElementName()) || !namespace.equals(ext.getNamespace())) continue;
            return (PE)ext;
        }
        return null;
    }

    public void addExtension(PacketExtension extension) {
        if (extension == null) {
            return;
        }
        this.packetExtensions.add(extension);
    }

    public void addExtensions(Collection<PacketExtension> extensions) {
        if (extensions == null) {
            return;
        }
        this.packetExtensions.addAll(extensions);
    }

    public void removeExtension(PacketExtension extension) {
        this.packetExtensions.remove(extension);
    }

    protected synchronized CharSequence getExtensionsXML() {
        XmlStringBuilder xml = new XmlStringBuilder();
        for (PacketExtension extension : this.getExtensions()) {
            xml.append(extension.toXML());
        }
        return xml;
    }

    public static String getDefaultLanguage() {
        return DEFAULT_LANGUAGE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Packet packet = (Packet)o;
        if (this.error != null ? !this.error.equals(packet.error) : packet.error != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(packet.from) : packet.from != null) {
            return false;
        }
        if (!this.packetExtensions.equals(packet.packetExtensions)) {
            return false;
        }
        if (this.packetID != null ? !this.packetID.equals(packet.packetID) : packet.packetID != null) {
            return false;
        }
        return !(this.to != null ? !this.to.equals(packet.to) : packet.to != null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.packetID != null ? this.packetID.hashCode() : 0);
        result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        result = 31 * result + this.packetExtensions.hashCode();
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.toXML().toString();
    }

    protected void addCommonAttributes(XmlStringBuilder xml) {
        xml.optAttribute("id", this.getPacketID());
        xml.optAttribute("to", this.getTo());
        xml.optAttribute("from", this.getFrom());
    }
}

