/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.ExtensionProviderInfo;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.IQProviderInfo;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderLoader;
import org.jivesoftware.smack.provider.StreamFeatureProvider;
import org.jxmpp.util.XmppStringUtils;

public final class ProviderManager {
    private static final Map<String, Object> extensionProviders = new ConcurrentHashMap<String, Object>();
    private static final Map<String, Object> iqProviders = new ConcurrentHashMap<String, Object>();
    private static final Map<String, StreamFeatureProvider> streamFeatureProviders = new ConcurrentHashMap<String, StreamFeatureProvider>();

    public static void addLoader(ProviderLoader loader) {
        if (loader.getIQProviderInfo() != null) {
            for (IQProviderInfo iQProviderInfo : loader.getIQProviderInfo()) {
                iqProviders.put(ProviderManager.getKey(iQProviderInfo.getElementName(), iQProviderInfo.getNamespace()), iQProviderInfo.getProvider());
            }
        }
        if (loader.getExtensionProviderInfo() != null) {
            for (ExtensionProviderInfo extensionProviderInfo : loader.getExtensionProviderInfo()) {
                extensionProviders.put(ProviderManager.getKey(extensionProviderInfo.getElementName(), extensionProviderInfo.getNamespace()), extensionProviderInfo.getProvider());
            }
        }
    }

    public static Object getIQProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        return iqProviders.get(key);
    }

    public static Collection<Object> getIQProviders() {
        return Collections.unmodifiableCollection(iqProviders.values());
    }

    public static void addIQProvider(String elementName, String namespace, Object provider) {
        if (!(provider instanceof IQProvider || provider instanceof Class && IQ.class.isAssignableFrom((Class)provider))) {
            throw new IllegalArgumentException("Provider must be an IQProvider or a Class instance sublcassing IQ.");
        }
        String key = ProviderManager.getKey(elementName, namespace);
        iqProviders.put(key, provider);
    }

    public static void removeIQProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        iqProviders.remove(key);
    }

    public static Object getExtensionProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        return extensionProviders.get(key);
    }

    public static void addExtensionProvider(String elementName, String namespace, Object provider) {
        if (!(provider instanceof PacketExtensionProvider) && !(provider instanceof Class)) {
            throw new IllegalArgumentException("Provider must be a PacketExtensionProvider or a Class instance.");
        }
        String key = ProviderManager.getKey(elementName, namespace);
        extensionProviders.put(key, provider);
    }

    public static void removeExtensionProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        extensionProviders.remove(key);
    }

    public static Collection<Object> getExtensionProviders() {
        return Collections.unmodifiableCollection(extensionProviders.values());
    }

    public static StreamFeatureProvider getStreamFeatureProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        return streamFeatureProviders.get(key);
    }

    public static void addStreamFeatureProvider(String elementName, String namespace, StreamFeatureProvider provider) {
        String key = ProviderManager.getKey(elementName, namespace);
        streamFeatureProviders.put(key, provider);
    }

    public static void removeStreamFeatureProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        streamFeatureProviders.remove(key);
    }

    private static String getKey(String elementName, String namespace) {
        return XmppStringUtils.generateKey((String)elementName, (String)namespace);
    }
}

