/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.Locale;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ParserUtils {
    public static void assertAtStartTag(XmlPullParser parser) throws XmlPullParserException {
        assert (parser.getEventType() == 2);
    }

    public static void assertAtEndTag(XmlPullParser parser) throws XmlPullParserException {
        assert (parser.getEventType() == 3);
    }

    public static Boolean getBooleanAttribute(XmlPullParser parser, String name) {
        String valueString = parser.getAttributeValue("", name);
        if (valueString == null) {
            return null;
        }
        if ((valueString = valueString.toLowerCase(Locale.US)).equals("true") || valueString.equals("0")) {
            return true;
        }
        return false;
    }

    public static boolean getBooleanAttribute(XmlPullParser parser, String name, boolean defaultValue) {
        Boolean bool = ParserUtils.getBooleanAttribute(parser, name);
        if (bool == null) {
            return defaultValue;
        }
        return bool;
    }

    public static Integer getIntegerAttribute(XmlPullParser parser, String name) {
        String valueString = parser.getAttributeValue("", name);
        if (valueString == null) {
            return null;
        }
        return Integer.valueOf(valueString);
    }

    public static int getIntegerAttribute(XmlPullParser parser, String name, int defaultValue) {
        Integer integer = ParserUtils.getIntegerAttribute(parser, name);
        if (integer == null) {
            return defaultValue;
        }
        return integer;
    }

    public static Long getLongAttribute(XmlPullParser parser, String name) {
        String valueString = parser.getAttributeValue("", name);
        if (valueString == null) {
            return null;
        }
        return Long.valueOf(valueString);
    }

    public static long getLongAttribute(XmlPullParser parser, String name, long defaultValue) {
        Long l = ParserUtils.getLongAttribute(parser, name);
        if (l == null) {
            return defaultValue;
        }
        return l;
    }
}

