/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.examples.RecursiveElementNameAndTextQualifier;
import org.jivesoftware.smack.packet.Message;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class MessageTest {
    @Test
    public void setMessageTypeTest() throws IOException, SAXException, ParserConfigurationException {
        Message.Type type = Message.Type.chat;
        Message.Type type2 = Message.Type.headline;
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<message").append(" type=\"").append(type).append("\">").append("</message>");
        String control = controlBuilder.toString();
        Message messageTypeInConstructor = new Message(null, Message.Type.chat);
        messageTypeInConstructor.setPacketID(null);
        Assert.assertEquals((Object)type, (Object)messageTypeInConstructor.getType());
        XMLAssert.assertXMLEqual((String)control, (String)messageTypeInConstructor.toXML().toString());
        controlBuilder = new StringBuilder();
        controlBuilder.append("<message").append(" type=\"").append(type2).append("\">").append("</message>");
        control = controlBuilder.toString();
        Message messageTypeSet = MessageTest.getNewMessage();
        messageTypeSet.setType(type2);
        Assert.assertEquals((Object)type2, (Object)messageTypeSet.getType());
        XMLAssert.assertXMLEqual((String)control, (String)messageTypeSet.toXML().toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void setMessageTypeNullTest() {
        Message message = MessageTest.getNewMessage();
        message.setType(null);
    }

    @Test(expected=NullPointerException.class)
    public void setNullMessageBodyTest() {
        Message message = MessageTest.getNewMessage();
        message.addBody(null, null);
    }

    @Test
    public void setMessageSubjectTest() throws IOException, SAXException, ParserConfigurationException {
        String messageSubject = "This is a test of the emergency broadcast system.";
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<message>").append("<subject>").append("This is a test of the emergency broadcast system.").append("</subject>").append("</message>");
        String control = controlBuilder.toString();
        Message message = MessageTest.getNewMessage();
        message.setSubject("This is a test of the emergency broadcast system.");
        Assert.assertEquals((Object)"This is a test of the emergency broadcast system.", (Object)message.getSubject());
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML().toString());
    }

    @Test
    public void oneMessageBodyTest() throws IOException, SAXException, ParserConfigurationException {
        String messageBody = "This is a test of the emergency broadcast system.";
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<message>").append("<body>").append("This is a test of the emergency broadcast system.").append("</body>").append("</message>");
        String control = controlBuilder.toString();
        Message message = MessageTest.getNewMessage();
        message.setBody("This is a test of the emergency broadcast system.");
        Assert.assertEquals((Object)"This is a test of the emergency broadcast system.", (Object)message.getBody());
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML().toString());
    }

    @Test
    public void multipleMessageBodiesTest() throws IOException, SAXException, ParserConfigurationException {
        String messageBody1 = "This is a test of the emergency broadcast system, 1.";
        String lang2 = "ru";
        String messageBody2 = "This is a test of the emergency broadcast system, 2.";
        String lang3 = "sp";
        String messageBody3 = "This is a test of the emergency broadcast system, 3.";
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<message>").append("<body>").append("This is a test of the emergency broadcast system, 1.").append("</body>").append("<body xml:lang=\"").append("ru").append("\">").append("This is a test of the emergency broadcast system, 2.").append("</body>").append("<body xml:lang=\"").append("sp").append("\">").append("This is a test of the emergency broadcast system, 3.").append("</body>").append("</message>");
        String control = controlBuilder.toString();
        Message message = MessageTest.getNewMessage();
        message.addBody(null, "This is a test of the emergency broadcast system, 1.");
        message.addBody("ru", "This is a test of the emergency broadcast system, 2.");
        message.addBody("sp", "This is a test of the emergency broadcast system, 3.");
        Diff xmlDiff = new Diff(control, message.toXML().toString());
        xmlDiff.overrideElementQualifier((ElementQualifier)new RecursiveElementNameAndTextQualifier());
        Assert.assertTrue((boolean)xmlDiff.similar());
        Collection languages = message.getBodyLanguages();
        ArrayList<String> controlLanguages = new ArrayList<String>();
        controlLanguages.add("ru");
        controlLanguages.add("sp");
        controlLanguages.removeAll(languages);
        Assert.assertTrue((controlLanguages.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void removeMessageBodyTest() {
        Message message = MessageTest.getNewMessage();
        message.setBody("test");
        Assert.assertTrue((message.getBodies().size() == 1 ? 1 : 0) != 0);
        message.setBody(null);
        Assert.assertTrue((message.getBodies().size() == 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)message.removeBody("sp"));
        Message.Body body = message.addBody("es", "test");
        Assert.assertTrue((message.getBodies().size() == 1 ? 1 : 0) != 0);
        message.removeBody(body);
        Assert.assertTrue((message.getBodies().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void setMessageThreadTest() throws IOException, SAXException, ParserConfigurationException {
        String messageThread = "1234";
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<message>").append("<thread>").append("1234").append("</thread>").append("</message>");
        String control = controlBuilder.toString();
        Message message = MessageTest.getNewMessage();
        message.setThread("1234");
        Assert.assertEquals((Object)"1234", (Object)message.getThread());
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML().toString());
    }

    @Test
    public void messageXmlLangTest() throws IOException, SAXException, ParserConfigurationException {
        String lang = "sp";
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<message").append(" xml:lang=\"").append("sp").append("\">").append("</message>");
        String control = controlBuilder.toString();
        Message message = MessageTest.getNewMessage();
        message.setLanguage("sp");
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML().toString());
    }

    @Test
    public void messageEqualityTest() {
        Message message = MessageTest.getNewMessage();
        Assert.assertTrue((boolean)message.equals((Object)message));
        Assert.assertFalse((boolean)message.equals(null));
        Assert.assertFalse((boolean)message.equals((Object)"test"));
        Message message2 = MessageTest.getNewMessage();
        Assert.assertTrue((boolean)message.equals((Object)message2));
        message.setTo("joe@shmoe.com");
        Assert.assertFalse((boolean)message.equals((Object)message2));
        message2.setTo("joe@shmoe.com");
        message.setSubject("subject");
        Assert.assertFalse((boolean)message.equals((Object)message2));
        message2.setSubject("subject");
        message.setThread("thread");
        Assert.assertFalse((boolean)message.equals((Object)message2));
        message2.setThread("thread");
        message.setBody("body1");
        Assert.assertFalse((boolean)message.equals((Object)message2));
        message2.setBody("body1");
        message.setLanguage("language");
        Assert.assertFalse((boolean)message.equals((Object)message2));
        message2.setLanguage("language");
        message.setType(Message.Type.chat);
        Assert.assertFalse((boolean)message.equals((Object)message2));
        message2.setType(Message.Type.chat);
        Assert.assertTrue((boolean)message.equals((Object)message2));
    }

    private static Message getNewMessage() {
        Message message = new Message();
        message.setPacketID(null);
        return message;
    }
}

