/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.ExceptionCallback;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SynchronizationPoint;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.filter.IQReplyFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.Bind;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Mechanisms;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.PlainStreamElement;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.RosterVer;
import org.jivesoftware.smack.packet.Session;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.provider.StreamFeatureProvider;
import org.jivesoftware.smack.rosterstore.RosterStore;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jxmpp.util.XmppStringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class AbstractXMPPConnection
implements XMPPConnection {
    private static final Logger LOGGER = Logger.getLogger(AbstractXMPPConnection.class.getName());
    private static final AtomicInteger connectionCounter = new AtomicInteger(0);
    protected final Collection<ConnectionListener> connectionListeners = new CopyOnWriteArrayList<ConnectionListener>();
    protected final Collection<PacketCollector> collectors = new ConcurrentLinkedQueue<PacketCollector>();
    protected final Map<PacketListener, ListenerWrapper> recvListeners = new ConcurrentHashMap<PacketListener, ListenerWrapper>();
    protected final Map<PacketListener, ListenerWrapper> sendListeners = new ConcurrentHashMap<PacketListener, ListenerWrapper>();
    protected final Map<PacketInterceptor, InterceptorWrapper> interceptors = new ConcurrentHashMap<PacketInterceptor, InterceptorWrapper>();
    protected final Lock connectionLock = new ReentrantLock();
    protected final Map<String, PacketExtension> streamFeatures = new HashMap<String, PacketExtension>();
    protected String user;
    private long packetReplyTimeout = SmackConfiguration.getDefaultPacketReplyTimeout();
    protected SmackDebugger debugger = null;
    protected Reader reader;
    protected Writer writer;
    protected final SynchronizationPoint<Exception> lastFeaturesReceived = new SynchronizationPoint(this);
    protected final SynchronizationPoint<SmackException> saslFeatureReceived = new SynchronizationPoint(this);
    protected SASLAuthentication saslAuthentication = new SASLAuthentication(this);
    protected final int connectionCounterValue = connectionCounter.getAndIncrement();
    protected final ConnectionConfiguration config;
    private XMPPConnection.FromMode fromMode = XMPPConnection.FromMode.OMITTED;
    protected XMPPInputOutputStream compressionHandler;
    private final ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1, new SmackExecutorThreadFactory(this.connectionCounterValue));
    private Roster roster;
    protected String host;
    protected int port;
    protected boolean authenticated = false;
    protected boolean wasAuthenticated = false;
    private boolean anonymous = false;
    private final ScheduledExecutorService removeCallbacksService = new ScheduledThreadPoolExecutor(1, new SmackExecutorThreadFactory(this.connectionCounterValue));
    private long lastStanzaReceived;

    protected static Collection<ConnectionCreationListener> getConnectionCreationListeners() {
        return XMPPConnectionRegistry.getConnectionCreationListeners();
    }

    protected AbstractXMPPConnection(ConnectionConfiguration configuration) {
        this.config = configuration;
    }

    protected ConnectionConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public String getServiceName() {
        return this.config.getServiceName();
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public abstract String getUser();

    @Override
    public abstract String getConnectionID();

    @Override
    public abstract boolean isConnected();

    @Override
    public abstract boolean isAuthenticated();

    @Override
    public abstract boolean isSecureConnection();

    protected abstract void sendPacketInternal(Packet var1) throws SmackException.NotConnectedException;

    @Override
    public abstract void send(PlainStreamElement var1) throws SmackException.NotConnectedException;

    @Override
    public abstract boolean isUsingCompression();

    public void connect() throws SmackException, IOException, XMPPException {
        this.saslAuthentication.init();
        this.saslFeatureReceived.init();
        this.lastFeaturesReceived.init();
        this.connectInternal();
    }

    protected abstract void connectInternal() throws SmackException, IOException, XMPPException;

    public void login(String username, String password) throws XMPPException, SmackException, IOException {
        this.login(username, password, "Smack");
    }

    public abstract void login(String var1, String var2, String var3) throws XMPPException, SmackException, IOException;

    public abstract void loginAnonymously() throws XMPPException, SmackException, IOException;

    protected void bindResourceAndEstablishSession(String resource) throws XMPPException.XMPPErrorException, IOException, SmackException {
        LOGGER.finer("Waiting for last features to be received before continuing with resource binding");
        this.lastFeaturesReceived.checkIfSuccessOrWait();
        if (!this.hasFeature("bind", "urn:ietf:params:xml:ns:xmpp-bind")) {
            throw new SmackException.ResourceBindingNotOfferedException();
        }
        Bind bindResource = Bind.newSet(resource);
        PacketCollector packetCollector = this.createPacketCollector(new PacketIDFilter(bindResource));
        try {
            this.sendPacket(bindResource);
        }
        catch (SmackException.NotConnectedException e) {
            packetCollector.cancel();
            throw e;
        }
        Bind response = (Bind)packetCollector.nextResultOrThrow();
        this.user = response.getJid();
        this.setServiceName(XmppStringUtils.parseDomain((String)this.user));
        if (this.hasFeature("session", "urn:ietf:params:xml:ns:xmpp-session") && !this.getConfiguration().isLegacySessionDisabled()) {
            Session session = new Session();
            packetCollector = this.createPacketCollector(new PacketIDFilter(session));
            try {
                this.sendPacket(session);
            }
            catch (SmackException.NotConnectedException e) {
                packetCollector.cancel();
                throw e;
            }
            packetCollector.nextResultOrThrow();
        }
    }

    protected void afterSuccessfulLogin(boolean anonymous, boolean resumed) throws SmackException.NotConnectedException {
        this.authenticated = true;
        this.anonymous = anonymous;
        if (this.config.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
        this.callConnectionAuthenticatedListener();
        if (this.config.isSendPresence() && !resumed) {
            this.sendPacket(new Presence(Presence.Type.available));
        }
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    protected void setServiceName(String serviceName) {
        this.config.setServiceName(serviceName);
    }

    protected void setLoginInfo(String username, String password, String resource) {
        this.config.setLoginInfo(username, password, resource);
    }

    protected void maybeResolveDns() throws Exception {
        this.config.maybeResolveDns();
    }

    protected Lock getConnectionLock() {
        return this.connectionLock;
    }

    @Override
    public void sendPacket(Packet packet) throws SmackException.NotConnectedException {
        if (!this.isConnected()) {
            throw new SmackException.NotConnectedException();
        }
        if (packet == null) {
            throw new IllegalArgumentException("Packet must not be null");
        }
        switch (this.fromMode) {
            case OMITTED: {
                packet.setFrom(null);
                break;
            }
            case USER: {
                packet.setFrom(this.getUser());
                break;
            }
        }
        this.firePacketInterceptors(packet);
        this.sendPacketInternal(packet);
        this.firePacketSendingListeners(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Roster getRoster() {
        if (this.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster");
        }
        Object object = this;
        synchronized (object) {
            if (this.roster == null) {
                this.roster = new Roster(this);
            }
            if (!this.isAuthenticated()) {
                return this.roster;
            }
        }
        if (!this.roster.rosterInitialized && this.config.isRosterLoadedAtLogin()) {
            try {
                object = this.roster;
                synchronized (object) {
                    long now;
                    long start = System.currentTimeMillis();
                    for (long waitTime = this.getPacketReplyTimeout(); !this.roster.rosterInitialized && waitTime > 0L; waitTime -= now - start) {
                        this.roster.wait(waitTime);
                        now = System.currentTimeMillis();
                        start = now;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.roster;
    }

    protected SASLAuthentication getSASLAuthentication() {
        return this.saslAuthentication;
    }

    public void disconnect() throws SmackException.NotConnectedException {
        this.disconnect(new Presence(Presence.Type.unavailable));
    }

    public synchronized void disconnect(Presence unavailablePresence) throws SmackException.NotConnectedException {
        if (!this.isConnected()) {
            return;
        }
        this.sendPacket(unavailablePresence);
        this.shutdown();
        this.callConnectionClosedListener();
    }

    protected abstract void shutdown();

    @Override
    public void addConnectionListener(ConnectionListener connectionListener) {
        if (connectionListener == null) {
            return;
        }
        if (!this.connectionListeners.contains(connectionListener)) {
            this.connectionListeners.add(connectionListener);
        }
    }

    @Override
    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.remove(connectionListener);
    }

    protected Collection<ConnectionListener> getConnectionListeners() {
        return this.connectionListeners;
    }

    @Override
    public PacketCollector createPacketCollectorAndSend(IQ packet) throws SmackException.NotConnectedException {
        IQReplyFilter packetFilter = new IQReplyFilter(packet, this);
        PacketCollector packetCollector = this.createPacketCollector(packetFilter);
        try {
            this.sendPacket(packet);
        }
        catch (SmackException.NotConnectedException e) {
            packetCollector.cancel();
            throw e;
        }
        return packetCollector;
    }

    @Override
    public PacketCollector createPacketCollector(PacketFilter packetFilter) {
        PacketCollector collector = new PacketCollector(this, packetFilter);
        this.collectors.add(collector);
        return collector;
    }

    @Override
    public void removePacketCollector(PacketCollector collector) {
        this.collectors.remove(collector);
    }

    protected Collection<PacketCollector> getPacketCollectors() {
        return this.collectors;
    }

    @Override
    public void addPacketListener(PacketListener packetListener, PacketFilter packetFilter) {
        if (packetListener == null) {
            throw new NullPointerException("Packet listener is null.");
        }
        ListenerWrapper wrapper = new ListenerWrapper(packetListener, packetFilter);
        this.recvListeners.put(packetListener, wrapper);
    }

    @Override
    public boolean removePacketListener(PacketListener packetListener) {
        return this.recvListeners.remove(packetListener) != null;
    }

    @Override
    public void addPacketSendingListener(PacketListener packetListener, PacketFilter packetFilter) {
        if (packetListener == null) {
            throw new NullPointerException("Packet listener is null.");
        }
        ListenerWrapper wrapper = new ListenerWrapper(packetListener, packetFilter);
        this.sendListeners.put(packetListener, wrapper);
    }

    @Override
    public void removePacketSendingListener(PacketListener packetListener) {
        this.sendListeners.remove(packetListener);
    }

    protected Map<PacketListener, ListenerWrapper> getPacketSendingListeners() {
        return this.sendListeners;
    }

    private void firePacketSendingListeners(Packet packet) {
        for (ListenerWrapper listenerWrapper : this.sendListeners.values()) {
            try {
                listenerWrapper.notifyListener(packet);
            }
            catch (SmackException.NotConnectedException e) {
                LOGGER.log(Level.WARNING, "Got not connected exception, aborting");
                break;
            }
        }
    }

    @Override
    public void addPacketInterceptor(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
        if (packetInterceptor == null) {
            throw new NullPointerException("Packet interceptor is null.");
        }
        this.interceptors.put(packetInterceptor, new InterceptorWrapper(packetInterceptor, packetFilter));
    }

    @Override
    public void removePacketInterceptor(PacketInterceptor packetInterceptor) {
        this.interceptors.remove(packetInterceptor);
    }

    protected Map<PacketInterceptor, InterceptorWrapper> getPacketInterceptors() {
        return this.interceptors;
    }

    private void firePacketInterceptors(Packet packet) {
        if (packet != null) {
            for (InterceptorWrapper interceptorWrapper : this.interceptors.values()) {
                interceptorWrapper.notifyListener(packet);
            }
        }
    }

    protected void initDebugger() {
        if (this.reader == null || this.writer == null) {
            throw new NullPointerException("Reader or writer isn't initialized.");
        }
        if (this.config.isDebuggerEnabled()) {
            if (this.debugger == null) {
                this.debugger = SmackConfiguration.createDebugger(this, this.writer, this.reader);
            }
            if (this.debugger == null) {
                LOGGER.severe("Debugging enabled but could not find debugger class");
            } else {
                this.reader = this.debugger.newConnectionReader(this.reader);
                this.writer = this.debugger.newConnectionWriter(this.writer);
            }
        }
    }

    @Override
    public long getPacketReplyTimeout() {
        return this.packetReplyTimeout;
    }

    @Override
    public void setPacketReplyTimeout(long timeout) {
        this.packetReplyTimeout = timeout;
    }

    protected void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        for (PacketCollector collector : this.getPacketCollectors()) {
            collector.processPacket(packet);
        }
        this.executorService.submit(new ListenerNotification(packet));
    }

    protected void setWasAuthenticated(boolean authenticated) {
        if (!this.wasAuthenticated) {
            this.wasAuthenticated = authenticated;
        }
    }

    protected void callConnectionConnectedListener() {
        for (ConnectionListener listener : this.getConnectionListeners()) {
            listener.connected(this);
        }
    }

    protected void callConnectionAuthenticatedListener() {
        for (ConnectionListener listener : this.getConnectionListeners()) {
            listener.authenticated(this);
        }
    }

    void callConnectionClosedListener() {
        for (ConnectionListener listener : this.getConnectionListeners()) {
            try {
                listener.connectionClosed();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error in listener while closing connection", e);
            }
        }
    }

    protected void callConnectionClosedOnErrorListener(Exception e) {
        LOGGER.log(Level.WARNING, "Connection closed with error", e);
        for (ConnectionListener listener : this.getConnectionListeners()) {
            try {
                listener.connectionClosedOnError(e);
            }
            catch (Exception e2) {
                LOGGER.log(Level.SEVERE, "Error in listener while closing connection", e2);
            }
        }
    }

    @Override
    public int getConnectionCounter() {
        return this.connectionCounterValue;
    }

    @Override
    public void setFromMode(XMPPConnection.FromMode fromMode) {
        this.fromMode = fromMode;
    }

    @Override
    public XMPPConnection.FromMode getFromMode() {
        return this.fromMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.executorService.shutdownNow();
            this.removeCallbacksService.shutdownNow();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public RosterStore getRosterStore() {
        return this.config.getRosterStore();
    }

    @Override
    public boolean isRosterLoadedAtLogin() {
        return this.config.isRosterLoadedAtLogin();
    }

    protected final void parseFeatures(XmlPullParser parser) throws XmlPullParserException, IOException, SmackException {
        this.streamFeatures.clear();
        int initialDepth = parser.getDepth();
        while (true) {
            int eventType;
            if ((eventType = parser.next()) == 2 && parser.getDepth() == initialDepth + 1) {
                PacketExtension streamFeature = null;
                String name = parser.getName();
                String namespace = parser.getNamespace();
                switch (name) {
                    case "starttls": {
                        streamFeature = PacketParserUtils.parseStartTlsFeature(parser);
                        break;
                    }
                    case "mechanisms": {
                        streamFeature = new Mechanisms(PacketParserUtils.parseMechanisms(parser));
                        break;
                    }
                    case "bind": {
                        streamFeature = Bind.Feature.INSTANCE;
                        break;
                    }
                    case "session": {
                        streamFeature = Session.Feature.INSTANCE;
                        break;
                    }
                    case "ver": {
                        if (namespace.equals("urn:xmpp:features:rosterver")) {
                            streamFeature = RosterVer.INSTANCE;
                            break;
                        }
                        LOGGER.severe("Unkown Roster Versioning Namespace: " + namespace + ". Roster versioning not enabled");
                        break;
                    }
                    case "compression": {
                        streamFeature = PacketParserUtils.parseCompressionFeature(parser);
                        break;
                    }
                    default: {
                        StreamFeatureProvider provider = ProviderManager.getStreamFeatureProvider(name, namespace);
                        if (provider == null) break;
                        streamFeature = provider.parseStreamFeature(parser);
                    }
                }
                if (streamFeature == null) continue;
                this.addStreamFeature(streamFeature);
                continue;
            }
            if (eventType == 3 && parser.getDepth() == initialDepth) break;
        }
        if (this.hasFeature("mechanisms", "urn:ietf:params:xml:ns:xmpp-sasl") && (!this.hasFeature("starttls", "urn:ietf:params:xml:ns:xmpp-tls") || this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled)) {
            this.saslFeatureReceived.reportSuccess();
        }
        if (!(!this.hasFeature("bind", "urn:ietf:params:xml:ns:xmpp-bind") || this.hasFeature("compression", "http://jabber.org/protocol/compress") && this.config.isCompressionEnabled())) {
            this.lastFeaturesReceived.reportSuccess();
        }
        this.afterFeaturesReceived();
    }

    protected void afterFeaturesReceived() throws SmackException.SecurityRequiredException, SmackException.NotConnectedException {
    }

    @Override
    public <F extends PacketExtension> F getFeature(String element, String namespace) {
        return (F)this.streamFeatures.get(XmppStringUtils.generateKey((String)element, (String)namespace));
    }

    @Override
    public boolean hasFeature(String element, String namespace) {
        return this.getFeature(element, namespace) != null;
    }

    private void addStreamFeature(PacketExtension feature) {
        String key = XmppStringUtils.generateKey((String)feature.getElementName(), (String)feature.getNamespace());
        this.streamFeatures.put(key, feature);
    }

    @Override
    public void sendStanzaWithResponseCallback(Packet stanza, PacketFilter replyFilter, PacketListener callback) throws SmackException.NotConnectedException {
        this.sendStanzaWithResponseCallback(stanza, replyFilter, callback, null);
    }

    @Override
    public void sendStanzaWithResponseCallback(Packet stanza, PacketFilter replyFilter, PacketListener callback, ExceptionCallback exceptionCallback) throws SmackException.NotConnectedException {
        this.sendStanzaWithResponseCallback(stanza, replyFilter, callback, exceptionCallback, this.getPacketReplyTimeout());
    }

    @Override
    public void sendStanzaWithResponseCallback(Packet stanza, PacketFilter replyFilter, final PacketListener callback, final ExceptionCallback exceptionCallback, long timeout) throws SmackException.NotConnectedException {
        if (stanza == null) {
            throw new IllegalArgumentException("stanza must not be null");
        }
        if (replyFilter == null) {
            throw new IllegalArgumentException("replyFilter must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        final PacketListener packetListener = new PacketListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processPacket(Packet packet) throws SmackException.NotConnectedException {
                try {
                    XMPPException.XMPPErrorException.ifHasErrorThenThrow(packet);
                    callback.processPacket(packet);
                }
                catch (XMPPException.XMPPErrorException e) {
                    if (exceptionCallback != null) {
                        exceptionCallback.processException(e);
                    }
                }
                finally {
                    AbstractXMPPConnection.this.removePacketListener(this);
                }
            }
        };
        this.removeCallbacksService.schedule(new Runnable(){

            @Override
            public void run() {
                boolean removed = AbstractXMPPConnection.this.removePacketListener(packetListener);
                if (removed && exceptionCallback != null) {
                    exceptionCallback.processException(new SmackException.NoResponseException());
                }
            }
        }, timeout, TimeUnit.MILLISECONDS);
        this.addPacketListener(packetListener, replyFilter);
        this.sendPacket(stanza);
    }

    @Override
    public void sendIqWithResponseCallback(IQ iqRequest, PacketListener callback) throws SmackException.NotConnectedException {
        this.sendIqWithResponseCallback(iqRequest, callback, null);
    }

    @Override
    public void sendIqWithResponseCallback(IQ iqRequest, PacketListener callback, ExceptionCallback exceptionCallback) throws SmackException.NotConnectedException {
        this.sendIqWithResponseCallback(iqRequest, callback, exceptionCallback, this.getPacketReplyTimeout());
    }

    @Override
    public void sendIqWithResponseCallback(IQ iqRequest, PacketListener callback, ExceptionCallback exceptionCallback, long timeout) throws SmackException.NotConnectedException {
        IQReplyFilter replyFilter = new IQReplyFilter(iqRequest, this);
        this.sendStanzaWithResponseCallback(iqRequest, replyFilter, callback, exceptionCallback, timeout);
    }

    @Override
    public long getLastStanzaReceived() {
        return this.lastStanzaReceived;
    }

    protected void reportStanzaReceived() {
        this.lastStanzaReceived = System.currentTimeMillis();
    }

    static {
        SmackConfiguration.getVersion();
    }

    protected static class InterceptorWrapper {
        private PacketInterceptor packetInterceptor;
        private PacketFilter packetFilter;

        public InterceptorWrapper(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
            this.packetInterceptor = packetInterceptor;
            this.packetFilter = packetFilter;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof InterceptorWrapper) {
                return ((InterceptorWrapper)object).packetInterceptor.equals(this.packetInterceptor);
            }
            if (object instanceof PacketInterceptor) {
                return object.equals(this.packetInterceptor);
            }
            return false;
        }

        public void notifyListener(Packet packet) {
            if (this.packetFilter == null || this.packetFilter.accept(packet)) {
                this.packetInterceptor.interceptPacket(packet);
            }
        }
    }

    protected static class ListenerWrapper {
        private PacketListener packetListener;
        private PacketFilter packetFilter;

        public ListenerWrapper(PacketListener packetListener, PacketFilter packetFilter) {
            this.packetListener = packetListener;
            this.packetFilter = packetFilter;
        }

        public void notifyListener(Packet packet) throws SmackException.NotConnectedException {
            if (this.packetFilter == null || this.packetFilter.accept(packet)) {
                this.packetListener.processPacket(packet);
            }
        }
    }

    private class ListenerNotification
    implements Runnable {
        private Packet packet;

        public ListenerNotification(Packet packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            for (ListenerWrapper listenerWrapper : AbstractXMPPConnection.this.recvListeners.values()) {
                try {
                    listenerWrapper.notifyListener(this.packet);
                }
                catch (SmackException.NotConnectedException e) {
                    LOGGER.log(Level.WARNING, "Got not connected exception, aborting", e);
                    break;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Exception in packet listener", e);
                }
            }
        }
    }

    private static final class SmackExecutorThreadFactory
    implements ThreadFactory {
        private final int connectionCounterValue;
        private int count = 0;

        private SmackExecutorThreadFactory(int connectionCounterValue) {
            this.connectionCounterValue = connectionCounterValue;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "Smack Executor Service " + this.count++ + " (" + this.connectionCounterValue + ")");
            thread.setDaemon(true);
            return thread;
        }
    }
}

