/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.compression.Java7ZlibInputOutputStream;
import org.jivesoftware.smack.initializer.SmackInitializer;
import org.jivesoftware.smack.util.FileUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public final class SmackInitialization {
    static final String SMACK_VERSION;
    private static final String DEFAULT_CONFIG_FILE = "classpath:org.jivesoftware.smack/smack-config.xml";
    private static final Logger LOGGER;

    public static void processConfigFile(InputStream cfgFileStream, Collection<Exception> exceptions) throws Exception {
        SmackInitialization.processConfigFile(cfgFileStream, exceptions, SmackInitialization.class.getClassLoader());
    }

    public static void processConfigFile(InputStream cfgFileStream, Collection<Exception> exceptions, ClassLoader classLoader) throws Exception {
        XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        parser.setInput(cfgFileStream, "UTF-8");
        int eventType = parser.getEventType();
        do {
            if (eventType != 2) continue;
            if (parser.getName().equals("startupClasses")) {
                SmackInitialization.parseClassesToLoad(parser, false, exceptions, classLoader);
                continue;
            }
            if (!parser.getName().equals("optionalStartupClasses")) continue;
            SmackInitialization.parseClassesToLoad(parser, true, exceptions, classLoader);
        } while ((eventType = parser.next()) != 1);
        try {
            cfgFileStream.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error while closing config file input stream", e);
        }
    }

    private static void parseClassesToLoad(XmlPullParser parser, boolean optional, Collection<Exception> exceptions, ClassLoader classLoader) throws XmlPullParserException, IOException, Exception {
        String name;
        int eventType;
        String startName = parser.getName();
        block2: do {
            eventType = parser.next();
            name = parser.getName();
            if (eventType != 2 || !"className".equals(name)) continue;
            String classToLoad = parser.nextText();
            for (String disabledClassOrPackage : SmackConfiguration.disabledSmackClasses) {
                if (disabledClassOrPackage.equals(classToLoad)) continue block2;
                int lastDotIndex = disabledClassOrPackage.lastIndexOf(46);
                if (disabledClassOrPackage.length() <= lastDotIndex || Character.isUpperCase(disabledClassOrPackage.charAt(lastDotIndex + 1)) || !classToLoad.startsWith(disabledClassOrPackage)) continue;
                continue block2;
            }
            try {
                SmackInitialization.loadSmackClass(classToLoad, optional, classLoader);
            }
            catch (Exception e) {
                if (exceptions != null) {
                    exceptions.add(e);
                    continue;
                }
                throw e;
            }
        } while (eventType != 3 || !startName.equals(name));
    }

    private static void loadSmackClass(String className, boolean optional, ClassLoader classLoader) throws Exception {
        Class<?> initClass;
        try {
            initClass = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException cnfe) {
            Level logLevel = optional ? Level.FINE : Level.WARNING;
            LOGGER.log(logLevel, "A startup class '" + className + "' could not be loaded.");
            if (!optional) {
                throw cnfe;
            }
            return;
        }
        if (SmackInitializer.class.isAssignableFrom(initClass)) {
            SmackInitializer initializer = (SmackInitializer)initClass.newInstance();
            List<Exception> exceptions = initializer.initialize();
            if (exceptions == null || exceptions.size() == 0) {
                LOGGER.log(Level.FINE, "Loaded SmackInitializer " + className);
            } else {
                for (Exception e : exceptions) {
                    LOGGER.log(Level.SEVERE, "Exception in loadSmackClass", e);
                }
            }
        } else {
            LOGGER.log(Level.FINE, "Loaded " + className);
        }
    }

    static {
        InputStream configFileStream;
        String smackVersion;
        LOGGER = Logger.getLogger(SmackInitialization.class.getName());
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(FileUtils.getStreamForUrl("classpath:org.jivesoftware.smack/version", null)));
            smackVersion = reader.readLine();
            try {
                reader.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "IOException closing stream", e);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not determine Smack version", e);
            smackVersion = "unkown";
        }
        SMACK_VERSION = smackVersion;
        String disabledClasses = System.getProperty("smack.disabledClasses");
        if (disabledClasses != null) {
            String[] splitDisabledClasses;
            for (String s : splitDisabledClasses = disabledClasses.split(",")) {
                SmackConfiguration.disabledSmackClasses.add(s);
            }
        }
        try {
            FileUtils.addLines("classpath:org.jivesoftware.smack/disabledClasses", SmackConfiguration.disabledSmackClasses);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        try {
            Class<?> c = Class.forName("org.jivesoftware.smack.CustomSmackConfiguration");
            Field f = c.getField("DISABLED_SMACK_CLASSES");
            String[] sa = (String[])f.get(null);
            if (sa != null) {
                LOGGER.warning("Using CustomSmackConfig is deprecated and will be removed in a future release");
                for (String s : sa) {
                    SmackConfiguration.disabledSmackClasses.add(s);
                }
            }
        }
        catch (ClassNotFoundException e1) {
        }
        catch (NoSuchFieldException e) {
        }
        catch (SecurityException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        try {
            configFileStream = FileUtils.getStreamForUrl(DEFAULT_CONFIG_FILE, null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        try {
            SmackInitialization.processConfigFile(configFileStream, null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        SmackConfiguration.compressionHandlers.add(new Java7ZlibInputOutputStream());
        try {
            SmackConfiguration.DEBUG_ENABLED = Boolean.getBoolean("smack.debugEnabled");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SmackConfiguration.smackInitialized = true;
    }
}

