/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filters;

import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.packet.Packet;
import org.junit.Assert;
import org.junit.Test;

public class FromMatchesFilterTest {
    private static final String BASE_JID1 = "ss@muc.myserver.com";
    private static final String FULL_JID1_R1 = "ss@muc.myserver.com/resource";
    private static final String FULL_JID1_R2 = "ss@muc.myserver.com/resource2";
    private static final String BASE_JID2 = "sss@muc.myserver.com";
    private static final String FULL_JID2 = "sss@muc.myserver.com/resource";
    private static final String BASE_JID3 = "ss@muc.myserver.comm.net";
    private static final String SERVICE_JID1 = "muc.myserver.com";
    private static final String SERVICE_JID2 = "pubsub.myserver.com";

    @Test
    public void autoCompareMatchingFullJid() {
        FromMatchesFilter filter = FromMatchesFilter.create((String)FULL_JID1_R1);
        Packet packet = new Packet(){

            public String toXML() {
                return null;
            }
        };
        packet.setFrom(FULL_JID1_R1);
        Assert.assertTrue((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID1);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(FULL_JID1_R2);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID2);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(FULL_JID2);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID3);
        Assert.assertFalse((boolean)filter.accept(packet));
    }

    @Test
    public void autoCompareMatchingBaseJid() {
        FromMatchesFilter filter = FromMatchesFilter.create((String)BASE_JID1);
        Packet packet = new Packet(){

            public String toXML() {
                return null;
            }
        };
        packet.setFrom(BASE_JID1);
        Assert.assertTrue((boolean)filter.accept(packet));
        packet.setFrom(FULL_JID1_R1);
        Assert.assertTrue((boolean)filter.accept(packet));
        packet.setFrom(FULL_JID1_R2);
        Assert.assertTrue((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID2);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(FULL_JID2);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID3);
        Assert.assertFalse((boolean)filter.accept(packet));
    }

    @Test
    public void autoCompareMatchingServiceJid() {
        FromMatchesFilter filter = FromMatchesFilter.create((String)SERVICE_JID1);
        Packet packet = new Packet(){

            public String toXML() {
                return null;
            }
        };
        packet.setFrom(SERVICE_JID1);
        Assert.assertTrue((boolean)filter.accept(packet));
        packet.setFrom(SERVICE_JID2);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID1);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(FULL_JID1_R1);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID3);
        Assert.assertFalse((boolean)filter.accept(packet));
    }

    @Test
    public void bareCompareMatchingFullJid() {
        FromMatchesFilter filter = FromMatchesFilter.createBare((String)FULL_JID1_R1);
        Packet packet = new Packet(){

            public String toXML() {
                return null;
            }
        };
        packet.setFrom(BASE_JID1);
        Assert.assertTrue((boolean)filter.accept(packet));
        packet.setFrom(FULL_JID1_R1);
        Assert.assertTrue((boolean)filter.accept(packet));
        packet.setFrom(FULL_JID1_R2);
        Assert.assertTrue((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID2);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(FULL_JID2);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID3);
        Assert.assertFalse((boolean)filter.accept(packet));
    }

    @Test
    public void bareCompareMatchingBaseJid() {
        FromMatchesFilter filter = FromMatchesFilter.createBare((String)BASE_JID1);
        Packet packet = new Packet(){

            public String toXML() {
                return null;
            }
        };
        packet.setFrom(BASE_JID1);
        Assert.assertTrue((boolean)filter.accept(packet));
        packet.setFrom(FULL_JID1_R1);
        Assert.assertTrue((boolean)filter.accept(packet));
        packet.setFrom(FULL_JID1_R2);
        Assert.assertTrue((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID2);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(FULL_JID2);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID3);
        Assert.assertFalse((boolean)filter.accept(packet));
    }

    @Test
    public void bareCompareMatchingServiceJid() {
        FromMatchesFilter filter = FromMatchesFilter.createBare((String)SERVICE_JID1);
        Packet packet = new Packet(){

            public String toXML() {
                return null;
            }
        };
        packet.setFrom(SERVICE_JID1);
        Assert.assertTrue((boolean)filter.accept(packet));
        packet.setFrom(SERVICE_JID2);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID1);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(FULL_JID1_R1);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID3);
        Assert.assertFalse((boolean)filter.accept(packet));
    }

    @Test
    public void fullCompareMatchingFullJid() {
        FromMatchesFilter filter = FromMatchesFilter.createFull((String)FULL_JID1_R1);
        Packet packet = new Packet(){

            public String toXML() {
                return null;
            }
        };
        packet.setFrom(FULL_JID1_R1);
        Assert.assertTrue((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID1);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(FULL_JID1_R2);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID2);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(FULL_JID2);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID3);
        Assert.assertFalse((boolean)filter.accept(packet));
    }

    @Test
    public void fullCompareMatchingBaseJid() {
        FromMatchesFilter filter = FromMatchesFilter.createFull((String)BASE_JID1);
        Packet packet = new Packet(){

            public String toXML() {
                return null;
            }
        };
        packet.setFrom(BASE_JID1);
        Assert.assertTrue((boolean)filter.accept(packet));
        packet.setFrom(FULL_JID1_R1);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(FULL_JID1_R2);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID2);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(FULL_JID2);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID3);
        Assert.assertFalse((boolean)filter.accept(packet));
    }

    @Test
    public void fullCompareMatchingServiceJid() {
        FromMatchesFilter filter = FromMatchesFilter.createFull((String)SERVICE_JID1);
        Packet packet = new Packet(){

            public String toXML() {
                return null;
            }
        };
        packet.setFrom(SERVICE_JID1);
        Assert.assertTrue((boolean)filter.accept(packet));
        packet.setFrom(SERVICE_JID2);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID1);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(FULL_JID1_R1);
        Assert.assertFalse((boolean)filter.accept(packet));
        packet.setFrom(BASE_JID3);
        Assert.assertFalse((boolean)filter.accept(packet));
    }
}

