/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.test.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class TestUtils {
    private TestUtils() {
    }

    public static XmlPullParser getIQParser(String stanza) {
        return TestUtils.getParser(stanza, "iq");
    }

    public static XmlPullParser getMessageParser(String stanza) {
        return TestUtils.getParser(stanza, "message");
    }

    public static XmlPullParser getPresenceParser(String stanza) {
        return TestUtils.getParser(stanza, "presence");
    }

    public static XmlPullParser getParser(String string, String startTag) {
        return TestUtils.getParser(new StringReader(string), startTag);
    }

    public static XmlPullParser getParser(Reader reader, String startTag) {
        XmlPullParser parser;
        try {
            parser = PacketParserUtils.newXmppParser((Reader)reader);
            if (startTag == null) {
                return parser;
            }
            boolean found = false;
            while (!found) {
                if (parser.next() != 2 || !parser.getName().equals(startTag)) continue;
                found = true;
            }
            if (!found) {
                throw new IllegalArgumentException("Can not find start tag '" + startTag + "'");
            }
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return parser;
    }
}

