/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.util.dns.HostAddress;

public class SmackException
extends Exception {
    private static final long serialVersionUID = 1844674365368214457L;

    public SmackException(Throwable wrappedThrowable) {
        super(wrappedThrowable);
    }

    public SmackException(String message) {
        super(message);
    }

    public SmackException(String message, Throwable wrappedThrowable) {
        super(message, wrappedThrowable);
    }

    protected SmackException() {
    }

    public static class ResourceBindingNotOfferedException
    extends SmackException {
        private static final long serialVersionUID = 2346934138253437571L;
    }

    public static class FeatureNotSupportedException
    extends SmackException {
        private static final long serialVersionUID = 4713404802621452016L;
        private final String feature;
        private final String jid;

        public FeatureNotSupportedException(String feature) {
            this(feature, (String)null);
        }

        public FeatureNotSupportedException(String feature, String jid) {
            super(feature + " not supported" + (jid == null ? "" : " by '" + jid + "'"));
            this.jid = jid;
            this.feature = feature;
        }

        public String getFeature() {
            return this.feature;
        }

        public String getJid() {
            return this.jid;
        }
    }

    public static class ConnectionException
    extends SmackException {
        private static final long serialVersionUID = 1686944201672697996L;
        private final List<HostAddress> failedAddresses;

        public ConnectionException(Throwable wrappedThrowable) {
            super(wrappedThrowable);
            this.failedAddresses = new ArrayList<HostAddress>(0);
        }

        private ConnectionException(String message, List<HostAddress> failedAddresses) {
            super(message);
            this.failedAddresses = failedAddresses;
        }

        public static ConnectionException from(List<HostAddress> failedAddresses) {
            StringBuilder sb = new StringBuilder("The following addresses failed: ");
            for (HostAddress hostAddress : failedAddresses) {
                sb.append(hostAddress.getErrorMessage());
                sb.append(", ");
            }
            sb.deleteCharAt(sb.length() - 1);
            return new ConnectionException(sb.toString(), failedAddresses);
        }

        public List<HostAddress> getFailedAddresses() {
            return this.failedAddresses;
        }
    }

    public static class SecurityNotPossibleException
    extends SmackException {
        private static final long serialVersionUID = -6836090872690331336L;

        public SecurityNotPossibleException(String message) {
            super(message);
        }
    }

    public static class SecurityRequiredException
    extends SmackException {
        private static final long serialVersionUID = 384291845029773545L;

        public SecurityRequiredException() {
        }

        public SecurityRequiredException(String message) {
            super(message);
        }
    }

    public static class IllegalStateChangeException
    extends SmackException {
        private static final long serialVersionUID = -1766023961577168927L;
    }

    public static class NotConnectedException
    extends SmackException {
        private static final long serialVersionUID = 9197980400776001173L;
    }

    public static class AlreadyConnectedException
    extends SmackException {
        private static final long serialVersionUID = 5011416918049135231L;
    }

    public static class AlreadyLoggedInException
    extends SmackException {
        private static final long serialVersionUID = 5011416918049935231L;
    }

    public static class NotLoggedInException
    extends SmackException {
        private static final long serialVersionUID = 3216216839100019278L;
    }

    public static class NoResponseException
    extends SmackException {
        private static final long serialVersionUID = -6523363748984543636L;
    }
}

