/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.stringencoder;

import java.io.UnsupportedEncodingException;

public class Base64 {
    private static Encoder base64encoder;

    public static void setEncoder(Encoder encoder) {
        if (encoder == null) {
            throw new IllegalArgumentException("encoder must no be null");
        }
        base64encoder = encoder;
    }

    public static final String encode(String string) {
        try {
            return Base64.encodeToString(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 not supported", e);
        }
    }

    public static final String encodeToString(byte[] input) {
        byte[] bytes = Base64.encode(input);
        try {
            return new String(bytes, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static final String encodeToString(byte[] input, int offset, int len) {
        byte[] bytes = Base64.encode(input, offset, len);
        try {
            return new String(bytes, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static final byte[] encode(byte[] input) {
        return Base64.encode(input, 0, input.length);
    }

    public static final byte[] encode(byte[] input, int offset, int len) {
        return base64encoder.encode(input, offset, len);
    }

    public static final String decodeToString(String string) {
        byte[] bytes = Base64.decode(string);
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 not supported", e);
        }
    }

    public static final String decodeToString(byte[] input, int offset, int len) {
        byte[] bytes = Base64.decode(input, offset, len);
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 not supported", e);
        }
    }

    public static final byte[] decode(String string) {
        return base64encoder.decode(string);
    }

    public static final byte[] decode(byte[] input) {
        return base64encoder.decode(input, 0, input.length);
    }

    public static final byte[] decode(byte[] input, int offset, int len) {
        return base64encoder.decode(input, offset, len);
    }

    public static interface Encoder {
        public byte[] decode(String var1);

        public byte[] decode(byte[] var1, int var2, int var3);

        public String encodeToString(byte[] var1, int var2, int var3);

        public byte[] encode(byte[] var1, int var2, int var3);
    }
}

