/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Date;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PlainStreamElement;

public class DummyConnection
extends AbstractXMPPConnection {
    private boolean authenticated = false;
    private boolean anonymous = false;
    private boolean reconnect = false;
    private String user;
    private String connectionID;
    private Roster roster;
    private final BlockingQueue<Element> queue = new LinkedBlockingQueue<Element>();

    public DummyConnection() {
        this(new ConnectionConfiguration("example.com"));
    }

    public DummyConnection(ConnectionConfiguration configuration) {
        super(configuration);
        for (ConnectionCreationListener listener : XMPPConnectionRegistry.getConnectionCreationListeners()) {
            listener.connectionCreated((XMPPConnection)this);
        }
    }

    protected void connectInternal() {
        this.connectionID = "dummy-" + new Random(new Date().getTime()).nextInt();
        if (this.reconnect) {
            for (ConnectionListener listener : this.getConnectionListeners()) {
                listener.reconnectionSuccessful();
            }
        }
    }

    protected void shutdown() {
        this.user = null;
        this.connectionID = null;
        this.roster = null;
        this.authenticated = false;
        this.anonymous = false;
        for (ConnectionListener listener : this.getConnectionListeners()) {
            listener.connectionClosed();
        }
        this.reconnect = true;
    }

    public String getConnectionID() {
        if (!this.isConnected()) {
            return null;
        }
        if (this.connectionID == null) {
            this.connectionID = "dummy-" + new Random(new Date().getTime()).nextInt();
        }
        return this.connectionID;
    }

    public Roster getRoster() {
        if (this.isAnonymous()) {
            return null;
        }
        if (this.roster == null) {
            this.roster = new Roster((XMPPConnection)this);
        }
        return this.roster;
    }

    public String getUser() {
        if (this.user == null) {
            this.user = "dummy@" + this.config.getServiceName() + "/Test";
        }
        return this.user;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isConnected() {
        return true;
    }

    public boolean isSecureConnection() {
        return false;
    }

    public boolean isUsingCompression() {
        return false;
    }

    public void login(String username, String password, String resource) throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.isAuthenticated()) {
            throw new IllegalStateException("Already logged in to server.");
        }
        this.user = (username != null ? username : "dummy") + "@" + this.config.getServiceName() + "/" + (resource != null ? resource : "Test");
        this.roster = new Roster((XMPPConnection)this);
        this.anonymous = false;
        this.authenticated = true;
    }

    public void loginAnonymously() throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.isAuthenticated()) {
            throw new IllegalStateException("Already logged in to server.");
        }
        this.anonymous = true;
        this.authenticated = true;
    }

    public void send(PlainStreamElement element) {
        if (SmackConfiguration.DEBUG_ENABLED) {
            System.out.println("[SEND]: " + element.toXML());
        }
        this.queue.add((Element)element);
    }

    protected void sendPacketInternal(Packet packet) {
        if (SmackConfiguration.DEBUG_ENABLED) {
            System.out.println("[SEND]: " + packet.toXML());
        }
        this.queue.add((Element)packet);
    }

    public int getNumberOfSentPackets() {
        return this.queue.size();
    }

    public Packet getSentPacket() throws InterruptedException {
        return (Packet)this.queue.poll();
    }

    public Packet getSentPacket(int wait) throws InterruptedException {
        return (Packet)this.queue.poll(wait, TimeUnit.SECONDS);
    }

    public void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        this.invokePacketCollectors(packet);
        if (SmackConfiguration.DEBUG_ENABLED) {
            System.out.println("[RECV]: " + packet.toXML());
        }
        this.notifiyReceivedListeners(packet);
    }
}

