/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterGroup;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xmlpull.v1.XmlPullParser;

public class RosterTest {
    private DummyConnection connection;
    private TestRosterListener rosterListener;

    @Before
    public void setUp() throws Exception {
        this.connection = new DummyConnection();
        this.connection.connect();
        this.connection.login("rostertest", "secret");
        this.rosterListener = new TestRosterListener();
        this.connection.getRoster().addRosterListener((RosterListener)this.rosterListener);
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            if (this.rosterListener != null && this.connection.getRoster() != null) {
                this.connection.getRoster().removeRosterListener((RosterListener)this.rosterListener);
                this.rosterListener = null;
            }
            this.connection.disconnect();
            this.connection = null;
        }
    }

    @Test(timeout=5000L)
    public void testSimpleRosterInitialization() throws Exception {
        Roster roster = this.connection.getRoster();
        Assert.assertNotNull((String)"Can't get the roster from the provided connection!", (Object)roster);
        Assert.assertFalse((String)"Roster shouldn't be already initialized!", (boolean)roster.rosterInitialized);
        RosterTest.initRoster(this.connection, roster);
        Assert.assertTrue((String)"Roster can't be initialized!", (boolean)roster.rosterInitialized);
        RosterTest.verifyRomeosEntry(roster.getEntry("romeo@example.net"));
        RosterTest.verifyMercutiosEntry(roster.getEntry("mercutio@example.com"));
        RosterTest.verifyBenvoliosEntry(roster.getEntry("benvolio@example.net"));
        Assert.assertSame((String)"Wrong number of roster entries.", (Object)3, (Object)roster.getEntries().size());
        Assert.assertTrue((String)"The roster listener wasn't invoked for Romeo.", (boolean)this.rosterListener.getAddedAddresses().contains("romeo@example.net"));
        Assert.assertTrue((String)"The roster listener wasn't invoked for Mercutio.", (boolean)this.rosterListener.getAddedAddresses().contains("mercutio@example.com"));
        Assert.assertTrue((String)"The roster listener wasn't invoked for Benvolio.", (boolean)this.rosterListener.getAddedAddresses().contains("benvolio@example.net"));
        Assert.assertSame((String)"RosterListeners implies that a item was deleted!", (Object)0, (Object)this.rosterListener.getDeletedAddresses().size());
        Assert.assertSame((String)"RosterListeners implies that a item was updated!", (Object)0, (Object)this.rosterListener.getUpdatedAddresses().size());
    }

    @Test(timeout=5000L)
    public void testAddRosterItem() throws Throwable {
        String contactJID = "nurse@example.com";
        String contactName = "Nurse";
        final String[] contactGroup = new String[]{"Servants"};
        Roster roster = this.connection.getRoster();
        Assert.assertNotNull((String)"Can't get the roster from the provided connection!", (Object)roster);
        RosterTest.initRoster(this.connection, roster);
        this.rosterListener.reset();
        RosterUpdateResponder serverSimulator = new RosterUpdateResponder(){

            @Override
            void verifyUpdateRequest(RosterPacket updateRequest) {
                RosterPacket.Item item = (RosterPacket.Item)updateRequest.getRosterItems().iterator().next();
                Assert.assertSame((String)"The provided JID doesn't match the requested!", (Object)"nurse@example.com", (Object)item.getUser());
                Assert.assertSame((String)"The provided name doesn't match the requested!", (Object)"Nurse", (Object)item.getName());
                Assert.assertSame((String)"The provided group number doesn't match the requested!", (Object)contactGroup.length, (Object)item.getGroupNames().size());
                Assert.assertSame((String)"The provided group doesn't match the requested!", (Object)contactGroup[0], item.getGroupNames().iterator().next());
            }
        };
        serverSimulator.start();
        roster.createEntry("nurse@example.com", "Nurse", contactGroup);
        serverSimulator.join();
        Throwable exception = serverSimulator.getException();
        if (exception != null) {
            throw exception;
        }
        RosterEntry addedEntry = roster.getEntry("nurse@example.com");
        Assert.assertNotNull((String)"The new contact wasn't added to the roster!", (Object)addedEntry);
        Assert.assertTrue((String)"The roster listener wasn't invoked for the new contact!", (boolean)this.rosterListener.getAddedAddresses().contains("nurse@example.com"));
        Assert.assertSame((String)"Setup wrong name for the new contact!", (Object)"Nurse", (Object)addedEntry.getName());
        Assert.assertSame((String)"Setup wrong default subscription status!", (Object)RosterPacket.ItemType.none, (Object)addedEntry.getType());
        Assert.assertSame((String)"The new contact should be member of exactly one group!", (Object)1, (Object)addedEntry.getGroups().size());
        Assert.assertSame((String)"Setup wrong group name for the added contact!", (Object)contactGroup[0], (Object)((RosterGroup)addedEntry.getGroups().iterator().next()).getName());
        RosterTest.verifyRomeosEntry(roster.getEntry("romeo@example.net"));
        RosterTest.verifyMercutiosEntry(roster.getEntry("mercutio@example.com"));
        RosterTest.verifyBenvoliosEntry(roster.getEntry("benvolio@example.net"));
        Assert.assertSame((String)"Wrong number of roster entries.", (Object)4, (Object)roster.getEntries().size());
    }

    @Test(timeout=5000L)
    public void testUpdateRosterItem() throws Throwable {
        String contactJID = "romeo@example.net";
        String contactName = "Romeo";
        final String[] contactGroups = new String[]{"Friends", "Lovers"};
        Roster roster = this.connection.getRoster();
        Assert.assertNotNull((String)"Can't get the roster from the provided connection!", (Object)roster);
        RosterTest.initRoster(this.connection, roster);
        this.rosterListener.reset();
        RosterUpdateResponder serverSimulator = new RosterUpdateResponder(){

            @Override
            void verifyUpdateRequest(RosterPacket updateRequest) {
                RosterPacket.Item item = (RosterPacket.Item)updateRequest.getRosterItems().iterator().next();
                Assert.assertSame((String)"The provided JID doesn't match the requested!", (Object)"romeo@example.net", (Object)item.getUser());
                Assert.assertSame((String)"The provided name doesn't match the requested!", (Object)"Romeo", (Object)item.getName());
                Assert.assertTrue((String)("The updated contact doesn't belong to the requested groups (" + contactGroups[0] + ")!"), (boolean)item.getGroupNames().contains(contactGroups[0]));
                Assert.assertTrue((String)("The updated contact doesn't belong to the requested groups (" + contactGroups[1] + ")!"), (boolean)item.getGroupNames().contains(contactGroups[1]));
                Assert.assertSame((String)"The provided group number doesn't match the requested!", (Object)contactGroups.length, (Object)item.getGroupNames().size());
            }
        };
        serverSimulator.start();
        roster.createGroup(contactGroups[1]).addEntry(roster.getEntry("romeo@example.net"));
        serverSimulator.join();
        Throwable exception = serverSimulator.getException();
        if (exception != null) {
            throw exception;
        }
        RosterEntry addedEntry = roster.getEntry("romeo@example.net");
        Assert.assertNotNull((String)"The contact was deleted from the roster!", (Object)addedEntry);
        Assert.assertTrue((String)"The roster listener wasn't invoked for the updated contact!", (boolean)this.rosterListener.getUpdatedAddresses().contains("romeo@example.net"));
        Assert.assertSame((String)"Setup wrong name for the changed contact!", (Object)"Romeo", (Object)addedEntry.getName());
        Assert.assertTrue((String)("The updated contact doesn't belong to the requested groups (" + contactGroups[0] + ")!"), (boolean)roster.getGroup(contactGroups[0]).contains(addedEntry));
        Assert.assertTrue((String)("The updated contact doesn't belong to the requested groups (" + contactGroups[1] + ")!"), (boolean)roster.getGroup(contactGroups[1]).contains(addedEntry));
        Assert.assertSame((String)"The updated contact should be member of two groups!", (Object)contactGroups.length, (Object)addedEntry.getGroups().size());
        RosterTest.verifyMercutiosEntry(roster.getEntry("mercutio@example.com"));
        RosterTest.verifyBenvoliosEntry(roster.getEntry("benvolio@example.net"));
        Assert.assertSame((String)("Wrong number of roster entries (" + roster.getEntries() + ")."), (Object)3, (Object)roster.getEntries().size());
    }

    @Test(timeout=5000L)
    public void testDeleteRosterItem() throws Throwable {
        String contactJID = "romeo@example.net";
        Roster roster = this.connection.getRoster();
        Assert.assertNotNull((String)"Can't get the roster from the provided connection!", (Object)roster);
        RosterTest.initRoster(this.connection, roster);
        this.rosterListener.reset();
        RosterUpdateResponder serverSimulator = new RosterUpdateResponder(){

            @Override
            void verifyUpdateRequest(RosterPacket updateRequest) {
                RosterPacket.Item item = (RosterPacket.Item)updateRequest.getRosterItems().iterator().next();
                Assert.assertSame((String)"The provided JID doesn't match the requested!", (Object)"romeo@example.net", (Object)item.getUser());
            }
        };
        serverSimulator.start();
        roster.removeEntry(roster.getEntry("romeo@example.net"));
        serverSimulator.join();
        Throwable exception = serverSimulator.getException();
        if (exception != null) {
            throw exception;
        }
        RosterEntry deletedEntry = roster.getEntry("romeo@example.net");
        Assert.assertNull((String)"The contact wasn't deleted from the roster!", (Object)deletedEntry);
        Assert.assertTrue((String)"The roster listener wasn't invoked for the deleted contact!", (boolean)this.rosterListener.getDeletedAddresses().contains("romeo@example.net"));
        RosterTest.verifyMercutiosEntry(roster.getEntry("mercutio@example.com"));
        RosterTest.verifyBenvoliosEntry(roster.getEntry("benvolio@example.net"));
        Assert.assertSame((String)("Wrong number of roster entries (" + roster.getEntries() + ")."), (Object)2, (Object)roster.getEntries().size());
    }

    @Test(timeout=5000L)
    public void testSimpleRosterPush() throws Throwable {
        String contactJID = "nurse@example.com";
        Roster roster = this.connection.getRoster();
        Assert.assertNotNull((String)"Can't get the roster from the provided connection!", (Object)roster);
        StringBuilder sb = new StringBuilder();
        sb.append("<iq id=\"rostertest1\" type=\"set\" ").append("to=\"").append(this.connection.getUser()).append("\">").append("<query xmlns=\"jabber:iq:roster\">").append("<item jid=\"").append("nurse@example.com").append("\"/>").append("</query>").append("</iq>");
        XmlPullParser parser = TestUtils.getIQParser(sb.toString());
        IQ rosterPush = PacketParserUtils.parse((XmlPullParser)parser, (XMPPConnection)this.connection);
        RosterTest.initRoster(this.connection, roster);
        this.rosterListener.reset();
        this.connection.processPacket((Packet)rosterPush);
        RosterEntry addedEntry = roster.getEntry("nurse@example.com");
        Assert.assertNotNull((String)"The new contact wasn't added to the roster!", (Object)addedEntry);
        Assert.assertTrue((String)"The roster listener wasn't invoked for the new contact!", (boolean)this.rosterListener.getAddedAddresses().contains("nurse@example.com"));
        Assert.assertSame((String)"Setup wrong default subscription status!", (Object)RosterPacket.ItemType.none, (Object)addedEntry.getType());
        Assert.assertSame((String)"The new contact shouldn't be member of any group!", (Object)0, (Object)addedEntry.getGroups().size());
        RosterTest.verifyRomeosEntry(roster.getEntry("romeo@example.net"));
        RosterTest.verifyMercutiosEntry(roster.getEntry("mercutio@example.com"));
        RosterTest.verifyBenvoliosEntry(roster.getEntry("benvolio@example.net"));
        Assert.assertSame((String)"Wrong number of roster entries.", (Object)4, (Object)roster.getEntries().size());
    }

    @Test(timeout=5000L)
    public void testIgnoreInvalidFrom() {
        RosterPacket packet = new RosterPacket();
        packet.setType(IQ.Type.set);
        packet.setTo(this.connection.getUser());
        packet.setFrom("mallory@example.com");
        packet.addRosterItem(new RosterPacket.Item("spam@example.com", "Cool products!"));
        this.connection.processPacket((Packet)packet);
        Assert.assertNull((String)"Contact was added to roster", (Object)this.connection.getRoster().getEntry("spam@example.com"));
    }

    @Test(timeout=5000L)
    public void testAddEmptyGroupEntry() throws Throwable {
        String contactJID = "nurse@example.com";
        String contactName = "Nurse";
        String[] contactGroup = new String[]{""};
        Roster roster = this.connection.getRoster();
        Assert.assertNotNull((String)"Can't get the roster from the provided connection!", (Object)roster);
        RosterTest.initRoster(this.connection, roster);
        this.rosterListener.reset();
        RosterUpdateResponder serverSimulator = new RosterUpdateResponder(){

            @Override
            void verifyUpdateRequest(RosterPacket updateRequest) {
                RosterPacket.Item item = (RosterPacket.Item)updateRequest.getRosterItems().iterator().next();
                Assert.assertSame((String)"The provided JID doesn't match the requested!", (Object)"nurse@example.com", (Object)item.getUser());
                Assert.assertSame((String)"The provided name doesn't match the requested!", (Object)"Nurse", (Object)item.getName());
                Assert.assertSame((String)"Shouldn't provide an empty group element!", (Object)0, (Object)item.getGroupNames().size());
            }
        };
        serverSimulator.start();
        roster.createEntry("nurse@example.com", "Nurse", contactGroup);
        serverSimulator.join();
        Throwable exception = serverSimulator.getException();
        if (exception != null) {
            throw exception;
        }
        RosterEntry addedEntry = roster.getEntry("nurse@example.com");
        Assert.assertNotNull((String)"The new contact wasn't added to the roster!", (Object)addedEntry);
        Assert.assertTrue((String)"The roster listener wasn't invoked for the new contact!", (boolean)this.rosterListener.getAddedAddresses().contains("nurse@example.com"));
        Assert.assertSame((String)"Setup wrong name for the new contact!", (Object)"Nurse", (Object)addedEntry.getName());
        Assert.assertSame((String)"Setup wrong default subscription status!", (Object)RosterPacket.ItemType.none, (Object)addedEntry.getType());
        Assert.assertSame((String)"The new contact shouldn't be member of any group!", (Object)0, (Object)addedEntry.getGroups().size());
        RosterTest.verifyRomeosEntry(roster.getEntry("romeo@example.net"));
        RosterTest.verifyMercutiosEntry(roster.getEntry("mercutio@example.com"));
        RosterTest.verifyBenvoliosEntry(roster.getEntry("benvolio@example.net"));
        Assert.assertSame((String)"Wrong number of roster entries.", (Object)4, (Object)roster.getEntries().size());
    }

    @Test(timeout=5000L)
    public void testEmptyGroupRosterPush() throws Throwable {
        String contactJID = "nurse@example.com";
        Roster roster = this.connection.getRoster();
        Assert.assertNotNull((String)"Can't get the roster from the provided connection!", (Object)roster);
        StringBuilder sb = new StringBuilder();
        sb.append("<iq id=\"rostertest2\" type=\"set\" ").append("to=\"").append(this.connection.getUser()).append("\">").append("<query xmlns=\"jabber:iq:roster\">").append("<item jid=\"").append("nurse@example.com").append("\">").append("<group></group>").append("</item>").append("</query>").append("</iq>");
        XmlPullParser parser = TestUtils.getIQParser(sb.toString());
        IQ rosterPush = PacketParserUtils.parse((XmlPullParser)parser, (XMPPConnection)this.connection);
        RosterTest.initRoster(this.connection, roster);
        this.rosterListener.reset();
        this.connection.processPacket((Packet)rosterPush);
        RosterEntry addedEntry = roster.getEntry("nurse@example.com");
        Assert.assertNotNull((String)"The new contact wasn't added to the roster!", (Object)addedEntry);
        Assert.assertTrue((String)"The roster listener wasn't invoked for the new contact!", (boolean)this.rosterListener.getAddedAddresses().contains("nurse@example.com"));
        Assert.assertSame((String)"Setup wrong default subscription status!", (Object)RosterPacket.ItemType.none, (Object)addedEntry.getType());
        Assert.assertSame((String)"The new contact shouldn't be member of any group!", (Object)0, (Object)addedEntry.getGroups().size());
        RosterTest.verifyRomeosEntry(roster.getEntry("romeo@example.net"));
        RosterTest.verifyMercutiosEntry(roster.getEntry("mercutio@example.com"));
        RosterTest.verifyBenvoliosEntry(roster.getEntry("benvolio@example.net"));
        Assert.assertSame((String)"Wrong number of roster entries.", (Object)4, (Object)roster.getEntries().size());
    }

    public static void removeAllRosterEntries(DummyConnection connection, Roster roster) throws InterruptedException, XMPPException {
        for (RosterEntry entry : roster.getEntries()) {
            RosterPacket rosterPush = new RosterPacket();
            rosterPush.setType(IQ.Type.set);
            rosterPush.setTo(connection.getUser());
            RosterPacket.Item item = new RosterPacket.Item(entry.getUser(), entry.getName());
            item.setItemType(RosterPacket.ItemType.remove);
            rosterPush.addRosterItem(item);
            connection.processPacket((Packet)rosterPush);
        }
    }

    public static void initRoster(DummyConnection connection, Roster roster) throws InterruptedException, XMPPException, SmackException {
        Packet sentPacket;
        roster.reload();
        while (!((sentPacket = connection.getSentPacket()) instanceof RosterPacket) || ((IQ)sentPacket).getType() != IQ.Type.get) {
        }
        RosterPacket rosterRequest = (RosterPacket)sentPacket;
        Assert.assertSame((String)"The <query/> element MUST NOT contain any <item/> child elements!", (Object)0, (Object)rosterRequest.getRosterItemCount());
        RosterPacket rosterResult = new RosterPacket();
        rosterResult.setTo(connection.getUser());
        rosterResult.setType(IQ.Type.result);
        rosterResult.setPacketID(rosterRequest.getPacketID());
        RosterPacket.Item romeo = new RosterPacket.Item("romeo@example.net", "Romeo");
        romeo.addGroupName("Friends");
        romeo.setItemType(RosterPacket.ItemType.both);
        rosterResult.addRosterItem(romeo);
        RosterPacket.Item mercutio = new RosterPacket.Item("mercutio@example.com", "Mercutio");
        mercutio.setItemType(RosterPacket.ItemType.from);
        rosterResult.addRosterItem(mercutio);
        RosterPacket.Item benvolio = new RosterPacket.Item("benvolio@example.net", "Benvolio");
        benvolio.setItemType(RosterPacket.ItemType.both);
        rosterResult.addRosterItem(benvolio);
        connection.processPacket((Packet)rosterResult);
    }

    public static void verifyRomeosEntry(RosterEntry romeo) {
        Assert.assertNotNull((String)"Can't get Romeo's roster entry!", (Object)romeo);
        Assert.assertSame((String)"Setup wrong name for Romeo!", (Object)"Romeo", (Object)romeo.getName());
        Assert.assertSame((String)"Setup wrong subscription status for Romeo!", (Object)RosterPacket.ItemType.both, (Object)romeo.getType());
        Assert.assertSame((String)"Romeo should be member of exactly one group!", (Object)1, (Object)romeo.getGroups().size());
        Assert.assertSame((String)"Setup wrong group name for Romeo!", (Object)"Friends", (Object)((RosterGroup)romeo.getGroups().iterator().next()).getName());
    }

    public static void verifyMercutiosEntry(RosterEntry mercutio) {
        Assert.assertNotNull((String)"Can't get Mercutio's roster entry!", (Object)mercutio);
        Assert.assertSame((String)"Setup wrong name for Mercutio!", (Object)"Mercutio", (Object)mercutio.getName());
        Assert.assertSame((String)"Setup wrong subscription status for Mercutio!", (Object)RosterPacket.ItemType.from, (Object)mercutio.getType());
        Assert.assertTrue((String)"Mercutio shouldn't be a member of any group!", (boolean)mercutio.getGroups().isEmpty());
    }

    public static void verifyBenvoliosEntry(RosterEntry benvolio) {
        Assert.assertNotNull((String)"Can't get Benvolio's roster entry!", (Object)benvolio);
        Assert.assertSame((String)"Setup wrong name for Benvolio!", (Object)"Benvolio", (Object)benvolio.getName());
        Assert.assertSame((String)"Setup wrong subscription status for Benvolio!", (Object)RosterPacket.ItemType.both, (Object)benvolio.getType());
        Assert.assertTrue((String)"Benvolio shouldn't be a member of any group!", (boolean)benvolio.getGroups().isEmpty());
    }

    public static class TestRosterListener
    implements RosterListener {
        private CopyOnWriteArrayList<String> addressesAdded = new CopyOnWriteArrayList();
        private CopyOnWriteArrayList<String> addressesDeleted = new CopyOnWriteArrayList();
        private CopyOnWriteArrayList<String> addressesUpdated = new CopyOnWriteArrayList();

        public synchronized void entriesAdded(Collection<String> addresses) {
            this.addressesAdded.addAll(addresses);
            if (SmackConfiguration.DEBUG_ENABLED) {
                for (String address : addresses) {
                    System.out.println("Roster entry for " + address + " added.");
                }
            }
        }

        public synchronized void entriesDeleted(Collection<String> addresses) {
            this.addressesDeleted.addAll(addresses);
            if (SmackConfiguration.DEBUG_ENABLED) {
                for (String address : addresses) {
                    System.out.println("Roster entry for " + address + " deleted.");
                }
            }
        }

        public synchronized void entriesUpdated(Collection<String> addresses) {
            this.addressesUpdated.addAll(addresses);
            if (SmackConfiguration.DEBUG_ENABLED) {
                for (String address : addresses) {
                    System.out.println("Roster entry for " + address + " updated.");
                }
            }
        }

        public void presenceChanged(Presence presence) {
            if (SmackConfiguration.DEBUG_ENABLED) {
                System.out.println("Roster presence changed: " + presence.toXML());
            }
        }

        public Collection<String> getAddedAddresses() {
            return Collections.unmodifiableCollection(this.addressesAdded);
        }

        public Collection<String> getDeletedAddresses() {
            return Collections.unmodifiableCollection(this.addressesDeleted);
        }

        public Collection<String> getUpdatedAddresses() {
            return Collections.unmodifiableCollection(this.addressesUpdated);
        }

        public synchronized void reset() {
            this.addressesAdded.clear();
            this.addressesDeleted.clear();
            this.addressesUpdated.clear();
        }
    }

    private abstract class RosterUpdateResponder
    extends Thread {
        private Throwable exception = null;

        private RosterUpdateResponder() {
        }

        abstract void verifyUpdateRequest(RosterPacket var1);

        @Override
        public void run() {
            try {
                Packet packet;
                while (!((packet = RosterTest.this.connection.getSentPacket()) instanceof RosterPacket) || ((IQ)packet).getType() != IQ.Type.set) {
                }
                RosterPacket rosterRequest = (RosterPacket)packet;
                RosterPacket rosterPush = new RosterPacket();
                RosterPacket.Item item = (RosterPacket.Item)rosterRequest.getRosterItems().iterator().next();
                if (item.getItemType() != RosterPacket.ItemType.remove) {
                    item.setItemType(RosterPacket.ItemType.none);
                }
                rosterPush.setType(IQ.Type.set);
                rosterPush.setTo(RosterTest.this.connection.getUser());
                rosterPush.addRosterItem(item);
                RosterTest.this.connection.processPacket((Packet)rosterPush);
                IQ response = new IQ(){

                    public String getChildElementXML() {
                        return null;
                    }
                };
                response.setPacketID(rosterRequest.getPacketID());
                response.setType(IQ.Type.result);
                response.setTo(RosterTest.this.connection.getUser());
                RosterTest.this.connection.processPacket((Packet)response);
                Assert.assertSame((String)"A roster set MUST contain one and only one <item/> element.", (Object)1, (Object)rosterRequest.getRosterItemCount());
                this.verifyUpdateRequest(rosterRequest);
            }
            catch (Throwable e) {
                this.exception = e;
                Assert.fail((String)e.getMessage());
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

