/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XMPPError;
import org.junit.Assert;
import org.junit.Test;

public class IQResponseTest {
    private static final String childElement = "<child xmlns=\"http://igniterealtime.org/protocol/test\"/>";

    @Test
    public void testGeneratingSimpleResponse() {
        IQ request = new IQ(){

            public String getChildElementXML() {
                return IQResponseTest.childElement;
            }
        };
        request.setFrom("sender@test/Smack");
        request.setTo("receiver@test/Smack");
        IQ result = IQ.createResultIQ((IQ)request);
        Assert.assertEquals((Object)IQ.Type.result, (Object)result.getType());
        Assert.assertNotNull((Object)result.getPacketID());
        Assert.assertEquals((Object)request.getPacketID(), (Object)result.getPacketID());
        Assert.assertEquals((Object)request.getFrom(), (Object)result.getTo());
        Assert.assertEquals((Object)request.getTo(), (Object)result.getFrom());
        Assert.assertNull((Object)result.getChildElementXML());
    }

    @Test
    public void testGeneratingValidErrorResponse() {
        XMPPError error = new XMPPError(XMPPError.Condition.bad_request);
        IQ request = new IQ(){

            public String getChildElementXML() {
                return IQResponseTest.childElement;
            }
        };
        request.setType(IQ.Type.set);
        request.setFrom("sender@test/Smack");
        request.setTo("receiver@test/Smack");
        IQ result = IQ.createErrorResponse((IQ)request, (XMPPError)error);
        Assert.assertEquals((Object)IQ.Type.error, (Object)result.getType());
        Assert.assertNotNull((Object)result.getPacketID());
        Assert.assertEquals((Object)request.getPacketID(), (Object)result.getPacketID());
        Assert.assertEquals((Object)request.getFrom(), (Object)result.getTo());
        Assert.assertEquals((Object)error, (Object)result.getError());
        Assert.assertEquals((Object)childElement, (Object)result.getChildElementXML());
    }

    @Test
    public void testGeneratingResponseBasedOnResult() {
        IQ request = new IQ(){

            public String getChildElementXML() {
                return IQResponseTest.childElement;
            }
        };
        request.setType(IQ.Type.result);
        request.setFrom("sender@test/Smack");
        request.setTo("receiver@test/Smack");
        try {
            IQ.createResultIQ((IQ)request);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Assert.fail((String)"It shouldn't be possible to generate a response for a result IQ!");
    }

    @Test
    public void testGeneratingErrorBasedOnError() {
        XMPPError error = new XMPPError(XMPPError.Condition.bad_request);
        IQ request = new IQ(){

            public String getChildElementXML() {
                return IQResponseTest.childElement;
            }
        };
        request.setType(IQ.Type.error);
        request.setFrom("sender@test/Smack");
        request.setTo("receiver@test/Smack");
        request.setError(error);
        try {
            IQ.createErrorResponse((IQ)request, (XMPPError)error);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Assert.fail((String)"It shouldn't be possible to generate a response for a error IQ!");
    }
}

