/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Locale;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.XmlStringBuilder;

public abstract class IQ
extends Packet {
    public static final String ELEMENT = "iq";
    public static final String QUERY_ELEMENT = "query";
    private Type type = Type.get;

    public IQ() {
    }

    public IQ(IQ iq) {
        super(iq);
        this.type = iq.getType();
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type == null ? Type.get : type;
    }

    @Override
    public CharSequence toXML() {
        XmlStringBuilder buf = new XmlStringBuilder();
        buf.halfOpenElement(ELEMENT);
        this.addCommonAttributes(buf);
        if (this.type == null) {
            buf.attribute("type", "get");
        } else {
            buf.attribute("type", this.type.toString());
        }
        buf.rightAngleBracket();
        buf.optAppend(this.getChildElementXML());
        XMPPError error = this.getError();
        if (error != null) {
            buf.append(error.toXML());
        }
        buf.closeElement(ELEMENT);
        return buf;
    }

    public abstract CharSequence getChildElementXML();

    public static IQ createResultIQ(IQ request) {
        if (request.getType() != Type.get && request.getType() != Type.set) {
            throw new IllegalArgumentException("IQ must be of type 'set' or 'get'. Original IQ: " + request.toXML());
        }
        IQ result = new IQ(){

            @Override
            public String getChildElementXML() {
                return null;
            }
        };
        result.setType(Type.result);
        result.setPacketID(request.getPacketID());
        result.setFrom(request.getTo());
        result.setTo(request.getFrom());
        return result;
    }

    public static IQ createErrorResponse(final IQ request, XMPPError error) {
        if (request.getType() != Type.get && request.getType() != Type.set) {
            throw new IllegalArgumentException("IQ must be of type 'set' or 'get'. Original IQ: " + request.toXML());
        }
        IQ result = new IQ(){

            @Override
            public CharSequence getChildElementXML() {
                return request.getChildElementXML();
            }
        };
        result.setType(Type.error);
        result.setPacketID(request.getPacketID());
        result.setFrom(request.getTo());
        result.setTo(request.getFrom());
        result.setError(error);
        return result;
    }

    public static enum Type {
        get,
        set,
        result,
        error;


        public static Type fromString(String string) {
            return Type.valueOf(string.toLowerCase(Locale.US));
        }
    }
}

