/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.ExtensionProviderInfo;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.IQProviderInfo;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderLoader;
import org.jxmpp.util.XmppStringUtils;

public final class ProviderManager {
    private static final Map<String, PacketExtensionProvider<PacketExtension>> extensionProviders = new ConcurrentHashMap<String, PacketExtensionProvider<PacketExtension>>();
    private static final Map<String, IQProvider<IQ>> iqProviders = new ConcurrentHashMap<String, IQProvider<IQ>>();
    private static final Map<String, Class<?>> extensionIntrospectionProviders = new ConcurrentHashMap();
    private static final Map<String, Class<?>> iqIntrospectionProviders = new ConcurrentHashMap();
    private static final Map<String, PacketExtensionProvider<PacketExtension>> streamFeatureProviders = new ConcurrentHashMap<String, PacketExtensionProvider<PacketExtension>>();

    public static void addLoader(ProviderLoader loader) {
        if (loader.getIQProviderInfo() != null) {
            for (IQProviderInfo iQProviderInfo : loader.getIQProviderInfo()) {
                ProviderManager.addIQProvider(iQProviderInfo.getElementName(), iQProviderInfo.getNamespace(), iQProviderInfo.getProvider());
            }
        }
        if (loader.getExtensionProviderInfo() != null) {
            for (ExtensionProviderInfo extensionProviderInfo : loader.getExtensionProviderInfo()) {
                ProviderManager.addExtensionProvider(extensionProviderInfo.getElementName(), extensionProviderInfo.getNamespace(), extensionProviderInfo.getProvider());
            }
        }
    }

    public static IQProvider<IQ> getIQProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        return iqProviders.get(key);
    }

    public static Class<?> getIQIntrospectionProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        return iqIntrospectionProviders.get(key);
    }

    public static List<Object> getIQProviders() {
        ArrayList<Object> providers = new ArrayList<Object>(iqProviders.size() + iqIntrospectionProviders.size());
        providers.addAll(iqProviders.values());
        providers.addAll(iqIntrospectionProviders.values());
        return Collections.unmodifiableList(providers);
    }

    public static void addIQProvider(String elementName, String namespace, Object provider) {
        String key = ProviderManager.removeIQProvider(elementName, namespace);
        if (provider instanceof IQProvider) {
            iqProviders.put(key, (IQProvider)provider);
        } else if (provider instanceof Class && IQ.class.isAssignableFrom((Class)provider)) {
            iqIntrospectionProviders.put(key, (Class)provider);
        } else {
            throw new IllegalArgumentException("Provider must be an IQProvider or a Class instance sublcassing IQ.");
        }
    }

    public static String removeIQProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        iqProviders.remove(key);
        iqIntrospectionProviders.remove(key);
        return key;
    }

    public static PacketExtensionProvider<PacketExtension> getExtensionProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        return extensionProviders.get(key);
    }

    public static Class<?> getExtensionIntrospectionProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        return extensionIntrospectionProviders.get(key);
    }

    public static void addExtensionProvider(String elementName, String namespace, Object provider) {
        String key = ProviderManager.removeExtensionProvider(elementName, namespace);
        if (provider instanceof PacketExtensionProvider) {
            extensionProviders.put(key, (PacketExtensionProvider)provider);
        } else if (provider instanceof Class && PacketExtension.class.isAssignableFrom((Class)provider)) {
            extensionIntrospectionProviders.put(key, (Class)provider);
        } else {
            throw new IllegalArgumentException("Provider must be a PacketExtensionProvider or a Class instance.");
        }
    }

    public static String removeExtensionProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        extensionProviders.remove(key);
        extensionIntrospectionProviders.remove(key);
        return key;
    }

    public static List<Object> getExtensionProviders() {
        ArrayList<Object> providers = new ArrayList<Object>(extensionProviders.size() + extensionIntrospectionProviders.size());
        providers.addAll(extensionProviders.values());
        providers.addAll(extensionIntrospectionProviders.values());
        return Collections.unmodifiableList(providers);
    }

    public static PacketExtensionProvider<PacketExtension> getStreamFeatureProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        return streamFeatureProviders.get(key);
    }

    public static void addStreamFeatureProvider(String elementName, String namespace, PacketExtensionProvider<PacketExtension> provider) {
        String key = ProviderManager.getKey(elementName, namespace);
        streamFeatureProviders.put(key, provider);
    }

    public static void removeStreamFeatureProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        streamFeatureProviders.remove(key);
    }

    private static String getKey(String elementName, String namespace) {
        return XmppStringUtils.generateKey((String)elementName, (String)namespace);
    }

    static {
        SmackConfiguration.getVersion();
    }
}

