/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl.packet;

import org.jivesoftware.smack.packet.PlainStreamElement;
import org.jivesoftware.smack.sasl.SASLError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class SaslStreamElements {
    public static final String NAMESPACE = "urn:ietf:params:xml:ns:xmpp-sasl";

    public static class SASLFailure
    extends PlainStreamElement {
        public static final String ELEMENT = "failure";
        private final SASLError saslError;
        private final String saslErrorString;

        public SASLFailure(String saslError) {
            SASLError error = SASLError.fromString(saslError);
            this.saslError = error == null ? SASLError.not_authorized : error;
            this.saslErrorString = saslError;
        }

        public SASLError getSASLError() {
            return this.saslError;
        }

        public String getSASLErrorString() {
            return this.saslErrorString;
        }

        @Override
        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement(ELEMENT).xmlnsAttribute(ELEMENT).rightAngleBracket();
            xml.emptyElement(this.saslErrorString);
            xml.closeElement(ELEMENT);
            return xml;
        }
    }

    public static class Success
    extends PlainStreamElement {
        public static final String ELEMENT = "success";
        private final String data;

        public Success(String data) {
            this.data = StringUtils.returnIfNotEmptyTrimmed(data);
        }

        public String getData() {
            return this.data;
        }

        @Override
        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement(ELEMENT).xmlnsAttribute(SaslStreamElements.NAMESPACE).rightAngleBracket();
            xml.optAppend(this.data);
            xml.closeElement(ELEMENT);
            return xml;
        }
    }

    public static class Response
    extends PlainStreamElement {
        public static final String ELEMENT = "response";
        private final String authenticationText;

        public Response() {
            this.authenticationText = null;
        }

        public Response(String authenticationText) {
            this.authenticationText = StringUtils.returnIfNotEmptyTrimmed(authenticationText);
        }

        @Override
        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement(ELEMENT).xmlnsAttribute(SaslStreamElements.NAMESPACE).rightAngleBracket();
            xml.optAppend(this.authenticationText);
            xml.closeElement(ELEMENT);
            return xml;
        }
    }

    public static class Challenge
    extends PlainStreamElement {
        public static final String ELEMENT = "challenge";
        private final String data;

        public Challenge(String data) {
            this.data = StringUtils.returnIfNotEmptyTrimmed(data);
        }

        @Override
        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder().halfOpenElement(ELEMENT).xmlnsAttribute(SaslStreamElements.NAMESPACE).rightAngleBracket();
            xml.optAppend(this.data);
            xml.closeElement(ELEMENT);
            return xml;
        }
    }

    public static class AuthMechanism
    extends PlainStreamElement {
        public static final String ELEMENT = "auth";
        private final String mechanism;
        private final String authenticationText;

        public AuthMechanism(String mechanism, String authenticationText) {
            if (mechanism == null) {
                throw new NullPointerException("SASL mechanism shouldn't be null.");
            }
            if (StringUtils.isNullOrEmpty(authenticationText)) {
                throw new IllegalArgumentException("SASL authenticationText must not be null or empty (RFC6120 6.4.2)");
            }
            this.mechanism = mechanism;
            this.authenticationText = authenticationText;
        }

        @Override
        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement(ELEMENT).xmlnsAttribute(SaslStreamElements.NAMESPACE).attribute("mechanism", this.mechanism).rightAngleBracket();
            xml.optAppend(this.authenticationText);
            xml.closeElement(ELEMENT);
            return xml;
        }
    }
}

