/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.compress.packet.Compress;
import org.jivesoftware.smack.packet.Bind;
import org.jivesoftware.smack.packet.DefaultPacketExtension;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.packet.StartTls;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.sasl.packet.SaslStreamElements;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class PacketParserUtils {
    private static final Logger LOGGER = Logger.getLogger(PacketParserUtils.class.getName());
    public static final String FEATURE_XML_ROUNDTRIP = "http://xmlpull.org/v1/doc/features.html#xml-roundtrip";

    public static XmlPullParser getParserFor(String stanza) throws XmlPullParserException, IOException {
        return PacketParserUtils.getParserFor(new StringReader(stanza));
    }

    public static XmlPullParser getParserFor(Reader reader) throws XmlPullParserException, IOException {
        XmlPullParser parser = PacketParserUtils.newXmppParser(reader);
        int event = parser.getEventType();
        while (event != 2) {
            if (event == 1) {
                throw new IllegalArgumentException("Document contains no start tag");
            }
            event = parser.next();
        }
        return parser;
    }

    public static XmlPullParser getParserFor(String stanza, String startTag) throws XmlPullParserException, IOException {
        XmlPullParser parser = PacketParserUtils.getParserFor(stanza);
        while (true) {
            int event = parser.getEventType();
            String name = parser.getName();
            if (event == 2 && name.equals(startTag)) break;
            if (event == 1) {
                throw new IllegalArgumentException("Could not find start tag '" + startTag + "' in stanza: " + stanza);
            }
            parser.next();
        }
        return parser;
    }

    public static Packet parseStanza(String stanza) throws Exception {
        return PacketParserUtils.parseStanza(PacketParserUtils.getParserFor(stanza));
    }

    public static Packet parseStanza(XmlPullParser parser) throws Exception {
        return PacketParserUtils.parseStanza(parser, null);
    }

    public static Packet parseStanza(XmlPullParser parser, XMPPConnection connection) throws Exception {
        String name;
        assert (parser.getEventType() == 2);
        switch (name = parser.getName()) {
            case "message": {
                return PacketParserUtils.parseMessage(parser);
            }
            case "iq": {
                return PacketParserUtils.parse(parser, connection);
            }
            case "presence": {
                return PacketParserUtils.parsePresence(parser);
            }
        }
        throw new IllegalArgumentException("Can only parse message, iq or presence, not " + name);
    }

    public static XmlPullParser newXmppParser() throws XmlPullParserException {
        XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        try {
            parser.setFeature(FEATURE_XML_ROUNDTRIP, true);
        }
        catch (XmlPullParserException e) {
            LOGGER.log(Level.FINEST, "XmlPullParser does not support XML_ROUNDTRIP", e);
        }
        return parser;
    }

    public static XmlPullParser newXmppParser(Reader reader) throws XmlPullParserException {
        XmlPullParser parser = PacketParserUtils.newXmppParser();
        parser.setInput(reader);
        return parser;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Message parseMessage(XmlPullParser parser) throws XmlPullParserException, IOException, SmackException {
        ParserUtils.assertAtStartTag(parser);
        assert (parser.getName().equals("message"));
        int initialDepth = parser.getDepth();
        Message message = new Message();
        message.setPacketID(parser.getAttributeValue("", "id"));
        message.setTo(parser.getAttributeValue("", "to"));
        message.setFrom(parser.getAttributeValue("", "from"));
        String typeString = parser.getAttributeValue("", "type");
        if (typeString != null) {
            message.setType(Message.Type.fromString(typeString));
        }
        String language = PacketParserUtils.getLanguageAttribute(parser);
        String defaultLanguage = null;
        if (language != null && !"".equals(language.trim())) {
            message.setLanguage(language);
            defaultLanguage = language;
        } else {
            defaultLanguage = Packet.getDefaultLanguage();
        }
        String thread = null;
        block16: while (true) {
            int eventType = parser.next();
            switch (eventType) {
                case 2: {
                    String elementName = parser.getName();
                    String namespace = parser.getNamespace();
                    switch (elementName) {
                        case "subject": {
                            String xmlLangSubject = PacketParserUtils.getLanguageAttribute(parser);
                            if (xmlLangSubject == null) {
                                xmlLangSubject = defaultLanguage;
                            }
                            String subject = PacketParserUtils.parseElementText(parser);
                            if (message.getSubject(xmlLangSubject) != null) break;
                            message.addSubject(xmlLangSubject, subject);
                            break;
                        }
                        case "body": {
                            String xmlLang = PacketParserUtils.getLanguageAttribute(parser);
                            if (xmlLang == null) {
                                xmlLang = defaultLanguage;
                            }
                            String body = PacketParserUtils.parseElementText(parser);
                            if (message.getBody(xmlLang) != null) break;
                            message.addBody(xmlLang, body);
                            break;
                        }
                        case "thread": {
                            if (thread != null) break;
                            thread = parser.nextText();
                            break;
                        }
                        case "error": {
                            message.setError(PacketParserUtils.parseError(parser));
                            break;
                        }
                        default: {
                            PacketParserUtils.addPacketExtension(message, parser, elementName, namespace);
                            break;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() == initialDepth) break block16;
                }
            }
        }
        message.setThread(thread);
        return message;
    }

    public static String parseElementText(XmlPullParser parser) throws XmlPullParserException, IOException {
        String res;
        assert (parser.getEventType() == 2);
        if (parser.isEmptyElementTag()) {
            res = "";
        } else {
            int event = parser.next();
            if (event != 4) {
                if (event == 3) {
                    return "";
                }
                throw new XmlPullParserException("Non-empty element tag not followed by text, while Mixed Content (XML 3.2.2) is disallowed");
            }
            res = parser.getText();
            event = parser.next();
            if (event != 3) {
                throw new XmlPullParserException("Non-empty element tag contains child-elements, while Mixed Content (XML 3.2.2) is disallowed");
            }
        }
        return res;
    }

    public static CharSequence parseElement(XmlPullParser parser) throws XmlPullParserException, IOException {
        return PacketParserUtils.parseElement(parser, false);
    }

    public static CharSequence parseElement(XmlPullParser parser, boolean fullNamespaces) throws XmlPullParserException, IOException {
        assert (parser.getEventType() == 2);
        return PacketParserUtils.parseContentDepth(parser, parser.getDepth(), fullNamespaces);
    }

    public static CharSequence parseContent(XmlPullParser parser) throws XmlPullParserException, IOException {
        assert (parser.getEventType() == 2);
        if (parser.isEmptyElementTag()) {
            return "";
        }
        parser.next();
        return PacketParserUtils.parseContentDepth(parser, parser.getDepth(), false);
    }

    public static CharSequence parseContentDepth(XmlPullParser parser, int depth) throws XmlPullParserException, IOException {
        return PacketParserUtils.parseContentDepth(parser, depth, false);
    }

    public static CharSequence parseContentDepth(XmlPullParser parser, int depth, boolean fullNamespaces) throws XmlPullParserException, IOException {
        if (parser.getFeature(FEATURE_XML_ROUNDTRIP)) {
            return PacketParserUtils.parseContentDepthWithRoundtrip(parser, depth, fullNamespaces);
        }
        return PacketParserUtils.parseContentDepthWithoutRoundtrip(parser, depth, fullNamespaces);
    }

    private static CharSequence parseContentDepthWithoutRoundtrip(XmlPullParser parser, int depth, boolean fullNamespaces) throws XmlPullParserException, IOException {
        XmlStringBuilder xml = new XmlStringBuilder();
        int event = parser.getEventType();
        boolean isEmptyElement = false;
        String namespaceElement = null;
        while (true) {
            if (event == 2) {
                String namespace;
                xml.halfOpenElement(parser.getName());
                if ((namespaceElement == null || fullNamespaces) && StringUtils.isNotEmpty(namespace = parser.getNamespace())) {
                    xml.attribute("xmlns", namespace);
                    namespaceElement = parser.getName();
                }
                for (int i = 0; i < parser.getAttributeCount(); ++i) {
                    xml.attribute(parser.getAttributeName(i), parser.getAttributeValue(i));
                }
                if (parser.isEmptyElementTag()) {
                    xml.closeEmptyElement();
                    isEmptyElement = true;
                } else {
                    xml.rightAngleBracket();
                }
            } else if (event == 3) {
                if (isEmptyElement) {
                    isEmptyElement = false;
                } else {
                    xml.closeElement(parser.getName());
                }
                if (namespaceElement != null && namespaceElement.equals(parser.getName())) {
                    namespaceElement = null;
                }
                if (parser.getDepth() <= depth) {
                    break;
                }
            } else if (event == 4) {
                xml.append(parser.getText());
            }
            event = parser.next();
        }
        return xml;
    }

    private static CharSequence parseContentDepthWithRoundtrip(XmlPullParser parser, int depth, boolean fullNamespaces) throws XmlPullParserException, IOException {
        StringBuilder sb = new StringBuilder();
        int event = parser.getEventType();
        while (true) {
            if (event != 2 || !parser.isEmptyElementTag()) {
                sb.append(parser.getText());
            }
            if (event == 3 && parser.getDepth() <= depth) break;
            event = parser.next();
        }
        return sb;
    }

    public static Presence parsePresence(XmlPullParser parser) throws XmlPullParserException, IOException, SmackException {
        ParserUtils.assertAtStartTag(parser);
        int initialDepth = parser.getDepth();
        Presence.Type type = Presence.Type.available;
        String typeString = parser.getAttributeValue("", "type");
        if (typeString != null && !typeString.equals("")) {
            type = Presence.Type.fromString(typeString);
        }
        Presence presence = new Presence(type);
        presence.setTo(parser.getAttributeValue("", "to"));
        presence.setFrom(parser.getAttributeValue("", "from"));
        presence.setPacketID(parser.getAttributeValue("", "id"));
        String language = PacketParserUtils.getLanguageAttribute(parser);
        if (language != null && !"".equals(language.trim())) {
            presence.setLanguage(language);
        }
        block18: while (true) {
            int eventType = parser.next();
            switch (eventType) {
                case 2: {
                    String elementName = parser.getName();
                    String namespace = parser.getNamespace();
                    switch (elementName) {
                        case "status": {
                            presence.setStatus(parser.nextText());
                            break;
                        }
                        case "priority": {
                            int priority = Integer.parseInt(parser.nextText());
                            presence.setPriority(priority);
                            break;
                        }
                        case "show": {
                            String modeText = parser.nextText();
                            if (StringUtils.isNotEmpty(modeText)) {
                                presence.setMode(Presence.Mode.fromString(modeText));
                                break;
                            }
                            LOGGER.warning("Empty or null mode text in presence show element form " + presence.getFrom() + " with id '" + presence.getPacketID() + "' which is invalid according to RFC6121 4.7.2.1");
                            break;
                        }
                        case "error": {
                            presence.setError(PacketParserUtils.parseError(parser));
                            break;
                        }
                        default: {
                            try {
                                PacketParserUtils.addPacketExtension(presence, parser, elementName, namespace);
                                break;
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.WARNING, "Failed to parse extension packet in Presence packet.", e);
                            }
                        }
                    }
                }
                case 3: {
                    if (parser.getDepth() == initialDepth) break block18;
                }
                default: {
                    continue block18;
                }
            }
            break;
        }
        return presence;
    }

    public static IQ parse(XmlPullParser parser, XMPPConnection connection) throws Exception {
        Packet iqPacket = null;
        XMPPError error = null;
        String id = parser.getAttributeValue("", "id");
        String to = parser.getAttributeValue("", "to");
        String from = parser.getAttributeValue("", "from");
        IQ.Type type = IQ.Type.fromString(parser.getAttributeValue("", "type"));
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if (elementName.equals("error")) {
                    error = PacketParserUtils.parseError(parser);
                    continue;
                }
                if (elementName.equals("query") && namespace.equals("jabber:iq:roster")) {
                    iqPacket = PacketParserUtils.parseRoster(parser);
                    continue;
                }
                if (elementName.equals("bind") && namespace.equals("urn:ietf:params:xml:ns:xmpp-bind")) {
                    iqPacket = PacketParserUtils.parseResourceBinding(parser);
                    continue;
                }
                IQProvider<IQ> provider = ProviderManager.getIQProvider(elementName, namespace);
                if (provider != null) {
                    iqPacket = (IQ)provider.parse(parser);
                    continue;
                }
                Class<?> introspectionProvider = ProviderManager.getIQIntrospectionProvider(elementName, namespace);
                if (introspectionProvider != null) {
                    iqPacket = (IQ)PacketParserUtils.parseWithIntrospection(elementName, introspectionProvider, parser);
                    continue;
                }
                if (IQ.Type.result != type) continue;
                iqPacket = new UnparsedResultIQ(PacketParserUtils.parseContent(parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("iq")) continue;
            done = true;
        }
        if (iqPacket == null) {
            if (connection != null && (IQ.Type.get == type || IQ.Type.set == type)) {
                iqPacket = new IQ(){

                    @Override
                    public String getChildElementXML() {
                        return null;
                    }
                };
                iqPacket.setPacketID(id);
                iqPacket.setTo(from);
                iqPacket.setFrom(to);
                ((IQ)iqPacket).setType(IQ.Type.error);
                iqPacket.setError(new XMPPError(XMPPError.Condition.feature_not_implemented));
                connection.sendPacket(iqPacket);
                return null;
            }
            iqPacket = new IQ(){

                @Override
                public String getChildElementXML() {
                    return null;
                }
            };
        }
        iqPacket.setPacketID(id);
        iqPacket.setTo(to);
        iqPacket.setFrom(from);
        ((IQ)iqPacket).setType(type);
        iqPacket.setError(error);
        return iqPacket;
    }

    public static RosterPacket parseRoster(XmlPullParser parser) throws XmlPullParserException, IOException {
        RosterPacket roster = new RosterPacket();
        boolean done = false;
        RosterPacket.Item item = null;
        String version = parser.getAttributeValue("", "ver");
        roster.setVersion(version);
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String groupName;
                if (parser.getName().equals("item")) {
                    String jid = parser.getAttributeValue("", "jid");
                    String name = parser.getAttributeValue("", "name");
                    item = new RosterPacket.Item(jid, name);
                    String ask = parser.getAttributeValue("", "ask");
                    RosterPacket.ItemStatus status = RosterPacket.ItemStatus.fromString(ask);
                    item.setItemStatus(status);
                    String subscription = parser.getAttributeValue("", "subscription");
                    RosterPacket.ItemType type = RosterPacket.ItemType.valueOf(subscription != null ? subscription : "none");
                    item.setItemType(type);
                    continue;
                }
                if (!parser.getName().equals("group") || item == null || (groupName = parser.nextText()) == null || groupName.trim().length() <= 0) continue;
                item.addGroupName(groupName);
                continue;
            }
            if (eventType != 3) continue;
            if (parser.getName().equals("item")) {
                roster.addRosterItem(item);
            }
            if (!parser.getName().equals("query")) continue;
            done = true;
        }
        return roster;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bind parseResourceBinding(XmlPullParser parser) throws IOException, XmlPullParserException {
        assert (parser.getEventType() == 2);
        int initalDepth = parser.getDepth();
        Bind bind = null;
        block12: while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "resource": {
                            bind = Bind.newSet(parser.nextText());
                            break block0;
                        }
                        case "jid": {
                            bind = Bind.newResult(parser.nextText());
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    String name = parser.getName();
                    if (name.equals("bind") && parser.getDepth() == initalDepth) break block12;
                }
            }
        }
        assert (parser.getEventType() == 3);
        return bind;
    }

    public static Collection<String> parseMechanisms(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<String> mechanisms = new ArrayList<String>();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String elementName = parser.getName();
                if (!elementName.equals("mechanism")) continue;
                mechanisms.add(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("mechanisms")) continue;
            done = true;
        }
        return mechanisms;
    }

    /*
     * Exception decompiling
     */
    public static Compress.Feature parseCompressionFeature(XmlPullParser parser) throws IOException, XmlPullParserException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CASE]], but top level block is 13[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static SaslStreamElements.SASLFailure parseSASLFailure(XmlPullParser parser) throws Exception {
        String condition = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("failure")) continue;
                condition = parser.getName();
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("failure")) continue;
            done = true;
        }
        return new SaslStreamElements.SASLFailure(condition);
    }

    public static StreamError parseStreamError(XmlPullParser parser) throws IOException, XmlPullParserException {
        int depth = parser.getDepth();
        boolean done = false;
        String code = null;
        String text = null;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String namespace = parser.getNamespace();
                if (!"urn:ietf:params:xml:ns:xmpp-streams".equals(namespace)) continue;
                String name = parser.getName();
                if (name.equals("text") && !parser.isEmptyElementTag()) {
                    parser.next();
                    text = parser.getText();
                    continue;
                }
                code = name;
                continue;
            }
            if (eventType != 3 || depth != parser.getDepth()) continue;
            done = true;
        }
        return new StreamError(code, text);
    }

    public static XMPPError parseError(XmlPullParser parser) throws XmlPullParserException, IOException, SmackException {
        String type = null;
        String message = null;
        String condition = null;
        ArrayList<PacketExtension> extensions = new ArrayList<PacketExtension>();
        type = parser.getAttributeValue("", "type");
        while (true) {
            int eventType;
            if ((eventType = parser.next()) == 2) {
                if (parser.getName().equals("text")) {
                    message = parser.nextText();
                    continue;
                }
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if (namespace.equals("urn:ietf:params:xml:ns:xmpp-stanzas")) {
                    condition = elementName;
                    continue;
                }
                PacketParserUtils.addPacketExtension(extensions, parser, elementName, namespace);
                continue;
            }
            if (eventType == 3 && parser.getName().equals("error")) break;
        }
        XMPPError.Type errorType = XMPPError.Type.CANCEL;
        try {
            if (type != null) {
                errorType = XMPPError.Type.valueOf(type.toUpperCase(Locale.US));
            }
        }
        catch (IllegalArgumentException iae) {
            LOGGER.log(Level.SEVERE, "Could not find error type for " + type.toUpperCase(Locale.US), iae);
        }
        return new XMPPError(errorType, condition, message, extensions);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PacketExtension parsePacketExtension(String elementName, String namespace, XmlPullParser parser) throws XmlPullParserException, IOException, SmackException {
        ParserUtils.assertAtStartTag(parser);
        PacketExtensionProvider<PacketExtension> provider = ProviderManager.getExtensionProvider(elementName, namespace);
        if (provider != null) {
            return (PacketExtension)provider.parse(parser);
        }
        Class<?> introspectionProvider = ProviderManager.getExtensionIntrospectionProvider(elementName, namespace);
        if (introspectionProvider != null) {
            try {
                return (PacketExtension)PacketParserUtils.parseWithIntrospection(elementName, introspectionProvider, parser);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new SmackException(e);
            }
        }
        int initialDepth = parser.getDepth();
        DefaultPacketExtension extension = new DefaultPacketExtension(elementName, namespace);
        while (true) {
            int eventType = parser.next();
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if (parser.isEmptyElementTag()) {
                        extension.setValue(name, "");
                        break;
                    }
                    eventType = parser.next();
                    if (eventType != 4) break;
                    String value = parser.getText();
                    extension.setValue(name, value);
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return extension;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static StartTls parseStartTlsFeature(XmlPullParser parser) throws XmlPullParserException, IOException {
        assert (parser.getEventType() == 2);
        assert (parser.getNamespace().equals("urn:ietf:params:xml:ns:xmpp-tls"));
        int initalDepth = parser.getDepth();
        boolean required = false;
        block10: while (true) {
            int event = parser.next();
            block0 : switch (event) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "required": {
                            required = true;
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() == initalDepth) break block10;
                }
            }
        }
        assert (parser.getEventType() == 3);
        return new StartTls(required);
    }

    private static String getLanguageAttribute(XmlPullParser parser) {
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attributeName = parser.getAttributeName(i);
            if (!"xml:lang".equals(attributeName) && (!"lang".equals(attributeName) || !"xml".equals(parser.getAttributePrefix(i)))) continue;
            return parser.getAttributeValue(i);
        }
        return null;
    }

    public static Object parseWithIntrospection(String elementName, Class<?> objectClass, XmlPullParser parser) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, XmlPullParserException, IOException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException {
        boolean done = false;
        Object object = objectClass.newInstance();
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String name = parser.getName();
                String stringValue = parser.nextText();
                Class<?> propertyType = object.getClass().getMethod("get" + Character.toUpperCase(name.charAt(0)) + name.substring(1), new Class[0]).getReturnType();
                Object value = PacketParserUtils.decode(propertyType, stringValue);
                object.getClass().getMethod("set" + Character.toUpperCase(name.charAt(0)) + name.substring(1), propertyType).invoke(object, value);
                continue;
            }
            if (eventType != 3 || !parser.getName().equals(elementName)) continue;
            done = true;
        }
        return object;
    }

    public static void addPacketExtension(Packet packet, XmlPullParser parser) throws XmlPullParserException, IOException, SmackException {
        ParserUtils.assertAtStartTag(parser);
        PacketParserUtils.addPacketExtension(packet, parser, parser.getName(), parser.getNamespace());
    }

    public static void addPacketExtension(Packet packet, XmlPullParser parser, String elementName, String namespace) throws XmlPullParserException, IOException, SmackException {
        PacketExtension packetExtension = PacketParserUtils.parsePacketExtension(elementName, namespace, parser);
        packet.addExtension(packetExtension);
    }

    public static void addPacketExtension(Collection<PacketExtension> collection, XmlPullParser parser) throws XmlPullParserException, IOException, SmackException {
        PacketParserUtils.addPacketExtension(collection, parser, parser.getName(), parser.getNamespace());
    }

    public static void addPacketExtension(Collection<PacketExtension> collection, XmlPullParser parser, String elementName, String namespace) throws XmlPullParserException, IOException, SmackException {
        PacketExtension packetExtension = PacketParserUtils.parsePacketExtension(elementName, namespace, parser);
        collection.add(packetExtension);
    }

    private static Object decode(Class<?> type, String value) throws ClassNotFoundException {
        if (type.getName().equals("java.lang.String")) {
            return value;
        }
        if (type.getName().equals("boolean")) {
            return Boolean.valueOf(value);
        }
        if (type.getName().equals("int")) {
            return Integer.valueOf(value);
        }
        if (type.getName().equals("long")) {
            return Long.valueOf(value);
        }
        if (type.getName().equals("float")) {
            return Float.valueOf(value);
        }
        if (type.getName().equals("double")) {
            return Double.valueOf(value);
        }
        if (type.getName().equals("java.lang.Class")) {
            return Class.forName(value);
        }
        return null;
    }

    public static class UnparsedResultIQ
    extends IQ {
        private final CharSequence content;

        public UnparsedResultIQ(CharSequence content) {
            this.content = content;
        }

        @Override
        public CharSequence getChildElementXML() {
            return this.content;
        }
    }
}

