/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ChatMessageListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;

public class Chat {
    private ChatManager chatManager;
    private String threadID;
    private String participant;
    private final Set<ChatMessageListener> listeners = new CopyOnWriteArraySet<ChatMessageListener>();

    Chat(ChatManager chatManager, String participant, String threadID) {
        this.chatManager = chatManager;
        this.participant = participant;
        this.threadID = threadID;
    }

    public String getThreadID() {
        return this.threadID;
    }

    public String getParticipant() {
        return this.participant;
    }

    public void sendMessage(String text) throws XMPPException, SmackException.NotConnectedException {
        Message message = new Message(this.participant, Message.Type.chat);
        message.setThread(this.threadID);
        message.setBody(text);
        this.chatManager.sendMessage(this, message);
    }

    public void sendMessage(Message message) throws SmackException.NotConnectedException {
        message.setTo(this.participant);
        message.setType(Message.Type.chat);
        message.setThread(this.threadID);
        this.chatManager.sendMessage(this, message);
    }

    public void addMessageListener(ChatMessageListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeMessageListener(ChatMessageListener listener) {
        this.listeners.remove(listener);
    }

    public void close() {
        this.chatManager.closeChat(this);
        this.listeners.clear();
    }

    public Collection<ChatMessageListener> getListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    public PacketCollector createCollector() {
        return this.chatManager.createPacketCollector(this);
    }

    void deliver(Message message) {
        message.setThread(this.threadID);
        for (ChatMessageListener listener : this.listeners) {
            listener.processMessage(this, message);
        }
    }

    public String toString() {
        return "Chat [(participant=" + this.participant + "), (thread=" + this.threadID + ")]";
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.threadID.hashCode();
        hash = hash * 31 + this.participant.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        return obj instanceof Chat && this.threadID.equals(((Chat)obj).getThreadID()) && this.participant.equals(((Chat)obj).getParticipant());
    }
}

