/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.ExceptionCallback;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterGroup;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.rosterstore.RosterStore;
import org.jxmpp.util.XmppStringUtils;

public class Roster {
    private static final Logger LOGGER = Logger.getLogger(Roster.class.getName());
    private static final PacketFilter ROSTER_PUSH_FILTER = new AndFilter(new PacketTypeFilter(RosterPacket.class), IQTypeFilter.SET);
    private static final PacketFilter PRESENCE_PACKET_FILTER = new PacketTypeFilter(Presence.class);
    private static SubscriptionMode defaultSubscriptionMode = SubscriptionMode.accept_all;
    private final XMPPConnection connection;
    private final RosterStore rosterStore;
    private final Map<String, RosterGroup> groups = new ConcurrentHashMap<String, RosterGroup>();
    private final Map<String, RosterEntry> entries = new ConcurrentHashMap<String, RosterEntry>();
    private final List<RosterEntry> unfiledEntries = new CopyOnWriteArrayList<RosterEntry>();
    private final List<RosterListener> rosterListeners = new CopyOnWriteArrayList<RosterListener>();
    private final Map<String, Map<String, Presence>> presenceMap = new ConcurrentHashMap<String, Map<String, Presence>>();
    boolean rosterInitialized = false;
    private final PresencePacketListener presencePacketListener = new PresencePacketListener();
    private SubscriptionMode subscriptionMode = Roster.getDefaultSubscriptionMode();

    public static SubscriptionMode getDefaultSubscriptionMode() {
        return defaultSubscriptionMode;
    }

    public static void setDefaultSubscriptionMode(SubscriptionMode subscriptionMode) {
        defaultSubscriptionMode = subscriptionMode;
    }

    Roster(XMPPConnection connection) {
        this.connection = connection;
        this.rosterStore = connection.getRosterStore();
        connection.addPacketListener(new RosterPushListener(), ROSTER_PUSH_FILTER);
        connection.addPacketListener(this.presencePacketListener, PRESENCE_PACKET_FILTER);
        connection.addConnectionListener(new AbstractConnectionListener(){

            @Override
            public void authenticated(XMPPConnection connection) {
                if (connection.isAnonymous()) {
                    return;
                }
                if (!connection.isRosterLoadedAtLogin()) {
                    return;
                }
                try {
                    Roster.this.reload();
                }
                catch (SmackException e) {
                    LOGGER.log(Level.SEVERE, "Could not reload Roster", e);
                    return;
                }
            }

            @Override
            public void connectionClosed() {
                try {
                    Roster.this.setOfflinePresences();
                }
                catch (SmackException.NotConnectedException e) {
                    LOGGER.log(Level.SEVERE, "Not connected exception", e);
                }
            }

            @Override
            public void connectionClosedOnError(Exception e) {
                try {
                    Roster.this.setOfflinePresences();
                }
                catch (SmackException.NotConnectedException e1) {
                    LOGGER.log(Level.SEVERE, "Not connected exception", e);
                }
            }
        });
        if (connection.isAuthenticated()) {
            try {
                this.reload();
            }
            catch (SmackException e) {
                LOGGER.log(Level.SEVERE, "Could not reload Roster", e);
            }
        }
    }

    public SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public void setSubscriptionMode(SubscriptionMode subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
    }

    public void reload() throws SmackException.NotLoggedInException, SmackException.NotConnectedException {
        if (!this.connection.isAuthenticated()) {
            throw new SmackException.NotLoggedInException();
        }
        if (this.connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        RosterPacket packet = new RosterPacket();
        if (this.rosterStore != null && this.isRosterVersioningSupported()) {
            packet.setVersion(this.rosterStore.getRosterVersion());
        }
        this.connection.sendIqWithResponseCallback(packet, new RosterResultListener(), new ExceptionCallback(){

            @Override
            public void processException(Exception exception) {
                LOGGER.log(Level.SEVERE, "Exception reloading roster", exception);
            }
        });
    }

    public void addRosterListener(RosterListener rosterListener) {
        if (!this.rosterListeners.contains(rosterListener)) {
            this.rosterListeners.add(rosterListener);
        }
    }

    public void removeRosterListener(RosterListener rosterListener) {
        this.rosterListeners.remove(rosterListener);
    }

    public RosterGroup createGroup(String name) {
        if (this.connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        if (this.groups.containsKey(name)) {
            return this.groups.get(name);
        }
        RosterGroup group = new RosterGroup(name, this.connection);
        this.groups.put(name, group);
        return group;
    }

    public void createEntry(String user, String name, String[] groups) throws SmackException.NotLoggedInException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (!this.connection.isAuthenticated()) {
            throw new SmackException.NotLoggedInException();
        }
        if (this.connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        RosterPacket rosterPacket = new RosterPacket();
        rosterPacket.setType(IQ.Type.set);
        RosterPacket.Item item = new RosterPacket.Item(user, name);
        if (groups != null) {
            for (String group : groups) {
                if (group == null || group.trim().length() <= 0) continue;
                item.addGroupName(group);
            }
        }
        rosterPacket.addRosterItem(item);
        this.connection.createPacketCollectorAndSend(rosterPacket).nextResultOrThrow();
        Presence presencePacket = new Presence(Presence.Type.subscribe);
        presencePacket.setTo(user);
        this.connection.sendPacket(presencePacket);
    }

    public void removeEntry(RosterEntry entry) throws SmackException.NotLoggedInException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (!this.connection.isAuthenticated()) {
            throw new SmackException.NotLoggedInException();
        }
        if (this.connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        if (!this.entries.containsKey(entry.getUser())) {
            return;
        }
        RosterPacket packet = new RosterPacket();
        packet.setType(IQ.Type.set);
        RosterPacket.Item item = RosterEntry.toRosterItem(entry);
        item.setItemType(RosterPacket.ItemType.remove);
        packet.addRosterItem(item);
        this.connection.createPacketCollectorAndSend(packet).nextResultOrThrow();
    }

    public int getEntryCount() {
        return this.getEntries().size();
    }

    public Collection<RosterEntry> getEntries() {
        HashSet<RosterEntry> allEntries = new HashSet<RosterEntry>();
        for (RosterGroup rosterGroup : this.getGroups()) {
            allEntries.addAll(rosterGroup.getEntries());
        }
        allEntries.addAll(this.unfiledEntries);
        return Collections.unmodifiableCollection(allEntries);
    }

    public int getUnfiledEntryCount() {
        return this.unfiledEntries.size();
    }

    public Collection<RosterEntry> getUnfiledEntries() {
        return Collections.unmodifiableList(this.unfiledEntries);
    }

    public RosterEntry getEntry(String user) {
        if (user == null) {
            return null;
        }
        return this.entries.get(user.toLowerCase(Locale.US));
    }

    public boolean contains(String user) {
        return this.getEntry(user) != null;
    }

    public RosterGroup getGroup(String name) {
        return this.groups.get(name);
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public Collection<RosterGroup> getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    public Presence getPresence(String user) {
        String key = this.getPresenceMapKey(XmppStringUtils.parseBareJid((String)user));
        Map<String, Presence> userPresences = this.presenceMap.get(key);
        if (userPresences == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(user);
            return presence;
        }
        Presence presence = null;
        for (String resource : userPresences.keySet()) {
            Presence.Mode presenceMode;
            Presence p = userPresences.get(resource);
            if (!p.isAvailable()) continue;
            if (presence == null || p.getPriority() > presence.getPriority()) {
                presence = p;
                continue;
            }
            if (p.getPriority() != presence.getPriority()) continue;
            Presence.Mode pMode = p.getMode();
            if (pMode == null) {
                pMode = Presence.Mode.available;
            }
            if ((presenceMode = presence.getMode()) == null) {
                presenceMode = Presence.Mode.available;
            }
            if (pMode.compareTo(presenceMode) >= 0) continue;
            presence = p;
        }
        if (presence == null) {
            presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(user);
            return presence;
        }
        return presence;
    }

    public Presence getPresenceResource(String userWithResource) {
        String key = this.getPresenceMapKey(userWithResource);
        String resource = XmppStringUtils.parseResource((String)userWithResource);
        Map<String, Presence> userPresences = this.presenceMap.get(key);
        if (userPresences == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(userWithResource);
            return presence;
        }
        Presence presence = userPresences.get(resource);
        if (presence == null) {
            presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(userWithResource);
            return presence;
        }
        return presence;
    }

    public List<Presence> getPresences(String user) {
        List<Presence> res;
        String key = this.getPresenceMapKey(user);
        Map<String, Presence> userPresences = this.presenceMap.get(key);
        if (userPresences == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(user);
            res = Arrays.asList(presence);
        } else {
            ArrayList<Presence> answer = new ArrayList<Presence>();
            for (Presence presence : userPresences.values()) {
                if (!presence.isAvailable()) continue;
                answer.add(presence);
            }
            if (!answer.isEmpty()) {
                res = answer;
            } else {
                Presence presence = new Presence(Presence.Type.unavailable);
                presence.setFrom(user);
                res = Arrays.asList(presence);
            }
        }
        return Collections.unmodifiableList(res);
    }

    private String getPresenceMapKey(String user) {
        if (user == null) {
            return null;
        }
        String key = user;
        if (!this.contains(user)) {
            key = XmppStringUtils.parseBareJid((String)user);
        }
        return key.toLowerCase(Locale.US);
    }

    private void setOfflinePresences() throws SmackException.NotConnectedException {
        for (String user : this.presenceMap.keySet()) {
            Map<String, Presence> resources = this.presenceMap.get(user);
            if (resources == null) continue;
            for (String resource : resources.keySet()) {
                Presence packetUnavailable = new Presence(Presence.Type.unavailable);
                packetUnavailable.setFrom(user + "/" + resource);
                this.presencePacketListener.processPacket(packetUnavailable);
            }
        }
    }

    private void fireRosterChangedEvent(Collection<String> addedEntries, Collection<String> updatedEntries, Collection<String> deletedEntries) {
        for (RosterListener listener : this.rosterListeners) {
            if (!addedEntries.isEmpty()) {
                listener.entriesAdded(addedEntries);
            }
            if (!updatedEntries.isEmpty()) {
                listener.entriesUpdated(updatedEntries);
            }
            if (deletedEntries.isEmpty()) continue;
            listener.entriesDeleted(deletedEntries);
        }
    }

    private void fireRosterPresenceEvent(Presence presence) {
        for (RosterListener listener : this.rosterListeners) {
            listener.presenceChanged(presence);
        }
    }

    private void addUpdateEntry(Collection<String> addedEntries, Collection<String> updatedEntries, Collection<String> unchangedEntries, RosterPacket.Item item, RosterEntry entry) {
        RosterEntry oldEntry = this.entries.put(item.getUser(), entry);
        if (oldEntry == null) {
            addedEntries.add(item.getUser());
        } else {
            RosterPacket.Item oldItem = RosterEntry.toRosterItem(oldEntry);
            if (!oldEntry.equalsDeep(entry) || !item.getGroupNames().equals(oldItem.getGroupNames())) {
                updatedEntries.add(item.getUser());
            } else {
                unchangedEntries.add(item.getUser());
            }
        }
        if (item.getGroupNames().isEmpty()) {
            this.unfiledEntries.remove(entry);
            this.unfiledEntries.add(entry);
        } else {
            this.unfiledEntries.remove(entry);
        }
        ArrayList<String> newGroupNames = new ArrayList<String>();
        for (String groupName : item.getGroupNames()) {
            newGroupNames.add(groupName);
            RosterGroup group = this.getGroup(groupName);
            if (group == null) {
                group = this.createGroup(groupName);
                this.groups.put(groupName, group);
            }
            group.addEntryLocal(entry);
        }
        ArrayList<String> oldGroupNames = new ArrayList<String>();
        for (RosterGroup group : this.getGroups()) {
            oldGroupNames.add(group.getName());
        }
        oldGroupNames.removeAll(newGroupNames);
        for (String groupName : oldGroupNames) {
            RosterGroup group = this.getGroup(groupName);
            group.removeEntryLocal(entry);
            if (group.getEntryCount() != 0) continue;
            this.groups.remove(groupName);
        }
    }

    private void deleteEntry(Collection<String> deletedEntries, RosterEntry entry) {
        String user = entry.getUser();
        this.entries.remove(user);
        this.unfiledEntries.remove(entry);
        this.presenceMap.remove(XmppStringUtils.parseBareJid((String)user));
        deletedEntries.add(user);
        for (Map.Entry<String, RosterGroup> e : this.groups.entrySet()) {
            RosterGroup group = e.getValue();
            group.removeEntryLocal(entry);
            if (group.getEntryCount() != 0) continue;
            this.groups.remove(e.getKey());
        }
    }

    private void removeEmptyGroups() {
        for (RosterGroup group : this.getGroups()) {
            if (group.getEntryCount() != 0) continue;
            this.groups.remove(group.getName());
        }
    }

    private static boolean hasValidSubscriptionType(RosterPacket.Item item) {
        return item.getItemType().equals((Object)RosterPacket.ItemType.none) || item.getItemType().equals((Object)RosterPacket.ItemType.from) || item.getItemType().equals((Object)RosterPacket.ItemType.to) || item.getItemType().equals((Object)RosterPacket.ItemType.both);
    }

    private boolean isRosterVersioningSupported() {
        return this.connection.hasFeature("ver", "urn:xmpp:features:rosterver");
    }

    private class RosterPushListener
    implements PacketListener {
        private RosterPushListener() {
        }

        @Override
        public void processPacket(Packet packet) throws SmackException.NotConnectedException {
            RosterPacket rosterPacket = (RosterPacket)packet;
            String version = rosterPacket.getVersion();
            String jid = XmppStringUtils.parseBareJid((String)Roster.this.connection.getUser());
            if (rosterPacket.getFrom() != null && !rosterPacket.getFrom().equals(jid)) {
                LOGGER.warning("Ignoring roster push with a non matching 'from' ourJid=" + jid + " from=" + rosterPacket.getFrom());
                return;
            }
            Collection<RosterPacket.Item> items = rosterPacket.getRosterItems();
            if (items.size() != 1) {
                LOGGER.warning("Ignoring roster push with not exaclty one entry. size=" + items.size());
                return;
            }
            ArrayList addedEntries = new ArrayList();
            ArrayList updatedEntries = new ArrayList();
            ArrayList deletedEntries = new ArrayList();
            ArrayList unchangedEntries = new ArrayList();
            RosterPacket.Item item = items.iterator().next();
            RosterEntry entry = new RosterEntry(item.getUser(), item.getName(), item.getItemType(), item.getItemStatus(), Roster.this, Roster.this.connection);
            if (item.getItemType().equals((Object)RosterPacket.ItemType.remove)) {
                Roster.this.deleteEntry(deletedEntries, entry);
                if (Roster.this.rosterStore != null) {
                    Roster.this.rosterStore.removeEntry(entry.getUser(), version);
                }
            } else if (Roster.hasValidSubscriptionType(item)) {
                Roster.this.addUpdateEntry(addedEntries, updatedEntries, unchangedEntries, item, entry);
                if (Roster.this.rosterStore != null) {
                    Roster.this.rosterStore.addEntry(item, version);
                }
            }
            Roster.this.connection.sendPacket(IQ.createResultIQ(rosterPacket));
            Roster.this.removeEmptyGroups();
            Roster.this.fireRosterChangedEvent(addedEntries, updatedEntries, deletedEntries);
        }
    }

    private class RosterResultListener
    implements PacketListener {
        private RosterResultListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processPacket(Packet packet) {
            LOGGER.fine("RosterResultListener received stanza");
            ArrayList addedEntries = new ArrayList();
            ArrayList updatedEntries = new ArrayList();
            ArrayList deletedEntries = new ArrayList();
            ArrayList unchangedEntries = new ArrayList();
            if (packet instanceof RosterPacket) {
                RosterPacket rosterPacket = (RosterPacket)packet;
                String version = rosterPacket.getVersion();
                ArrayList<RosterPacket.Item> validItems = new ArrayList<RosterPacket.Item>();
                for (RosterPacket.Item item : rosterPacket.getRosterItems()) {
                    if (!Roster.hasValidSubscriptionType(item)) continue;
                    validItems.add(item);
                }
                for (RosterPacket.Item item : validItems) {
                    RosterEntry entry = new RosterEntry(item.getUser(), item.getName(), item.getItemType(), item.getItemStatus(), Roster.this, Roster.this.connection);
                    Roster.this.addUpdateEntry(addedEntries, updatedEntries, unchangedEntries, item, entry);
                }
                HashSet<String> toDelete = new HashSet<String>();
                for (RosterEntry entry : Roster.this.entries.values()) {
                    toDelete.add(entry.getUser());
                }
                toDelete.removeAll(addedEntries);
                toDelete.removeAll(updatedEntries);
                toDelete.removeAll(unchangedEntries);
                for (String user : toDelete) {
                    Roster.this.deleteEntry(deletedEntries, (RosterEntry)Roster.this.entries.get(user));
                }
                if (Roster.this.rosterStore != null) {
                    Roster.this.rosterStore.resetEntries(validItems, version);
                }
                Roster.this.removeEmptyGroups();
            } else {
                for (RosterPacket.Item item : Roster.this.rosterStore.getEntries()) {
                    RosterEntry entry = new RosterEntry(item.getUser(), item.getName(), item.getItemType(), item.getItemStatus(), Roster.this, Roster.this.connection);
                    Roster.this.addUpdateEntry(addedEntries, updatedEntries, unchangedEntries, item, entry);
                }
            }
            Roster.this.rosterInitialized = true;
            Roster roster = Roster.this;
            synchronized (roster) {
                Roster.this.notifyAll();
            }
            Roster.this.fireRosterChangedEvent(addedEntries, updatedEntries, deletedEntries);
        }
    }

    private class PresencePacketListener
    implements PacketListener {
        private PresencePacketListener() {
        }

        @Override
        public void processPacket(Packet packet) throws SmackException.NotConnectedException {
            Presence presence = (Presence)packet;
            String from = presence.getFrom();
            String key = Roster.this.getPresenceMapKey(from);
            if (presence.getType() == Presence.Type.available) {
                Map<String, Presence> userPresences;
                if (Roster.this.presenceMap.get(key) == null) {
                    userPresences = new ConcurrentHashMap();
                    Roster.this.presenceMap.put(key, userPresences);
                } else {
                    userPresences = (Map)Roster.this.presenceMap.get(key);
                }
                userPresences.remove("");
                userPresences.put(XmppStringUtils.parseResource((String)from), presence);
                RosterEntry entry = (RosterEntry)Roster.this.entries.get(key);
                if (entry != null) {
                    Roster.this.fireRosterPresenceEvent(presence);
                }
            } else if (presence.getType() == Presence.Type.unavailable) {
                Map<String, Presence> userPresences;
                if ("".equals(XmppStringUtils.parseResource((String)from))) {
                    if (Roster.this.presenceMap.get(key) == null) {
                        userPresences = new ConcurrentHashMap();
                        Roster.this.presenceMap.put(key, userPresences);
                    } else {
                        userPresences = (Map)Roster.this.presenceMap.get(key);
                    }
                    userPresences.put("", presence);
                } else if (Roster.this.presenceMap.get(key) != null) {
                    userPresences = (Map)Roster.this.presenceMap.get(key);
                    userPresences.put(XmppStringUtils.parseResource((String)from), presence);
                }
                RosterEntry entry = (RosterEntry)Roster.this.entries.get(key);
                if (entry != null) {
                    Roster.this.fireRosterPresenceEvent(presence);
                }
            } else if (presence.getType() == Presence.Type.subscribe) {
                Presence response = null;
                switch (Roster.this.subscriptionMode) {
                    case accept_all: {
                        response = new Presence(Presence.Type.subscribed);
                        break;
                    }
                    case reject_all: {
                        response = new Presence(Presence.Type.unsubscribed);
                        break;
                    }
                }
                if (response != null) {
                    response.setTo(presence.getFrom());
                    Roster.this.connection.sendPacket(response);
                }
            } else if (presence.getType() == Presence.Type.unsubscribe) {
                if (Roster.this.subscriptionMode != SubscriptionMode.manual) {
                    Presence response = new Presence(Presence.Type.unsubscribed);
                    response.setTo(presence.getFrom());
                    Roster.this.connection.sendPacket(response);
                }
            } else if (presence.getType() == Presence.Type.error && "".equals(XmppStringUtils.parseResource((String)from))) {
                Map<String, Presence> userPresences;
                if (!Roster.this.presenceMap.containsKey(key)) {
                    userPresences = new ConcurrentHashMap();
                    Roster.this.presenceMap.put(key, userPresences);
                } else {
                    userPresences = (Map)Roster.this.presenceMap.get(key);
                    userPresences.clear();
                }
                userPresences.put("", presence);
                RosterEntry entry = (RosterEntry)Roster.this.entries.get(key);
                if (entry != null) {
                    Roster.this.fireRosterPresenceEvent(presence);
                }
            }
        }
    }

    public static enum SubscriptionMode {
        accept_all,
        reject_all,
        manual;

    }
}

