/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.PacketUtil;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jxmpp.util.XmppStringUtils;

public abstract class Packet
extends TopLevelStreamElement {
    public static final String TEXT = "text";
    public static final String ITEM = "item";
    protected static final String DEFAULT_LANGUAGE = Locale.getDefault().getLanguage().toLowerCase(Locale.US);
    private static final String prefix = StringUtils.randomString(5) + "-";
    private static final AtomicLong id = new AtomicLong();
    private final Map<String, PacketExtension> packetExtensions = new HashMap<String, PacketExtension>(12);
    private String packetID = null;
    private String to = null;
    private String from = null;
    private XMPPError error = null;
    protected String language;

    public Packet() {
        this(prefix + Long.toString(id.incrementAndGet()));
    }

    public Packet(String packetID) {
        this.setPacketID(packetID);
    }

    public Packet(Packet p) {
        this.packetID = p.getPacketID();
        this.to = p.getTo();
        this.from = p.getFrom();
        this.error = p.error;
        for (PacketExtension pe : p.getExtensions()) {
            this.addExtension(pe);
        }
    }

    public String getPacketID() {
        return this.packetID;
    }

    public void setPacketID(String packetID) {
        this.packetID = packetID;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public XMPPError getError() {
        return this.error;
    }

    public void setError(XMPPError error) {
        this.error = error;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PacketExtension> getExtensions() {
        Map<String, PacketExtension> map = this.packetExtensions;
        synchronized (map) {
            if (this.packetExtensions.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<PacketExtension>(this.packetExtensions.values());
        }
    }

    public PacketExtension getExtension(String namespace) {
        return PacketUtil.packetExtensionfromCollection(this.getExtensions(), null, namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <PE extends PacketExtension> PE getExtension(String elementName, String namespace) {
        PacketExtension packetExtension;
        if (namespace == null) {
            return null;
        }
        String key = XmppStringUtils.generateKey((String)elementName, (String)namespace);
        Map<String, PacketExtension> map = this.packetExtensions;
        synchronized (map) {
            packetExtension = this.packetExtensions.get(key);
        }
        if (packetExtension == null) {
            return null;
        }
        return (PE)packetExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtension(PacketExtension extension) {
        if (extension == null) {
            return;
        }
        String key = XmppStringUtils.generateKey((String)extension.getElementName(), (String)extension.getNamespace());
        Map<String, PacketExtension> map = this.packetExtensions;
        synchronized (map) {
            this.packetExtensions.put(key, extension);
        }
    }

    public void addExtensions(Collection<PacketExtension> extensions) {
        if (extensions == null) {
            return;
        }
        for (PacketExtension packetExtension : extensions) {
            this.addExtension(packetExtension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasExtension(String elementName, String namespace) {
        if (elementName == null) {
            return this.hasExtension(namespace);
        }
        String key = XmppStringUtils.generateKey((String)elementName, (String)namespace);
        Map<String, PacketExtension> map = this.packetExtensions;
        synchronized (map) {
            return this.packetExtensions.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasExtension(String namespace) {
        Map<String, PacketExtension> map = this.packetExtensions;
        synchronized (map) {
            for (PacketExtension packetExtension : this.packetExtensions.values()) {
                if (!packetExtension.getNamespace().equals(namespace)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketExtension removeExtension(String elementName, String namespace) {
        String key = XmppStringUtils.generateKey((String)elementName, (String)namespace);
        Map<String, PacketExtension> map = this.packetExtensions;
        synchronized (map) {
            return this.packetExtensions.remove(key);
        }
    }

    public PacketExtension removeExtension(PacketExtension extension) {
        return this.removeExtension(extension.getElementName(), extension.getNamespace());
    }

    protected synchronized CharSequence getExtensionsXML() {
        XmlStringBuilder xml = new XmlStringBuilder();
        for (PacketExtension extension : this.getExtensions()) {
            xml.append(extension.toXML());
        }
        return xml;
    }

    public static String getDefaultLanguage() {
        return DEFAULT_LANGUAGE;
    }

    public String toString() {
        return this.toXML().toString();
    }

    protected void addCommonAttributes(XmlStringBuilder xml) {
        xml.optAttribute("id", this.getPacketID());
        xml.optAttribute("to", this.getTo());
        xml.optAttribute("from", this.getFrom());
        xml.xmllangAttribute(this.getLanguage());
    }
}

