/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.util.LazyStringBuilder;
import org.jivesoftware.smack.util.StringUtils;

public class XmlStringBuilder
implements Appendable,
CharSequence {
    public static final String RIGHT_ANGLE_BRACKET = Character.toString('>');
    private final LazyStringBuilder sb = new LazyStringBuilder();

    public XmlStringBuilder() {
    }

    public XmlStringBuilder(PacketExtension pe) {
        this();
        this.prelude(pe);
    }

    public XmlStringBuilder(NamedElement e) {
        this();
        this.halfOpenElement(e.getElementName());
    }

    public XmlStringBuilder element(String name, String content) {
        assert (content != null);
        this.openElement(name);
        this.escape(content);
        this.closeElement(name);
        return this;
    }

    public XmlStringBuilder element(String name, Enum<?> content) {
        assert (content != null);
        this.element(name, content.name());
        return this;
    }

    public XmlStringBuilder element(Element element) {
        assert (element != null);
        return this.append(element.toXML());
    }

    public XmlStringBuilder optElement(String name, String content) {
        if (content != null) {
            this.element(name, content);
        }
        return this;
    }

    public XmlStringBuilder optElement(Element element) {
        if (element != null) {
            this.append(element.toXML());
        }
        return this;
    }

    public XmlStringBuilder optElement(String name, Enum<?> content) {
        if (content != null) {
            this.element(name, content);
        }
        return this;
    }

    public XmlStringBuilder optIntElement(String name, int value) {
        if (value >= 0) {
            this.element(name, String.valueOf(value));
        }
        return this;
    }

    public XmlStringBuilder halfOpenElement(String name) {
        this.sb.append('<').append(name);
        return this;
    }

    public XmlStringBuilder halfOpenElement(NamedElement namedElement) {
        return this.halfOpenElement(namedElement.getElementName());
    }

    public XmlStringBuilder openElement(String name) {
        this.halfOpenElement(name).rightAngleBracket();
        return this;
    }

    public XmlStringBuilder closeElement(String name) {
        this.sb.append("</").append(name);
        this.rightAngleBracket();
        return this;
    }

    public XmlStringBuilder closeElement(NamedElement e) {
        this.closeElement(e.getElementName());
        return this;
    }

    public XmlStringBuilder closeEmptyElement() {
        this.sb.append("/>");
        return this;
    }

    public XmlStringBuilder rightAngleBracket() {
        this.sb.append(RIGHT_ANGLE_BRACKET);
        return this;
    }

    @Deprecated
    public XmlStringBuilder rightAngelBracket() {
        return this.rightAngleBracket();
    }

    public XmlStringBuilder attribute(String name, String value) {
        assert (value != null);
        this.sb.append(' ').append(name).append("='");
        this.escape(value);
        this.sb.append('\'');
        return this;
    }

    public XmlStringBuilder attribute(String name, Enum<?> value) {
        assert (value != null);
        this.attribute(name, value.name());
        return this;
    }

    public XmlStringBuilder attribute(String name, int value) {
        assert (name != null);
        return this.attribute(name, String.valueOf(value));
    }

    public XmlStringBuilder optAttribute(String name, String value) {
        if (value != null) {
            this.attribute(name, value);
        }
        return this;
    }

    public XmlStringBuilder optAttribute(String name, Enum<?> value) {
        if (value != null) {
            this.attribute(name, value.name());
        }
        return this;
    }

    public XmlStringBuilder optIntAttribute(String name, int value) {
        if (value >= 0) {
            this.attribute(name, Integer.toString(value));
        }
        return this;
    }

    public XmlStringBuilder optLongAttribute(String name, Long value) {
        if (value >= 0L) {
            this.attribute(name, Long.toString(value));
        }
        return this;
    }

    public XmlStringBuilder optBooleanAttribute(String name, boolean bool) {
        if (bool) {
            this.sb.append(' ').append(name).append("='true'");
        }
        return this;
    }

    public XmlStringBuilder xmlnsAttribute(String value) {
        this.optAttribute("xmlns", value);
        return this;
    }

    public XmlStringBuilder xmllangAttribute(String value) {
        this.optAttribute("xml:lang", value);
        return this;
    }

    public XmlStringBuilder escape(String text) {
        assert (text != null);
        this.sb.append(StringUtils.escapeForXML(text));
        return this;
    }

    public XmlStringBuilder prelude(PacketExtension pe) {
        this.halfOpenElement(pe.getElementName());
        this.xmlnsAttribute(pe.getNamespace());
        return this;
    }

    public XmlStringBuilder optAppend(CharSequence csq) {
        if (csq != null) {
            this.append(csq);
        }
        return this;
    }

    public XmlStringBuilder append(XmlStringBuilder xsb) {
        assert (xsb != null);
        this.sb.append(xsb.sb);
        return this;
    }

    public XmlStringBuilder emptyElement(Enum<?> element) {
        return this.emptyElement(element.name());
    }

    public XmlStringBuilder emptyElement(String element) {
        this.halfOpenElement(element);
        return this.closeEmptyElement();
    }

    public XmlStringBuilder condEmptyElement(boolean condition, String element) {
        if (condition) {
            this.emptyElement(element);
        }
        return this;
    }

    public XmlStringBuilder condAttribute(boolean condition, String name, String value) {
        if (condition) {
            this.attribute(name, value);
        }
        return this;
    }

    @Override
    public XmlStringBuilder append(CharSequence csq) {
        assert (csq != null);
        this.sb.append(csq);
        return this;
    }

    @Override
    public XmlStringBuilder append(CharSequence csq, int start, int end) {
        assert (csq != null);
        this.sb.append(csq, start, end);
        return this;
    }

    @Override
    public XmlStringBuilder append(char c) {
        this.sb.append(c);
        return this;
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.sb.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof CharSequence)) {
            return false;
        }
        CharSequence otherCharSequenceBuilder = (CharSequence)other;
        return this.toString().equals(otherCharSequenceBuilder.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

