/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Date;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PlainStreamElement;
import org.jivesoftware.smack.packet.TopLevelStreamElement;

public class DummyConnection
extends AbstractXMPPConnection {
    private boolean anonymous = false;
    private boolean reconnect = false;
    private String connectionID;
    private Roster roster;
    private final BlockingQueue<TopLevelStreamElement> queue = new LinkedBlockingQueue<TopLevelStreamElement>();

    public static ConnectionConfiguration.ConnectionConfigurationBuilder<?, ?> getDummyConfigurationBuilder() {
        return ((DummyConnectionConfiguration.DummyConnectionConfigurationBuilder)DummyConnectionConfiguration.builder().setServiceName("example.org")).setUsernameAndPassword("dummy", "dummypass");
    }

    public DummyConnection() {
        this(DummyConnection.getDummyConfigurationBuilder().build());
    }

    public DummyConnection(ConnectionConfiguration configuration) {
        super(configuration);
        for (ConnectionCreationListener listener : XMPPConnectionRegistry.getConnectionCreationListeners()) {
            listener.connectionCreated((XMPPConnection)this);
        }
        this.user = this.config.getUsername() + "@" + this.config.getServiceName() + "/" + (this.config.getResource() != null ? this.config.getResource() : "Test");
    }

    protected void connectInternal() {
        this.connected = true;
        this.connectionID = "dummy-" + new Random(new Date().getTime()).nextInt();
        if (this.reconnect) {
            for (ConnectionListener listener : this.getConnectionListeners()) {
                listener.reconnectionSuccessful();
            }
        }
    }

    protected void shutdown() {
        this.user = null;
        this.connectionID = null;
        this.roster = null;
        this.authenticated = false;
        this.anonymous = false;
        for (ConnectionListener listener : this.getConnectionListeners()) {
            listener.connectionClosed();
        }
        this.reconnect = true;
    }

    public String getConnectionID() {
        if (!this.isConnected()) {
            return null;
        }
        if (this.connectionID == null) {
            this.connectionID = "dummy-" + new Random(new Date().getTime()).nextInt();
        }
        return this.connectionID;
    }

    public Roster getRoster() {
        if (this.isAnonymous()) {
            return null;
        }
        if (this.roster == null) {
            this.roster = new Roster((XMPPConnection)this);
        }
        return this.roster;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public boolean isSecureConnection() {
        return false;
    }

    public boolean isUsingCompression() {
        return false;
    }

    protected void loginNonAnonymously() throws XMPPException {
        this.user = this.config.getUsername() + "@" + this.config.getServiceName() + "/" + (this.config.getResource() != null ? this.config.getResource() : "Test");
        this.roster = new Roster((XMPPConnection)this);
        this.anonymous = false;
        this.authenticated = true;
    }

    public void loginAnonymously() throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.isAuthenticated()) {
            throw new IllegalStateException("Already logged in to server.");
        }
        this.anonymous = true;
        this.authenticated = true;
    }

    public void send(PlainStreamElement element) {
        if (SmackConfiguration.DEBUG_ENABLED) {
            System.out.println("[SEND]: " + element.toXML());
        }
        this.queue.add((TopLevelStreamElement)element);
    }

    protected void sendPacketInternal(Packet packet) {
        if (SmackConfiguration.DEBUG_ENABLED) {
            System.out.println("[SEND]: " + packet.toXML());
        }
        this.queue.add((TopLevelStreamElement)packet);
    }

    public int getNumberOfSentPackets() {
        return this.queue.size();
    }

    public <P extends TopLevelStreamElement> P getSentPacket() throws InterruptedException {
        return (P)((TopLevelStreamElement)this.queue.poll());
    }

    public <P extends TopLevelStreamElement> P getSentPacket(int wait) throws InterruptedException {
        return (P)this.queue.poll(wait, TimeUnit.SECONDS);
    }

    public void processPacket(Packet packet) {
        if (SmackConfiguration.DEBUG_ENABLED) {
            System.out.println("[RECV]: " + packet.toXML());
        }
        this.invokePacketCollectorsAndNotifyRecvListeners(packet);
    }

    public static class DummyConnectionConfiguration
    extends ConnectionConfiguration {
        protected DummyConnectionConfiguration(DummyConnectionConfigurationBuilder builder) {
            super((ConnectionConfiguration.ConnectionConfigurationBuilder)builder);
        }

        public static DummyConnectionConfigurationBuilder builder() {
            return new DummyConnectionConfigurationBuilder();
        }

        public static class DummyConnectionConfigurationBuilder
        extends ConnectionConfiguration.ConnectionConfigurationBuilder<DummyConnectionConfigurationBuilder, DummyConnectionConfiguration> {
            private DummyConnectionConfigurationBuilder() {
            }

            public DummyConnectionConfiguration build() {
                return new DummyConnectionConfiguration(this);
            }

            protected DummyConnectionConfigurationBuilder getThis() {
                return this;
            }
        }
    }
}

