/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.TestIQ;
import org.jivesoftware.smack.packet.XMPPError;
import org.junit.Assert;
import org.junit.Test;

public class IQResponseTest {
    private static final String ELEMENT = "child";
    private static final String NAMESPACE = "http://igniterealtime.org/protocol/test";

    @Test
    public void testGeneratingSimpleResponse() {
        TestIQ request = new TestIQ(ELEMENT, NAMESPACE);
        request.setFrom("sender@test/Smack");
        request.setTo("receiver@test/Smack");
        IQ result = IQ.createResultIQ((IQ)request);
        Assert.assertEquals((Object)IQ.Type.result, (Object)result.getType());
        Assert.assertNotNull((Object)result.getPacketID());
        Assert.assertEquals((Object)request.getPacketID(), (Object)result.getPacketID());
        Assert.assertEquals((Object)request.getFrom(), (Object)result.getTo());
        Assert.assertEquals((Object)request.getTo(), (Object)result.getFrom());
        Assert.assertEquals((Object)"", (Object)result.getChildElementXML().toString());
    }

    @Test
    public void testGeneratingValidErrorResponse() {
        XMPPError error = new XMPPError(XMPPError.Condition.bad_request);
        TestIQ request = new TestIQ(ELEMENT, NAMESPACE);
        request.setType(IQ.Type.set);
        request.setFrom("sender@test/Smack");
        request.setTo("receiver@test/Smack");
        IQ result = IQ.createErrorResponse((IQ)request, (XMPPError)error);
        Assert.assertEquals((Object)IQ.Type.error, (Object)result.getType());
        Assert.assertNotNull((Object)result.getPacketID());
        Assert.assertEquals((Object)request.getPacketID(), (Object)result.getPacketID());
        Assert.assertEquals((Object)request.getFrom(), (Object)result.getTo());
        Assert.assertEquals((Object)error, (Object)result.getError());
    }

    @Test
    public void testGeneratingResponseBasedOnResult() {
        TestIQ request = new TestIQ(ELEMENT, NAMESPACE);
        request.setType(IQ.Type.result);
        request.setFrom("sender@test/Smack");
        request.setTo("receiver@test/Smack");
        try {
            IQ.createResultIQ((IQ)request);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Assert.fail((String)"It shouldn't be possible to generate a response for a result IQ!");
    }

    @Test
    public void testGeneratingErrorBasedOnError() {
        XMPPError error = new XMPPError(XMPPError.Condition.bad_request);
        TestIQ request = new TestIQ(ELEMENT, NAMESPACE);
        request.setType(IQ.Type.error);
        request.setFrom("sender@test/Smack");
        request.setTo("receiver@test/Smack");
        request.setError(error);
        try {
            IQ.createErrorResponse((IQ)request, (XMPPError)error);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Assert.fail((String)"It shouldn't be possible to generate a response for a error IQ!");
    }
}

