/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;

public class PacketCollector {
    private static final Logger LOGGER = Logger.getLogger(PacketCollector.class.getName());
    private final PacketFilter packetFilter;
    private final ArrayBlockingQueue<Packet> resultQueue;
    private final XMPPConnection connection;
    private boolean cancelled = false;

    protected PacketCollector(XMPPConnection connection, PacketFilter packetFilter) {
        this(connection, packetFilter, SmackConfiguration.getPacketCollectorSize());
    }

    protected PacketCollector(XMPPConnection connection, PacketFilter packetFilter, int maxSize) {
        this.connection = connection;
        this.packetFilter = packetFilter;
        this.resultQueue = new ArrayBlockingQueue(maxSize);
    }

    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.connection.removePacketCollector(this);
        }
    }

    public PacketFilter getPacketFilter() {
        return this.packetFilter;
    }

    public <P extends Packet> P pollResult() {
        return (P)this.resultQueue.poll();
    }

    public <P extends Packet> P nextResultBlockForever() {
        Packet res = null;
        while (res == null) {
            try {
                res = this.resultQueue.take();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.FINE, "nextResultBlockForever was interrupted", e);
            }
        }
        return (P)res;
    }

    public <P extends Packet> P nextResult() {
        return this.nextResult(this.connection.getPacketReplyTimeout());
    }

    public <P extends Packet> P nextResult(long timeout) {
        Packet res = null;
        long remainingWait = timeout;
        long waitStart = System.currentTimeMillis();
        while (res == null && remainingWait > 0L) {
            try {
                res = this.resultQueue.poll(remainingWait, TimeUnit.MILLISECONDS);
                remainingWait = timeout - (System.currentTimeMillis() - waitStart);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.FINE, "nextResult was interrupted", e);
            }
        }
        return (P)res;
    }

    public <P extends Packet> P nextResultOrThrow() throws SmackException.NoResponseException, XMPPException.XMPPErrorException {
        return this.nextResultOrThrow(this.connection.getPacketReplyTimeout());
    }

    public <P extends Packet> P nextResultOrThrow(long timeout) throws SmackException.NoResponseException, XMPPException.XMPPErrorException {
        P result = this.nextResult(timeout);
        this.cancel();
        if (result == null) {
            throw new SmackException.NoResponseException(this.connection);
        }
        XMPPException.XMPPErrorException.ifHasErrorThenThrow(result);
        return result;
    }

    protected void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        if (this.packetFilter == null || this.packetFilter.accept(packet)) {
            while (!this.resultQueue.offer(packet)) {
                this.resultQueue.poll();
            }
        }
    }
}

