/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Locale;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.rosterstore.RosterStore;

public abstract class ConnectionConfiguration {
    protected final String serviceName;
    protected final String host;
    protected final int port;
    private final String keystorePath;
    private final String keystoreType;
    private final String pkcs11Library;
    private final SSLContext customSSLContext;
    private final CallbackHandler callbackHandler;
    private final boolean debuggerEnabled;
    private final SocketFactory socketFactory;
    private final String username;
    private final String password;
    private final String resource;
    private final boolean sendPresence;
    private final boolean rosterLoadedAtLogin;
    private final boolean legacySessionDisabled;
    private final SecurityMode securityMode;
    private final String[] enabledSSLProtocols;
    private final String[] enabledSSLCiphers;
    private final HostnameVerifier hostnameVerifier;
    private final RosterStore rosterStore;
    protected final ProxyInfo proxy;
    protected final boolean allowNullOrEmptyUsername;

    protected ConnectionConfiguration(Builder<?, ?> builder) {
        this.username = ((Builder)builder).username != null ? ((Builder)builder).username.toLowerCase(Locale.US).trim() : null;
        this.password = ((Builder)builder).password;
        this.callbackHandler = ((Builder)builder).callbackHandler;
        this.resource = ((Builder)builder).resource;
        this.serviceName = ((Builder)builder).serviceName;
        if (this.serviceName == null) {
            throw new IllegalArgumentException("Must provide XMPP service name");
        }
        this.host = ((Builder)builder).host;
        this.port = ((Builder)builder).port;
        this.proxy = ((Builder)builder).proxy;
        if (this.proxy != null) {
            if (((Builder)builder).socketFactory != null) {
                throw new IllegalArgumentException("Can not use proxy together with custom socket factory");
            }
            this.socketFactory = this.proxy.getSocketFactory();
        } else {
            this.socketFactory = ((Builder)builder).socketFactory;
        }
        this.securityMode = ((Builder)builder).securityMode;
        this.keystoreType = ((Builder)builder).keystoreType;
        this.keystorePath = ((Builder)builder).keystorePath;
        this.pkcs11Library = ((Builder)builder).pkcs11Library;
        this.customSSLContext = ((Builder)builder).customSSLContext;
        this.enabledSSLProtocols = ((Builder)builder).enabledSSLProtocols;
        this.enabledSSLCiphers = ((Builder)builder).enabledSSLCiphers;
        this.hostnameVerifier = ((Builder)builder).hostnameVerifier;
        this.sendPresence = ((Builder)builder).sendPresence;
        this.rosterLoadedAtLogin = ((Builder)builder).rosterLoadedAtLogin;
        this.legacySessionDisabled = ((Builder)builder).legacySessionDisabled;
        this.rosterStore = ((Builder)builder).rosterStore;
        this.debuggerEnabled = ((Builder)builder).debuggerEnabled;
        this.allowNullOrEmptyUsername = ((Builder)builder).allowEmptyOrNullUsername;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public SecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public String getPKCS11Library() {
        return this.pkcs11Library;
    }

    public SSLContext getCustomSSLContext() {
        return this.customSSLContext;
    }

    public String[] getEnabledSSLProtocols() {
        return this.enabledSSLProtocols;
    }

    public String[] getEnabledSSLCiphers() {
        return this.enabledSSLCiphers;
    }

    public HostnameVerifier getHostnameVerifier() {
        if (this.hostnameVerifier != null) {
            return this.hostnameVerifier;
        }
        return SmackConfiguration.getDefaultHostnameVerifier();
    }

    public boolean isDebuggerEnabled() {
        return this.debuggerEnabled;
    }

    public boolean isRosterLoadedAtLogin() {
        return this.rosterLoadedAtLogin;
    }

    public boolean isLegacySessionDisabled() {
        return this.legacySessionDisabled;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public RosterStore getRosterStore() {
        return this.rosterStore;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getResource() {
        return this.resource;
    }

    public boolean isSendPresence() {
        return this.sendPresence;
    }

    public boolean isCompressionEnabled() {
        return false;
    }

    static {
        SmackConfiguration.getVersion();
    }

    public static abstract class Builder<B extends Builder<B, C>, C extends ConnectionConfiguration> {
        private SecurityMode securityMode = SecurityMode.enabled;
        private String keystorePath = System.getProperty("javax.net.ssl.keyStore");
        private String keystoreType = "jks";
        private String pkcs11Library = "pkcs11.config";
        private SSLContext customSSLContext;
        private String[] enabledSSLProtocols;
        private String[] enabledSSLCiphers;
        private HostnameVerifier hostnameVerifier;
        private String username;
        private String password;
        private String resource = "Smack";
        private boolean sendPresence = true;
        private boolean rosterLoadedAtLogin = true;
        private boolean legacySessionDisabled = false;
        private RosterStore rosterStore;
        private ProxyInfo proxy;
        private CallbackHandler callbackHandler;
        private boolean debuggerEnabled = SmackConfiguration.DEBUG_ENABLED;
        private SocketFactory socketFactory;
        private String serviceName;
        private String host;
        private int port = 5222;
        private boolean allowEmptyOrNullUsername = false;

        protected Builder() {
        }

        public B setUsernameAndPassword(String username, String password) {
            this.username = username;
            this.password = password;
            return this.getThis();
        }

        public B setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this.getThis();
        }

        public B setResource(String resource) {
            this.resource = resource;
            return this.getThis();
        }

        public B setHost(String host) {
            this.host = host;
            return this.getThis();
        }

        public B setPort(int port) {
            this.port = port;
            return this.getThis();
        }

        public B setCallbackHandler(CallbackHandler callbackHandler) {
            this.callbackHandler = callbackHandler;
            return this.getThis();
        }

        public B setSecurityMode(SecurityMode securityMode) {
            this.securityMode = securityMode;
            return this.getThis();
        }

        public B setKeystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
            return this.getThis();
        }

        public B setKeystoreType(String keystoreType) {
            this.keystoreType = keystoreType;
            return this.getThis();
        }

        public B setPKCS11Library(String pkcs11Library) {
            this.pkcs11Library = pkcs11Library;
            return this.getThis();
        }

        public B setCustomSSLContext(SSLContext context) {
            this.customSSLContext = context;
            return this.getThis();
        }

        public B setEnabledSSLProtocols(String[] enabledSSLProtocols) {
            this.enabledSSLProtocols = enabledSSLProtocols;
            return this.getThis();
        }

        public B setEnabledSSLCiphers(String[] enabledSSLCiphers) {
            this.enabledSSLCiphers = enabledSSLCiphers;
            return this.getThis();
        }

        public B setHostnameVerifier(HostnameVerifier verifier) {
            this.hostnameVerifier = verifier;
            return this.getThis();
        }

        public B setLegacySessionDisabled(boolean legacySessionDisabled) {
            this.legacySessionDisabled = legacySessionDisabled;
            return this.getThis();
        }

        public B setRosterLoadedAtLogin(boolean rosterLoadedAtLogin) {
            this.rosterLoadedAtLogin = rosterLoadedAtLogin;
            return this.getThis();
        }

        public B setSendPresence(boolean sendPresence) {
            this.sendPresence = sendPresence;
            return this.getThis();
        }

        public B setRosterStore(RosterStore store) {
            this.rosterStore = store;
            return this.getThis();
        }

        public B setDebuggerEnabled(boolean debuggerEnabled) {
            this.debuggerEnabled = debuggerEnabled;
            return this.getThis();
        }

        public B setSocketFactory(SocketFactory socketFactory) {
            this.socketFactory = socketFactory;
            return this.getThis();
        }

        public B allowEmptyOrNullUsernames() {
            this.allowEmptyOrNullUsername = true;
            return this.getThis();
        }

        public abstract C build();

        protected abstract B getThis();
    }

    public static enum SecurityMode {
        required,
        enabled,
        disabled;

    }
}

