/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.debugger;

import java.io.Reader;
import java.io.Writer;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.ObservableReader;
import org.jivesoftware.smack.util.ObservableWriter;
import org.jivesoftware.smack.util.ReaderListener;
import org.jivesoftware.smack.util.WriterListener;
import org.jxmpp.util.XmppStringUtils;

public abstract class AbstractDebugger
implements SmackDebugger {
    public static boolean printInterpreted = false;
    private final XMPPConnection connection;
    private final PacketListener listener;
    private final ConnectionListener connListener;
    private final ReaderListener readerListener;
    private final WriterListener writerListener;
    private ObservableWriter writer;
    private ObservableReader reader;

    public AbstractDebugger(final XMPPConnection connection, Writer writer, Reader reader) {
        this.connection = connection;
        this.reader = new ObservableReader(reader);
        this.readerListener = new ReaderListener(){

            @Override
            public void read(String str) {
                AbstractDebugger.this.log("RECV (" + connection.getConnectionCounter() + "): " + str);
            }
        };
        this.reader.addReaderListener(this.readerListener);
        this.writer = new ObservableWriter(writer);
        this.writerListener = new WriterListener(){

            @Override
            public void write(String str) {
                AbstractDebugger.this.log("SENT (" + connection.getConnectionCounter() + "): " + str);
            }
        };
        this.writer.addWriterListener(this.writerListener);
        this.listener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                if (printInterpreted) {
                    AbstractDebugger.this.log("RCV PKT (" + connection.getConnectionCounter() + "): " + packet.toXML());
                }
            }
        };
        this.connListener = new ConnectionListener(){

            @Override
            public void connected(XMPPConnection connection2) {
                AbstractDebugger.this.log("XMPPConnection connected (" + connection2.getConnectionCounter() + ")");
            }

            @Override
            public void authenticated(XMPPConnection connection2, boolean resumed) {
                String logString = "XMPPConnection authenticated (" + connection2.getConnectionCounter() + ")";
                if (resumed) {
                    logString = logString + " and resumed";
                }
                AbstractDebugger.this.log(logString);
            }

            @Override
            public void connectionClosed() {
                AbstractDebugger.this.log("XMPPConnection closed (" + connection.getConnectionCounter() + ")");
            }

            @Override
            public void connectionClosedOnError(Exception e) {
                AbstractDebugger.this.log("XMPPConnection closed due to an exception (" + connection.getConnectionCounter() + ")");
                e.printStackTrace();
            }

            @Override
            public void reconnectionFailed(Exception e) {
                AbstractDebugger.this.log("Reconnection failed due to an exception (" + connection.getConnectionCounter() + ")");
                e.printStackTrace();
            }

            @Override
            public void reconnectionSuccessful() {
                AbstractDebugger.this.log("XMPPConnection reconnected (" + connection.getConnectionCounter() + ")");
            }

            @Override
            public void reconnectingIn(int seconds) {
                AbstractDebugger.this.log("XMPPConnection (" + connection.getConnectionCounter() + ") will reconnect in " + seconds);
            }
        };
    }

    protected abstract void log(String var1);

    @Override
    public Reader newConnectionReader(Reader newReader) {
        this.reader.removeReaderListener(this.readerListener);
        ObservableReader debugReader = new ObservableReader(newReader);
        debugReader.addReaderListener(this.readerListener);
        this.reader = debugReader;
        return this.reader;
    }

    @Override
    public Writer newConnectionWriter(Writer newWriter) {
        this.writer.removeWriterListener(this.writerListener);
        ObservableWriter debugWriter = new ObservableWriter(newWriter);
        debugWriter.addWriterListener(this.writerListener);
        this.writer = debugWriter;
        return this.writer;
    }

    @Override
    public void userHasLogged(String user) {
        String localpart = XmppStringUtils.parseLocalpart((String)user);
        boolean isAnonymous = "".equals(localpart);
        String title = "User logged (" + this.connection.getConnectionCounter() + "): " + (isAnonymous ? "" : localpart) + "@" + this.connection.getServiceName() + ":" + this.connection.getPort();
        title = title + "/" + XmppStringUtils.parseResource((String)user);
        this.log(title);
        this.connection.addConnectionListener(this.connListener);
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public PacketListener getReaderListener() {
        return this.listener;
    }

    @Override
    public PacketListener getWriterListener() {
        return null;
    }
}

