/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import java.util.Locale;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jxmpp.util.XmppStringUtils;

public class FromMatchesFilter
implements PacketFilter {
    private final String address;
    private final boolean matchBareJID;

    public FromMatchesFilter(String address, boolean matchBare) {
        this.address = address == null ? null : address.toLowerCase(Locale.US);
        this.matchBareJID = matchBare;
    }

    public static FromMatchesFilter create(String address) {
        return new FromMatchesFilter(address, "".equals(XmppStringUtils.parseResource((String)address)));
    }

    public static FromMatchesFilter createBare(String address) {
        address = address == null ? null : XmppStringUtils.parseBareJid((String)address);
        return new FromMatchesFilter(address, true);
    }

    public static FromMatchesFilter createFull(String address) {
        return new FromMatchesFilter(address, false);
    }

    @Override
    public boolean accept(Packet packet) {
        String from = packet.getFrom();
        if (from == null) {
            return this.address == null;
        }
        from = from.toLowerCase(Locale.US);
        if (this.matchBareJID) {
            from = XmppStringUtils.parseBareJid((String)from);
        }
        return from.equals(this.address);
    }

    public String toString() {
        String matchMode = this.matchBareJID ? "bare" : "full";
        return "FromMatchesFilter (" + matchMode + "): " + this.address;
    }
}

