/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Locale;
import org.jivesoftware.smack.packet.EmptyResultIQ;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.XmlStringBuilder;

public abstract class IQ
extends Packet {
    public static final String IQ_ELEMENT = "iq";
    public static final String QUERY_ELEMENT = "query";
    private final String childElementName;
    private final String childElementNamespace;
    protected Type type = Type.get;

    public IQ(IQ iq) {
        super(iq);
        this.type = iq.getType();
        this.childElementName = iq.childElementName;
        this.childElementNamespace = iq.childElementNamespace;
    }

    protected IQ(String childElementName) {
        this(childElementName, null);
    }

    protected IQ(String childElementName, String childElementNamespace) {
        this.childElementName = childElementName;
        this.childElementNamespace = childElementNamespace;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type == null ? Type.get : type;
    }

    public final String getChildElementName() {
        return this.childElementName;
    }

    public final String getChildElementNamespace() {
        return this.childElementNamespace;
    }

    @Override
    public final XmlStringBuilder toXML() {
        XmlStringBuilder buf = new XmlStringBuilder();
        buf.halfOpenElement(IQ_ELEMENT);
        this.addCommonAttributes(buf);
        if (this.type == null) {
            buf.attribute("type", "get");
        } else {
            buf.attribute("type", this.type.toString());
        }
        buf.rightAngleBracket();
        buf.append(this.getChildElementXML());
        buf.closeElement(IQ_ELEMENT);
        return buf;
    }

    public final XmlStringBuilder getChildElementXML() {
        IQChildElementXmlStringBuilder iqChildElement;
        XmlStringBuilder xml = new XmlStringBuilder();
        if (this.type == Type.error) {
            this.appendErrorIfExists(xml);
        } else if (this.childElementName != null && (iqChildElement = this.getIQChildElementBuilder(new IQChildElementXmlStringBuilder(this))) != null) {
            xml.append(iqChildElement);
            XmlStringBuilder extensionsXml = this.getExtensionsXML();
            if (iqChildElement.isEmptyElement) {
                if (extensionsXml.length() == 0) {
                    xml.closeEmptyElement();
                    return xml;
                }
                xml.rightAngleBracket();
            }
            xml.append(extensionsXml);
            xml.closeElement(iqChildElement.element);
        }
        return xml;
    }

    protected abstract IQChildElementXmlStringBuilder getIQChildElementBuilder(IQChildElementXmlStringBuilder var1);

    public static IQ createResultIQ(IQ request) {
        return new EmptyResultIQ(request);
    }

    public static ErrorIQ createErrorResponse(IQ request, XMPPError error) {
        if (request.getType() != Type.get && request.getType() != Type.set) {
            throw new IllegalArgumentException("IQ must be of type 'set' or 'get'. Original IQ: " + request.toXML());
        }
        ErrorIQ result = new ErrorIQ(error);
        result.setPacketID(request.getPacketID());
        result.setFrom(request.getTo());
        result.setTo(request.getFrom());
        return result;
    }

    public static class IQChildElementXmlStringBuilder
    extends XmlStringBuilder {
        private final String element;
        private boolean isEmptyElement;

        private IQChildElementXmlStringBuilder(IQ iq) {
            this(iq.getChildElementName(), iq.getChildElementNamespace());
        }

        public IQChildElementXmlStringBuilder(PacketExtension pe) {
            this(pe.getElementName(), pe.getNamespace());
        }

        private IQChildElementXmlStringBuilder(String element, String namespace) {
            this.prelude(element, namespace);
            this.element = element;
        }

        public void setEmptyElement() {
            this.isEmptyElement = true;
        }
    }

    public static enum Type {
        get,
        set,
        result,
        error;


        public static Type fromString(String string) {
            return Type.valueOf(string.toLowerCase(Locale.US));
        }
    }
}

