/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class IntrospectionProvider {
    /*
     * Enabled aggressive block sorting
     */
    public static Object parseWithIntrospection(Class<?> objectClass, XmlPullParser parser, int initialDepth) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, XmlPullParserException, IOException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException {
        ParserUtils.assertAtStartTag(parser);
        Object object = objectClass.newInstance();
        block4: while (true) {
            int eventType = parser.next();
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    String stringValue = parser.nextText();
                    Class<?> propertyType = object.getClass().getMethod("get" + Character.toUpperCase(name.charAt(0)) + name.substring(1), new Class[0]).getReturnType();
                    Object value = IntrospectionProvider.decode(propertyType, stringValue);
                    object.getClass().getMethod("set" + Character.toUpperCase(name.charAt(0)) + name.substring(1), propertyType).invoke(object, value);
                    break;
                }
                case 3: {
                    if (parser.getDepth() == initialDepth) break block4;
                }
            }
        }
        ParserUtils.assertAtEndTag(parser);
        return object;
    }

    private static Object decode(Class<?> type, String value) throws ClassNotFoundException {
        if (type.getName().equals("java.lang.String")) {
            return value;
        }
        if (type.getName().equals("boolean")) {
            return Boolean.valueOf(value);
        }
        if (type.getName().equals("int")) {
            return Integer.valueOf(value);
        }
        if (type.getName().equals("long")) {
            return Long.valueOf(value);
        }
        if (type.getName().equals("float")) {
            return Float.valueOf(value);
        }
        if (type.getName().equals("double")) {
            return Double.valueOf(value);
        }
        if (type.getName().equals("java.lang.Class")) {
            return Class.forName(value);
        }
        return null;
    }

    public static abstract class PacketExtensionIntrospectionProvider<PE extends PacketExtension>
    extends PacketExtensionProvider<PE> {
        private final Class<PE> elementClass;

        protected PacketExtensionIntrospectionProvider(Class<PE> elementClass) {
            this.elementClass = elementClass;
        }

        @Override
        public PE parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackException {
            try {
                return (PE)((PacketExtension)IntrospectionProvider.parseWithIntrospection(this.elementClass, parser, initialDepth));
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new SmackException(e);
            }
        }
    }

    public static abstract class IQIntrospectionProvider<I extends IQ>
    extends IQProvider<I> {
        private final Class<I> elementClass;

        protected IQIntrospectionProvider(Class<I> elementClass) {
            this.elementClass = elementClass;
        }

        @Override
        public I parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackException {
            try {
                return (I)((IQ)IntrospectionProvider.parseWithIntrospection(this.elementClass, parser, initialDepth));
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new SmackException(e);
            }
        }
    }
}

