/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.ExtensionProviderInfo;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.IQProviderInfo;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderLoader;
import org.jivesoftware.smack.provider.StreamFeatureProviderInfo;
import org.jivesoftware.smack.util.StringUtils;
import org.jxmpp.util.XmppStringUtils;

public final class ProviderManager {
    private static final Map<String, PacketExtensionProvider<PacketExtension>> extensionProviders = new ConcurrentHashMap<String, PacketExtensionProvider<PacketExtension>>();
    private static final Map<String, IQProvider<IQ>> iqProviders = new ConcurrentHashMap<String, IQProvider<IQ>>();
    private static final Map<String, PacketExtensionProvider<PacketExtension>> streamFeatureProviders = new ConcurrentHashMap<String, PacketExtensionProvider<PacketExtension>>();

    public static void addLoader(ProviderLoader loader) {
        if (loader.getIQProviderInfo() != null) {
            for (IQProviderInfo iQProviderInfo : loader.getIQProviderInfo()) {
                ProviderManager.addIQProvider(iQProviderInfo.getElementName(), iQProviderInfo.getNamespace(), iQProviderInfo.getProvider());
            }
        }
        if (loader.getExtensionProviderInfo() != null) {
            for (ExtensionProviderInfo extensionProviderInfo : loader.getExtensionProviderInfo()) {
                ProviderManager.addExtensionProvider(extensionProviderInfo.getElementName(), extensionProviderInfo.getNamespace(), extensionProviderInfo.getProvider());
            }
        }
        if (loader.getStreamFeatureProviderInfo() != null) {
            for (StreamFeatureProviderInfo streamFeatureProviderInfo : loader.getStreamFeatureProviderInfo()) {
                ProviderManager.addStreamFeatureProvider(streamFeatureProviderInfo.getElementName(), streamFeatureProviderInfo.getNamespace(), (PacketExtensionProvider)streamFeatureProviderInfo.getProvider());
            }
        }
    }

    public static IQProvider<IQ> getIQProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        return iqProviders.get(key);
    }

    public static List<IQProvider<IQ>> getIQProviders() {
        ArrayList<IQProvider<IQ>> providers = new ArrayList<IQProvider<IQ>>(iqProviders.size());
        providers.addAll(iqProviders.values());
        return providers;
    }

    public static void addIQProvider(String elementName, String namespace, Object provider) {
        ProviderManager.validate(elementName, namespace);
        String key = ProviderManager.removeIQProvider(elementName, namespace);
        if (!(provider instanceof IQProvider)) {
            throw new IllegalArgumentException("Provider must be an IQProvider");
        }
        iqProviders.put(key, (IQProvider)provider);
    }

    public static String removeIQProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        iqProviders.remove(key);
        return key;
    }

    public static PacketExtensionProvider<PacketExtension> getExtensionProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        return extensionProviders.get(key);
    }

    public static void addExtensionProvider(String elementName, String namespace, Object provider) {
        ProviderManager.validate(elementName, namespace);
        String key = ProviderManager.removeExtensionProvider(elementName, namespace);
        if (!(provider instanceof PacketExtensionProvider)) {
            throw new IllegalArgumentException("Provider must be a PacketExtensionProvider");
        }
        extensionProviders.put(key, (PacketExtensionProvider)provider);
    }

    public static String removeExtensionProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        extensionProviders.remove(key);
        return key;
    }

    public static List<PacketExtensionProvider<PacketExtension>> getExtensionProviders() {
        ArrayList<PacketExtensionProvider<PacketExtension>> providers = new ArrayList<PacketExtensionProvider<PacketExtension>>(extensionProviders.size());
        providers.addAll(extensionProviders.values());
        return providers;
    }

    public static PacketExtensionProvider<PacketExtension> getStreamFeatureProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        return streamFeatureProviders.get(key);
    }

    public static void addStreamFeatureProvider(String elementName, String namespace, PacketExtensionProvider<PacketExtension> provider) {
        ProviderManager.validate(elementName, namespace);
        String key = ProviderManager.getKey(elementName, namespace);
        streamFeatureProviders.put(key, provider);
    }

    public static void removeStreamFeatureProvider(String elementName, String namespace) {
        String key = ProviderManager.getKey(elementName, namespace);
        streamFeatureProviders.remove(key);
    }

    private static String getKey(String elementName, String namespace) {
        return XmppStringUtils.generateKey((String)elementName, (String)namespace);
    }

    private static void validate(String elementName, String namespace) {
        if (StringUtils.isNullOrEmpty(elementName)) {
            throw new IllegalArgumentException("elementName must not be null or empty");
        }
        if (StringUtils.isNullOrEmpty(namespace)) {
            throw new IllegalArgumentException("namespace must not be null or empty");
        }
    }

    static {
        SmackConfiguration.getVersion();
    }
}

