/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.util.Objects;

public abstract class AbstractListFilter
implements PacketFilter {
    protected final List<PacketFilter> filters;

    protected AbstractListFilter() {
        this.filters = new ArrayList<PacketFilter>();
    }

    protected AbstractListFilter(PacketFilter ... filters) {
        Objects.requireNonNull(filters, "Parameter must not be null.");
        for (PacketFilter filter : filters) {
            Objects.requireNonNull(filter, "Parameter must not be null.");
        }
        this.filters = new ArrayList<PacketFilter>(Arrays.asList(filters));
    }

    public void addFilter(PacketFilter filter) {
        Objects.requireNonNull(filter, "Parameter must not be null.");
        this.filters.add(filter);
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" (");
        for (PacketFilter filter : this.filters) {
            sb.append(' ' + filter.toString() + ',');
        }
        sb.append(")");
        return sb.toString();
    }
}

