/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import java.lang.reflect.ParameterizedType;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.Objects;

public abstract class FlexiblePacketTypeFilter<P extends Stanza>
implements PacketFilter {
    protected final Class<P> packetType;

    public FlexiblePacketTypeFilter(Class<P> packetType) {
        this.packetType = Objects.requireNonNull(packetType, "Type must not be null");
    }

    public FlexiblePacketTypeFilter() {
        this.packetType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Override
    public boolean accept(Stanza packet) {
        if (this.packetType.isInstance(packet)) {
            return this.acceptSpecific(packet);
        }
        return false;
    }

    protected abstract boolean acceptSpecific(P var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" (" + this.packetType.toString() + ')');
        return sb.toString();
    }
}

