/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.StringUtils;

public class PacketExtensionFilter
implements PacketFilter {
    private final String elementName;
    private final String namespace;

    public PacketExtensionFilter(String elementName, String namespace) {
        StringUtils.requireNotNullOrEmpty(namespace, "namespace must not be null or empty");
        this.elementName = elementName;
        this.namespace = namespace;
    }

    public PacketExtensionFilter(String namespace) {
        this(null, namespace);
    }

    public PacketExtensionFilter(PacketExtension packetExtension) {
        this(packetExtension.getElementName(), packetExtension.getNamespace());
    }

    @Override
    public boolean accept(Stanza packet) {
        return packet.hasExtension(this.elementName, this.namespace);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": element=" + this.elementName + " namespace=" + this.namespace;
    }
}

