/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.packet.id.StanzaIdUtil;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.PacketUtil;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jxmpp.util.XmppStringUtils;

public abstract class Stanza
implements TopLevelStreamElement,
Packet {
    public static final String TEXT = "text";
    public static final String ITEM = "item";
    protected static final String DEFAULT_LANGUAGE = Locale.getDefault().getLanguage().toLowerCase(Locale.US);
    private final MultiMap<String, PacketExtension> packetExtensions = new MultiMap();
    private String id = null;
    private String to = null;
    private String from = null;
    private XMPPError error = null;
    protected String language;

    public Stanza() {
        this(StanzaIdUtil.newStanzaId());
    }

    public Stanza(String stanzaId) {
        this.setStanzaId(stanzaId);
    }

    public Stanza(Stanza p) {
        this.id = p.getStanzaId();
        this.to = p.getTo();
        this.from = p.getFrom();
        this.error = p.error;
        for (PacketExtension pe : p.getExtensions()) {
            this.addExtension(pe);
        }
    }

    @Override
    public String getStanzaId() {
        return this.id;
    }

    @Override
    @Deprecated
    public String getPacketID() {
        return this.getStanzaId();
    }

    @Override
    public void setStanzaId(String id) {
        if (id != null) {
            StringUtils.requireNotNullOrEmpty(id, "id must either be null or not the empty String");
        }
        this.id = id;
    }

    @Override
    @Deprecated
    public void setPacketID(String packetID) {
        this.setStanzaId(packetID);
    }

    public boolean hasStanzaIdSet() {
        return this.id != null;
    }

    @Override
    public String getTo() {
        return this.to;
    }

    @Override
    public void setTo(String to) {
        this.to = to;
    }

    @Override
    public String getFrom() {
        return this.from;
    }

    @Override
    public void setFrom(String from) {
        this.from = from;
    }

    @Override
    public XMPPError getError() {
        return this.error;
    }

    @Override
    public void setError(XMPPError error) {
        this.error = error;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PacketExtension> getExtensions() {
        MultiMap<String, PacketExtension> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            return this.packetExtensions.values();
        }
    }

    @Override
    public Set<PacketExtension> getExtensions(String elementName, String namespace) {
        StringUtils.requireNotNullOrEmpty(elementName, "elementName must not be null or empty");
        StringUtils.requireNotNullOrEmpty(namespace, "namespace must not be null or empty");
        String key = XmppStringUtils.generateKey((String)elementName, (String)namespace);
        return this.packetExtensions.getAll(key);
    }

    @Override
    public PacketExtension getExtension(String namespace) {
        return PacketUtil.extensionElementFrom(this.getExtensions(), null, namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <PE extends PacketExtension> PE getExtension(String elementName, String namespace) {
        PacketExtension packetExtension;
        if (namespace == null) {
            return null;
        }
        String key = XmppStringUtils.generateKey((String)elementName, (String)namespace);
        MultiMap<String, PacketExtension> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            packetExtension = this.packetExtensions.getFirst(key);
        }
        if (packetExtension == null) {
            return null;
        }
        return (PE)packetExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExtension(PacketExtension extension) {
        if (extension == null) {
            return;
        }
        String key = XmppStringUtils.generateKey((String)extension.getElementName(), (String)extension.getNamespace());
        MultiMap<String, PacketExtension> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            this.packetExtensions.put(key, extension);
        }
    }

    @Override
    public void addExtensions(Collection<PacketExtension> extensions) {
        if (extensions == null) {
            return;
        }
        for (PacketExtension packetExtension : extensions) {
            this.addExtension(packetExtension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasExtension(String elementName, String namespace) {
        if (elementName == null) {
            return this.hasExtension(namespace);
        }
        String key = XmppStringUtils.generateKey((String)elementName, (String)namespace);
        MultiMap<String, PacketExtension> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            return this.packetExtensions.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasExtension(String namespace) {
        MultiMap<String, PacketExtension> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            for (PacketExtension packetExtension : this.packetExtensions.values()) {
                if (!packetExtension.getNamespace().equals(namespace)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PacketExtension removeExtension(String elementName, String namespace) {
        String key = XmppStringUtils.generateKey((String)elementName, (String)namespace);
        MultiMap<String, PacketExtension> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            return this.packetExtensions.remove(key);
        }
    }

    @Override
    public PacketExtension removeExtension(PacketExtension extension) {
        return this.removeExtension(extension.getElementName(), extension.getNamespace());
    }

    @Override
    public String toString() {
        return this.toXML().toString();
    }

    protected final XmlStringBuilder getExtensionsXML() {
        XmlStringBuilder xml = new XmlStringBuilder();
        for (PacketExtension extension : this.getExtensions()) {
            xml.append(extension.toXML());
        }
        return xml;
    }

    public static String getDefaultLanguage() {
        return DEFAULT_LANGUAGE;
    }

    protected void addCommonAttributes(XmlStringBuilder xml) {
        xml.optAttribute("to", this.getTo());
        xml.optAttribute("from", this.getFrom());
        xml.optAttribute("id", this.getStanzaId());
        xml.xmllangAttribute(this.getLanguage());
    }

    protected void appendErrorIfExists(XmlStringBuilder xml) {
        XMPPError error = this.getError();
        if (error != null) {
            xml.append(error.toXML());
        }
    }
}

