/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class EmbeddedExtensionProvider<PE extends PacketExtension>
extends PacketExtensionProvider<PE> {
    @Override
    public final PE parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackException {
        int event;
        String namespace = parser.getNamespace();
        String name = parser.getName();
        int attributeCount = parser.getAttributeCount();
        HashMap<String, String> attMap = new HashMap<String, String>(attributeCount);
        for (int i = 0; i < attributeCount; ++i) {
            attMap.put(parser.getAttributeName(i), parser.getAttributeValue(i));
        }
        ArrayList<PacketExtension> extensions = new ArrayList<PacketExtension>();
        do {
            if ((event = parser.next()) != 2) continue;
            PacketParserUtils.addPacketExtension(extensions, parser);
        } while (event != 3 || parser.getDepth() != initialDepth);
        return this.createReturnExtension(name, namespace, attMap, extensions);
    }

    protected abstract PE createReturnExtension(String var1, String var2, Map<String, String> var3, List<? extends PacketExtension> var4);
}

